/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.roles;

import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.admin.roles.ViewUserProjectRoles;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import webwork.action.ActionContext;

@WebSudoRequired
public class EditUserProjectRoles
extends ViewUserProjectRoles {
    public EditUserProjectRoles(ProjectManager projectManager, ProjectRoleService projectRoleService, ProjectFactory projectFactory) {
        super(projectManager, projectRoleService, projectFactory);
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Map parameters = ActionContext.getParameters();
        Set<String> projectIds = this.getShownProjectIds();
        Collection<Project> projectsToUpdate = this.getProjectsFromIds(projectIds);
        for (Project project : projectsToUpdate) {
            for (ProjectRole projectRole : this.getAllProjectRoles()) {
                this.updateRoleActorsForProjectRole(project, projectRole, parameters);
            }
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        return this.forceRedirect("ViewUserProjectRoles.jspa?name=" + JiraUrlCodec.encode((String)this.name));
    }

    public String doRefresh() {
        Set<String> projectIds = this.getShownProjectIds();
        String[] projectsToAdd = (String[])ActionContext.getParameters().get("projects_to_add");
        if (projectsToAdd != null) {
            String projectIdsToAddValue = projectsToAdd[0];
            String[] projectIdsToAdd = projectIdsToAddValue.split(",");
            List<String> addIds = Arrays.asList(projectIdsToAdd);
            projectIds.addAll(addIds);
        }
        this.currentVisibleProjects = this.getProjectsFromIds(projectIds);
        return "success";
    }

    public boolean isAllProjectsInCategoryVisible(ProjectCategory projectCategory) {
        ArrayList<Project> projects = new ArrayList<Project>(this.getAllProjectsForCategory(projectCategory));
        Collection<Project> visibleProjects = this.getCurrentVisibleProjects();
        projects.removeAll(visibleProjects);
        return projects.isEmpty();
    }

    public boolean isAllProjectsWithoutCategoryVisible() {
        ArrayList<Project> projects = new ArrayList<Project>(this.getAllProjectsWithoutCategory());
        Collection<Project> visibleProjects = this.getCurrentVisibleProjects();
        projects.removeAll(visibleProjects);
        return projects.isEmpty();
    }

    public boolean isAllProjectsVisible() {
        if (!this.isAllProjectsWithoutCategoryVisible()) {
            return false;
        }
        for (ProjectCategory category : this.getAllProjectCategories()) {
            if (this.isAllProjectsInCategoryVisible(category)) continue;
            return false;
        }
        return true;
    }

    public Collection<Project> getAllProjectsWithoutCategory() {
        return this.projectManager.getProjectObjectsWithNoCategory();
    }

    private Set<String> getShownProjectIds() {
        HashSet<String> projectIds = new HashSet<String>();
        String[] shownProjectIds = (String[])ActionContext.getParameters().get("project_shown");
        List<Object> shownIds = shownProjectIds == null ? new ArrayList() : Arrays.asList(shownProjectIds);
        projectIds.addAll(shownIds);
        return projectIds;
    }

    private Collection<Project> getProjectsFromIds(Set<String> shownProjects) {
        ArrayList<Long> projectIds = new ArrayList<Long>(shownProjects.size());
        for (String projectIdString : shownProjects) {
            projectIds.add(new Long(projectIdString));
        }
        return this.projectManager.convertToProjectObjects(projectIds);
    }

    private void updateRoleActorsForProjectRole(Project project, ProjectRole projectRole, Map parameters) {
        String key = project.getId() + "_" + projectRole.getId();
        String[] origParam = (String[])parameters.get(key + "_orig");
        boolean origValue = Boolean.valueOf(origParam[0]);
        String[] newValue = (String[])parameters.get(key);
        if (newValue == null && origValue) {
            this.projectRoleService.removeActorsFromProjectRole(Arrays.asList(this.getUserKey()), projectRole, project, "atlassian-user-role-actor", (ErrorCollection)this);
        } else if (newValue != null && !origValue) {
            this.projectRoleService.addActorsToProjectRole(Arrays.asList(this.getUserKey()), projectRole, project, "atlassian-user-role-actor", (ErrorCollection)this);
        }
    }

    private String getUserKey() {
        ApplicationUser userObject = this.getUserManager().getUserByName(this.name);
        if (userObject == null) {
            return null;
        }
        return userObject.getKey();
    }
}

