/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.statuses;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.SimpleStatusImpl;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.admin.constants.AbstractViewConstants;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class ViewStatuses
extends AbstractViewConstants<Status> {
    @VisibleForTesting
    static final String NEW_STATUS_DEFAULT_ICON = "/images/icons/statuses/generic.png";
    public static final String STATUS_ENTITY_NAME = "Status";
    private static final String CATEGORY_HELP_UTIL_KEY = "statuses";
    private final StatusService statusService;
    private final ConstantsService constantsService;
    private final WorkflowManager workflowManager;
    private Long statusCategory;
    private String id;
    private static final Function<JiraWorkflow, String> GET_WORKFLOW_NAME = new Function<JiraWorkflow, String>(){

        public String apply(@Nullable JiraWorkflow input) {
            return input.getName();
        }
    };

    @Deprecated
    public ViewStatuses(TranslationManager translationManager, StatusManager statusManager, WorkflowManager workflowManager) {
        super(translationManager);
        this.workflowManager = workflowManager;
        this.setIconurl(NEW_STATUS_DEFAULT_ICON);
        this.statusService = (StatusService)ComponentAccessor.getComponent(StatusService.class);
        this.constantsService = (ConstantsService)ComponentAccessor.getComponent(ConstantsService.class);
    }

    public ViewStatuses(TranslationManager translationManager, StatusService statusService, ConstantsService constantsService, I18nHelper i18nHelper, WorkflowManager workflowManager) {
        super(translationManager);
        this.statusService = statusService;
        this.constantsService = constantsService;
        this.workflowManager = workflowManager;
        this.setIconurl(NEW_STATUS_DEFAULT_ICON);
    }

    @Override
    protected String getConstantEntityName() {
        return STATUS_ENTITY_NAME;
    }

    @Override
    protected String getNiceConstantName() {
        return "status";
    }

    @Override
    protected String getIssueConstantField() {
        return this.getText("admin.issue.constant.status.lowercase");
    }

    @Override
    protected Status getConstant(String id) {
        return this.getConstantsManager().getStatusObject(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewStatuses.jspa";
    }

    @Override
    protected Collection<Status> getConstants() {
        return this.getConstantsManager().getStatusObjects();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshStatuses();
    }

    public Long getStatusCategory() {
        return this.statusCategory;
    }

    public void setStatusCategory(Long statusCategory) {
        this.statusCategory = statusCategory;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @RequiresXsrfCheck
    public String doAddStatus() throws Exception {
        ServiceResult validationResult = this.statusService.validateCreateStatus(this.getLoggedInUser(), this.name, this.description, this.getIconurl(), this.getStatusCategoryObject());
        this.addErrorCollection(validationResult.getErrorCollection());
        if (this.hasAnyErrors()) {
            return "error";
        }
        return super.doAddConstant();
    }

    @ActionViewData(key="status")
    public SimpleStatus getStatusFormValues() {
        return new SimpleStatusImpl(null, this.getName(), this.getDescription(), this.getStatusCategoryObject(), this.getIconurl());
    }

    @ActionViewData
    public Collection<SimpleStatus> getStatuses() {
        List workflows = this.workflowManager.getWorkflowsIncludingDrafts();
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.getConstantsManager().getStatusObjects(), (Function)new StatusMappingFunction(workflows)));
    }

    @Override
    @ActionViewData(key="isTranslatable")
    public boolean isTranslatable() {
        return super.isTranslatable();
    }

    @ActionViewData(key="isIconUrlFieldVisible")
    public boolean isIconUrlFieldVisible() {
        return !this.getStatusLozengeEnabled();
    }

    @ActionViewDataMappings(value={"success", "error"})
    public Map<String, Object> outputErrorsForSoy() {
        return MapBuilder.newBuilder().add((Object)"errors", (Object)super.getErrors()).toMap();
    }

    @ActionViewData
    public String getToken() {
        return super.getXsrfToken();
    }

    @ActionViewData
    public HelpUtil.HelpPath getStatusCategoryHelpData() {
        return HelpUtil.getInstance().getHelpPath(CATEGORY_HELP_UTIL_KEY);
    }

    @ActionViewData(key="isNew")
    public boolean isNew() {
        return true;
    }

    @Override
    protected String redirectToView() {
        return this.returnCompleteWithInlineRedirect("ViewStatuses.jspa");
    }

    @Override
    protected String getDefaultPropertyName() {
        return "jira.constant.default.status";
    }

    @Override
    protected void addConstant() throws GenericEntityException {
        StatusCategory statusCategoryObject = this.getStatusCategoryObject();
        this.statusService.createStatus(this.getLoggedInUser(), this.name, this.description, this.getIconurl(), statusCategoryObject);
    }

    private StatusCategory getStatusCategoryObject() {
        StatusCategory statusCategoryObject = this.getStatusLozengeEnabled() ? (StatusCategory)this.constantsService.getStatusCategoryById(this.getLoggedInUser(), String.valueOf(this.statusCategory)).getReturnedValue() : (StatusCategory)this.constantsService.getDefaultStatusCategory(this.getLoggedInUser()).getReturnedValue();
        return statusCategoryObject;
    }

    public boolean getStatusLozengeEnabled() {
        return this.constantsService.isStatusAsLozengeEnabled();
    }

    @ActionViewData
    public Collection<Map<String, Object>> getStatusCategoryOptions() {
        ImmutableList options = Collections.emptyList();
        if (this.getStatusLozengeEnabled()) {
            Collection sc = (Collection)this.constantsService.getUserVisibleStatusCategories(this.getLoggedInUser()).getReturnedValue();
            options = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)sc, (Function)new Function<StatusCategory, Map<String, Object>>(){

                public Map<String, Object> apply(@Nullable StatusCategory input) {
                    MapBuilder builder = MapBuilder.newBuilder();
                    if (null != input) {
                        builder.add((Object)"text", (Object)input.getTranslatedName(ViewStatuses.this.getI18nHelper()));
                        builder.add((Object)"value", (Object)input.getId());
                        builder.add((Object)"key", (Object)input.getKey());
                        builder.add((Object)"colorName", (Object)input.getColorName());
                        builder.add((Object)"sequence", (Object)input.getSequence());
                        builder.add((Object)"selected", (Object)(null != input.getId() && input.getId().equals(ViewStatuses.this.getStatusCategory()) ? 1 : 0));
                    }
                    return builder.toMap();
                }
            }));
        }
        return options;
    }

    public String doMoveUp() {
        this.statusService.moveStatusUp(this.getLoggedInUser(), this.up);
        return this.redirectToView();
    }

    public String doMoveDown() {
        this.statusService.moveStatusDown(this.getLoggedInUser(), this.down);
        return this.redirectToView();
    }

    public static Predicate<Map.Entry<JiraWorkflow, Set<String>>> containsStatus(final Status status) {
        return new Predicate<Map.Entry<JiraWorkflow, Set<String>>>(){

            public boolean apply(Map.Entry<JiraWorkflow, Set<String>> input) {
                return input.getValue().contains(status.getId());
            }
        };
    }

    private class StatusMappingFunction
    implements Function<Status, SimpleStatus> {
        private final Map<JiraWorkflow, Set<String>> workflowToStatusIds;

        private StatusMappingFunction(List<JiraWorkflow> allWorkflows) {
            HashMap<JiraWorkflow, Set> workflowToStatusIds = new HashMap<JiraWorkflow, Set>(allWorkflows.size());
            for (JiraWorkflow workflow : allWorkflows) {
                workflowToStatusIds.put(workflow, workflow.getLinkedStatusIds());
            }
            this.workflowToStatusIds = ImmutableMap.copyOf(workflowToStatusIds);
        }

        public SimpleStatus apply(Status status) {
            return new SimpleStatusMap(status, this.getWorkflows(status));
        }

        public Set<JiraWorkflow> getWorkflows(Status status) {
            return Maps.filterEntries(this.workflowToStatusIds, ViewStatuses.containsStatus(status)).keySet();
        }
    }

    public class SimpleStatusMap
    extends SimpleStatusImpl
    implements SimpleStatus {
        private final Collection<String> workflows;
        private final boolean isActive;

        public SimpleStatusMap(@Nonnull Status status, Set<JiraWorkflow> workflows) {
            super(status);
            this.workflows = ImmutableSet.copyOf((Iterable)Iterables.transform(workflows, (Function)GET_WORKFLOW_NAME));
            this.isActive = workflows.size() > 0;
        }

        public Collection<String> getWorkflows() {
            return this.workflows;
        }

        public boolean getIsActive() {
            return this.isActive;
        }
    }
}

