/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.dbc.Null;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordChangeService {
    private static final Logger log = LoggerFactory.getLogger(PasswordChangeService.class);
    private final UserUtil userUtil;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public PasswordChangeService(UserUtil userUtil, JiraAuthenticationContext jiraAuthenticationContext) {
        this.userUtil = userUtil;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void setPassword(ErrorCollection errorCollection, ApplicationUser user, String newPassword) {
        Null.not("user", user);
        try {
            this.setPasswordImpl(user, newPassword);
        }
        catch (Exception e) {
            String msg = e.getMessage() == null ? "" : e.getMessage();
            log.error("Exception occurred whilst resetting password " + msg, (Throwable)e);
            String errorMessage = this.jiraAuthenticationContext.getI18nHelper().getText("admin.setpassword.osuser.immutable.exception", msg);
            errorCollection.addErrorMessage(errorMessage);
        }
    }

    void setPasswordImpl(ApplicationUser user, String newPassword) throws PermissionException, UserNotFoundException, InvalidCredentialException {
        try {
            this.userUtil.changePassword(user, newPassword);
        }
        catch (OperationNotPermittedException e) {
            throw new PermissionException((Exception)((Object)e));
        }
    }
}

