/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.SecureUserTokenManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.jira.web.util.AttachmentExceptionMessages;
import com.atlassian.jira.web.util.WebAttachmentManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ServletActionContext;

public class AttachScreenshot
extends AbstractCommentableIssue
implements OperationContext {
    private static final String SCREENSHOT_PREFIX = "screenshot-";
    private static final Pattern SHOT_NUMBER_REGEX = Pattern.compile("screenshot-(\\d+)");
    private final WebAttachmentManager webAttachmentManager;
    private final IssueUpdater issueUpdater;
    private final AttachmentService attachmentService;
    private final SecureUserTokenManager secureUserTokenManager;
    private final JiraAuthenticationContext authenticationContext;
    private String secureToken;
    private ApplicationUser secureUser;

    public AttachScreenshot(SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, ProjectRoleManager projectRoleManager, CommentService commentService, WebAttachmentManager webAttachmentManager, IssueUpdater issueUpdater, AttachmentService attachmentService, SecureUserTokenManager secureUserTokenManager, JiraAuthenticationContext authenticationContext, UserUtil userUtil) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.webAttachmentManager = webAttachmentManager;
        this.issueUpdater = issueUpdater;
        this.attachmentService = attachmentService;
        this.secureUserTokenManager = secureUserTokenManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public String doDefault() throws Exception {
        this.requireAttachmentsResources();
        try {
            this.attachmentService.canCreateAttachments(this.getJiraServiceContext(), this.getIssueObject());
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
        return "input";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doValidation() {
        ApplicationUser originalUser = this.authenticationContext.getUser();
        this.authenticationContext.setLoggedInUser(this.getLoggedInUser());
        try {
            try {
                this.attachmentService.canCreateAttachments(this.getJiraServiceContext(), this.getIssueObject());
                super.doValidation();
            }
            catch (IssueNotFoundException ex) {
                this.authenticationContext.setLoggedInUser(originalUser);
                return;
            }
            catch (IssuePermissionException ex) {
                this.authenticationContext.setLoggedInUser(originalUser);
                return;
            }
            boolean atLeastOneFile = false;
            try {
                boolean exists = this.webAttachmentManager.validateAttachmentIfExists(ServletActionContext.getMultiPartRequest(), "filename.1", false);
                atLeastOneFile = atLeastOneFile || exists;
            }
            catch (AttachmentException e) {
                this.addErrorMessage(AttachmentExceptionMessages.get(e, (I18nHelper)this));
            }
            if (this.invalidInput()) {
                this.addErrorMessage(this.getText("issue.field.attachment.lostduetoerrors"));
            } else if (!atLeastOneFile) {
                this.addError("filename.1", this.getText("attachfile.error.filerequired"));
            }
        }
        finally {
            this.authenticationContext.setLoggedInUser(originalUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ApplicationUser originalUser = this.authenticationContext.getUser();
        this.authenticationContext.setLoggedInUser(this.getLoggedInUser());
        try {
            ArrayList changeItemBeans = Lists.newArrayListWithCapacity((int)1);
            try {
                ChangeItemBean changeItemBean = this.webAttachmentManager.createAttachment(ServletActionContext.getMultiPartRequest(), this.getLoggedInUser(), this.getIssueObject(), "filename.1", null);
                if (changeItemBean != null) {
                    changeItemBeans.add(changeItemBean);
                }
            }
            catch (AttachmentException e) {
                this.addError("filename.1", AttachmentExceptionMessages.get(e, (I18nHelper)this));
                String string = "error";
                this.authenticationContext.setLoggedInUser(originalUser);
                return string;
            }
            IssueUpdateBean issueUpdateBean = new IssueUpdateBean(this.getIssue(), this.getIssue(), EventType.ISSUE_UPDATED_ID, this.getLoggedInUser());
            issueUpdateBean.setComment(this.createComment());
            issueUpdateBean.setChangeItems((Collection)changeItemBeans);
            issueUpdateBean.setDispatchEvent(true);
            issueUpdateBean.setParams(MapBuilder.singletonMap((Object)"eventsource", (Object)"action"));
            this.issueUpdater.doUpdate(issueUpdateBean, true);
            String string = "none";
            return string;
        }
        finally {
            this.authenticationContext.setLoggedInUser(originalUser);
        }
    }

    public String getReturnUrl() {
        String returnUrl = super.getReturnUrl();
        return StringUtils.isNotBlank((CharSequence)returnUrl) ? returnUrl : this.insertContextPath("/browse/" + this.getIssueObject().getKey());
    }

    public boolean isAbleToAttach() {
        return ComponentAccessor.getPermissionManager().hasPermission(19, this.getIssueObject(), this.getLoggedInUser());
    }

    public String encode(String text) {
        return JSONEscaper.escape((String)text);
    }

    public String getNextScreenshotName() {
        return SCREENSHOT_PREFIX + this.getNextScreenshotNumber();
    }

    public String getNewUserToken() {
        return this.secureUserTokenManager.generateToken(this.getLoggedInUser(), SecureUserTokenManager.TokenType.SCREENSHOT);
    }

    public int getNextScreenshotNumber() {
        int last = 0;
        for (Attachment attachment : this.getIssueObject().getAttachments()) {
            Matcher matcher = SHOT_NUMBER_REGEX.matcher(attachment.getFilename());
            if (!matcher.find()) continue;
            try {
                last = Math.max(last, Integer.parseInt(matcher.group(1)));
            }
            catch (RuntimeException impossible) {
                this.log.info((Object)("problem parsing screenshot number in " + attachment.getFilename()), (Throwable)impossible);
            }
        }
        return last + 1;
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }

    public String getSecureToken() {
        return this.secureToken;
    }

    public void setSecureToken(String secureToken) {
        this.secureToken = secureToken;
    }

    @Override
    public ApplicationUser getLoggedInApplicationUser() {
        return this.getSecureUser();
    }

    private ApplicationUser getSecureUser() {
        if (this.secureUser == null && this.secureToken != null) {
            this.secureUser = this.secureUserTokenManager.useToken(this.secureToken, SecureUserTokenManager.TokenType.SCREENSHOT);
        }
        if (this.secureUser == null) {
            return super.getLoggedInApplicationUser();
        }
        return this.secureUser;
    }
}

