/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.IssueTypeId;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.UserIssueTypeManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.CreateIssue;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import webwork.action.ActionContext;

public class CreateSubTaskIssue
extends CreateIssue {
    private final IssueManager issueManager;
    private final UserIssueTypeManager userIssueTypeManager;
    private Long parentIssueId;

    public CreateSubTaskIssue(IssueManager issueManager, IssueCreationHelperBean issueCreationHelperBean, IssueFactory issueFactory, UserIssueTypeManager userIssueTypeManager) {
        super(issueFactory, issueCreationHelperBean);
        this.issueManager = issueManager;
        this.userIssueTypeManager = userIssueTypeManager;
        this.getIgnoreFieldIds().add("security");
    }

    @Override
    protected String getRedirectForCreateBypass() {
        return this.forceRedirect("CreateSubTaskIssue.jspa?parentIssueId=" + this.getParentIssueId() + "&pid=" + this.getPid() + "&issuetype=" + this.getIssuetype());
    }

    boolean prepareFieldsIfOneOption() {
        MutableIssue parent = this.issueManager.getIssueObject(this.parentIssueId);
        if (parent == null) {
            return false;
        }
        if (this.getAllowedProjects().isEmpty()) {
            return false;
        }
        Project project = parent.getProjectObject();
        Collection issueTypes = this.getIssueTypesForProject(project);
        if (issueTypes.size() == 1) {
            IssueType issueType = (IssueType)issueTypes.iterator().next();
            this.setPid(project.getId());
            this.getFieldValuesHolder().put("project", project.getId());
            this.setIssuetype(issueType.getId());
            this.getFieldValuesHolder().put("issuetype", issueType.getId());
            return true;
        }
        return false;
    }

    @Override
    protected void setHistoryIssuetype() {
        Optional lastUsedSubtaskIssueTypeId = this.userIssueTypeManager.getLastUsedSubtaskIssueTypeId(this.getLoggedInUser());
        lastUsedSubtaskIssueTypeId.ifPresent(subtaskIssueTypeId -> {
            this.setIssuetype(subtaskIssueTypeId.getId());
            this.getFieldValuesHolder().put("issuetype", subtaskIssueTypeId.getId());
        });
    }

    @Override
    protected void recordHistoryIssueType() {
        this.userIssueTypeManager.setLastUsedSubtaskIssueTypeId(this.getLoggedInUser(), new IssueTypeId(this.getIssuetype()));
    }

    @Override
    protected void validateIssueType() {
        this.getIssueObject().setParentId(this.getParentIssueId());
        this.issueCreationHelperBean.validateIssueType((Issue)this.getIssueObject(), (OperationContext)this, ActionContext.getParameters(), (ErrorCollection)this, (I18nHelper)this);
    }

    public Long getParentIssueId() {
        return this.parentIssueId;
    }

    public void setParentIssueId(Long parentIssueId) {
        this.parentIssueId = parentIssueId;
    }

    @Override
    public MutableIssue getIssueObject() {
        if (this.getIssueObjectWithoutDatabaseRead() == null) {
            MutableIssue issue = super.getIssueObject();
            issue.setParentId(this.getParentIssueId());
            issue.setProjectId(this.getPid());
        }
        return this.getIssueObjectWithoutDatabaseRead();
    }

    @Override
    public Long getPid() {
        Long parentIssueId = this.getParentIssueId();
        MutableIssue issue = this.issueManager.getIssueObject(parentIssueId);
        if (issue != null) {
            return issue.getProjectId();
        }
        this.log.error((Object)("Issue with id '" + parentIssueId + "' does not exist or could not be retrieved."));
        return null;
    }

    public String getParentIssueKey() {
        Issue parentIssue = this.getParentIssue();
        if (parentIssue != null) {
            return parentIssue.getKey();
        }
        return null;
    }

    public String getParentIssuePath() {
        return "/browse/" + this.getParentIssueKey();
    }

    private Issue getParentIssue() {
        return this.getIssueManager().getIssueObject(this.getParentIssueId());
    }

    @Override
    protected Collection getIssueTypesForProject(Project project) {
        IssueTypeSchemeManager issueTypeSchemeManager = ComponentAccessor.getIssueTypeSchemeManager();
        return issueTypeSchemeManager.getSubTaskIssueTypesForProject(project);
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>();
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

