/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.vote.VoteHistoryEntry;
import com.atlassian.jira.issue.vote.VoteHistoryEntryImpl;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import com.atlassian.jira.web.component.multiuserpicker.UserBean;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.joda.time.DateMidnight;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.ofbiz.core.entity.GenericEntityException;

public class ViewVoters
extends AbstractIssueSelectAction {
    private final VoteManager voteManager;
    private final VoteService voteService;
    private final PermissionManager permissionManager;
    private final TimeZoneManager timeZoneManager;
    private Collection<UserBean> voters;
    private Boolean votedAlready;

    public ViewVoters(VoteManager voteManager, VoteService voteService, PermissionManager permissionManager, TimeZoneManager timeZoneManager) {
        this.voteManager = voteManager;
        this.voteService = voteService;
        this.permissionManager = permissionManager;
        this.timeZoneManager = timeZoneManager;
    }

    public String doDefault() throws Exception {
        if (!this.isIssueValid()) {
            return "issue-permission-error";
        }
        if (!this.hasPermissionToViewVoters()) {
            return "securitybreach";
        }
        return super.doDefault();
    }

    public Collection<UserBean> getVoters() {
        if (this.voters == null) {
            Collection usernames = this.voteManager.getVoterUsernames(this.getIssue());
            this.voters = UserBean.convertUsernamesToUserBeans(this.getLocale(), usernames);
        }
        return this.voters;
    }

    public boolean isVotingEnabled() {
        return this.voteManager.isVotingEnabled();
    }

    public SimpleVoteHistory getVoteHistory() {
        List voteHistory = this.voteManager.getVoteHistory(this.getIssueObject());
        return new SimpleVoteHistory(this.getIssueObject());
    }

    public String getCommaSeperatedDateParts(Date date) {
        DecimalFormat nf = new DecimalFormat("##00");
        TimeZone timeZone = this.timeZoneManager.getLoggedInUserTimeZone();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), timeZone.toZoneId());
        String yyyy = nf.format(localDateTime.getYear());
        String mm = nf.format(localDateTime.getMonthValue() - 1);
        String dd = nf.format(localDateTime.getDayOfMonth());
        return yyyy + "," + mm + "," + dd;
    }

    @RequiresXsrfCheck
    public String doAddVote() throws GenericEntityException {
        if (!this.isIssueValid()) {
            return "issue-permission-error";
        }
        if (!this.hasPermissionToViewVoters()) {
            return "securitybreach";
        }
        if (this.isIssueReportedByMe() || this.getIssue().getString("resolution") != null) {
            return "securitybreach";
        }
        this.voteManager.addVote(this.getLoggedInUser(), this.getIssueObject());
        this.refreshIssueObject();
        return "success";
    }

    @RequiresXsrfCheck
    public String doRemoveVote() throws GenericEntityException {
        if (!this.isIssueValid()) {
            return "issue-permission-error";
        }
        if (!this.hasPermissionToViewVoters()) {
            return "securitybreach";
        }
        if (this.isIssueReportedByMe() || this.getIssue().getString("resolution") != null) {
            return "securitybreach";
        }
        this.voteManager.removeVote(this.getLoggedInUser(), this.getIssueObject());
        this.refreshIssueObject();
        return "success";
    }

    public boolean isVotedAlready() {
        if (this.votedAlready == null) {
            this.votedAlready = this.getLoggedInUser() != null ? Boolean.valueOf(this.voteManager.hasVoted(this.getLoggedInUser(), this.getIssueObject())) : Boolean.FALSE;
        }
        return this.votedAlready;
    }

    public boolean isIssueReportedByMe() {
        String reporter = this.getIssue().getString("reporter");
        ApplicationUser user = this.getLoggedInUser();
        return user != null && reporter != null && reporter.equals(user.getKey());
    }

    public boolean isCanAddVote() {
        ApplicationUser user = this.getLoggedInUser();
        return user != null && this.voteService.validateAddVote(user, user, this.getIssueObject()).isValid() && !this.voteService.hasVoted(this.getIssueObject(), user);
    }

    public boolean isCanRemoveVote() {
        ApplicationUser user = this.getLoggedInUser();
        return user != null && this.voteService.validateRemoveVote(user, user, this.getIssueObject()).isValid() && this.voteService.hasVoted(this.getIssueObject(), user);
    }

    private boolean hasPermissionToViewVoters() {
        return this.permissionManager.hasPermission(ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, this.getIssueObject(), this.getLoggedInUser());
    }

    public class SimpleVoteHistory {
        private final List<VoteHistoryEntry> voteHistory = new ArrayList<VoteHistoryEntry>();
        private final int numberOfDays;

        public SimpleVoteHistory(Issue issue) {
            this.voteHistory.add(new VoteHistoryEntryImpl(issue.getId(), issue.getCreated(), 0L));
            this.voteHistory.addAll(ViewVoters.this.voteManager.getVoteHistory(issue));
            this.voteHistory.add(new VoteHistoryEntryImpl(issue.getId(), new Timestamp(System.currentTimeMillis()), issue.getVotes()));
            this.numberOfDays = Days.daysBetween((ReadableInstant)new DateMidnight((Object)issue.getCreated()), (ReadableInstant)new DateMidnight()).getDays() + 1;
        }

        public List<VoteHistoryEntry> getVoteHistory() {
            return this.voteHistory;
        }

        public int getNumberOfDays() {
            return this.numberOfDays;
        }
    }
}

