/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.operation.BulkEditTaskContext;
import com.atlassian.jira.bulkedit.operation.BulkOperationException;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.FixedSized;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationAction;
import com.atlassian.jira.web.action.issue.bulkedit.BulkEditCommandResult;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class BulkOperationProgress
extends AbstractBulkOperationAction {
    private static final int TRANISTION_ERRORS_LIMIT_DEFAULT = 100;
    private final TaskManager taskManager;
    private final TaskDescriptorBean.Factory taskBeanFactory;
    private Long taskId;
    private TaskDescriptorBean<BulkEditCommandResult> ourTask;
    private TaskDescriptor<BulkEditCommandResult> currentTaskDescriptor;

    public BulkOperationProgress(TaskManager taskManager, TaskDescriptorBean.Factory taskBeanFactory, SearchService searchService, BulkEditBeanSessionHelper bulkEditBeanSessionHelper) {
        super(searchService, bulkEditBeanSessionHelper);
        this.taskManager = taskManager;
        this.taskBeanFactory = taskBeanFactory;
    }

    public String doProgress() throws ExecutionException, InterruptedException {
        BulkEditCommandResult result;
        BulkEditBean bulkEditBean = this.getBulkEditBean();
        if (bulkEditBean == null) {
            this.addErrorMessage(this.getText("bulk.bean.doesntexist.error"));
            return "error";
        }
        String errorOutcome = "error-" + bulkEditBean.getOperationName();
        if (this.taskId == null) {
            this.addErrorMessage(this.getText("common.tasks.no.task.id"));
            return errorOutcome;
        }
        this.currentTaskDescriptor = this.taskManager.getTask(this.taskId);
        if (this.currentTaskDescriptor == null) {
            this.addErrorMessage(this.getText("common.tasks.no.task.found"));
            return errorOutcome;
        }
        TaskContext context = this.currentTaskDescriptor.getTaskContext();
        if (!(context instanceof BulkEditTaskContext)) {
            this.addErrorMessage(this.getText("common.tasks.wrong.task.context", BulkEditTaskContext.class.getName(), context.getClass().getName()));
            return errorOutcome;
        }
        this.ourTask = this.taskBeanFactory.create(this.currentTaskDescriptor);
        if (this.currentTaskDescriptor.isFinished() && !this.currentTaskDescriptor.isCancelled() && !(result = this.currentTaskDescriptor.getResult()).isSuccessful()) {
            this.addErrorCollection(result.getErrorCollection());
        }
        return "progress";
    }

    public String doFinish() throws Exception {
        BulkEditBean bulkEditBean = this.getBulkEditBean();
        if (bulkEditBean == null) {
            this.addErrorMessage(this.getText("bulk.bean.doesntexist.error"));
            return "error";
        }
        return this.finishWizard();
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public TaskDescriptorBean<BulkEditCommandResult> getCurrentTask() {
        TaskDescriptor taskDescriptor;
        if (this.ourTask == null && (taskDescriptor = this.taskManager.getTask(this.taskId)) != null) {
            this.ourTask = this.taskBeanFactory.create(taskDescriptor);
        }
        return this.ourTask;
    }

    public TaskDescriptorBean<?> getOurTask() {
        return this.ourTask;
    }

    public boolean isThereAnyTransitionError() {
        return !this.getTransitionErrors().isEmpty();
    }

    public boolean isTransitionErrorsLimited() {
        return this.getBulkEditBean().isTranisitionErrorsLimited(Integer.valueOf(this.getTransitionErrorsCount()));
    }

    public Map<String, Collection<String>> getTransitionErrors() {
        return this.getBulkEditBean().getTransitionErrors(Integer.valueOf(this.getTransitionErrorsCount()));
    }

    private int getTransitionErrorsCount() {
        try {
            return Integer.parseInt(this.getApplicationProperties().getDefaultBackedString("jira.bulk.edit.limit.transition.errors"));
        }
        catch (NumberFormatException numberFormatException) {
            return 100;
        }
    }

    public static class BulkEditCallable
    implements Callable<BulkEditCommandResult>,
    ProvidesTaskProgress {
        private TaskProgressSink taskProgressSink;
        private final Logger log;
        private final I18nHelper i18nHelper;
        private final ProgressAwareBulkOperation bulkOperation;
        private final BulkEditBean bulkEditBean;
        private final ApplicationUser user;

        public BulkEditCallable(Logger log, I18nHelper i18nHelper, ProgressAwareBulkOperation bulkOperation, BulkEditBean bulkEditBean, ApplicationUser user) {
            this.log = log;
            this.i18nHelper = i18nHelper;
            this.bulkOperation = bulkOperation;
            this.bulkEditBean = bulkEditBean;
            this.user = user;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BulkEditCommandResult call() throws Exception {
            this.log.debug((Object)String.format("Bulk-operation on %d issues", this.bulkEditBean.getSelectedIssues().size()));
            long startTime = System.currentTimeMillis();
            try {
                int numberOfOperations = this.bulkOperation.getNumberOfTasks(this.bulkEditBean);
                Context context = Contexts.builder().sized((Sized)new FixedSized(numberOfOperations)).progress(this.taskProgressSink, this.i18nHelper, "bulk.operation.progress.percent.complete", null).log(this.log, "Bulk-operation is {0}% complete. Index of current item: {1}").build();
                context.setName("bulk operation");
                this.bulkOperation.perform(this.bulkEditBean, this.user, context);
                for (int i = 0; i < context.getNumberOfTasksToCompletion(); ++i) {
                    context.start(null).complete();
                }
                BulkEditCommandResult bulkEditCommandResult = new BulkEditCommandResult(System.currentTimeMillis() - startTime, (ErrorCollection)new SimpleErrorCollection());
                return bulkEditCommandResult;
            }
            catch (BulkOperationException e) {
                this.log.warn((Object)"Error while performing bulk operation", (Throwable)e);
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                errorCollection.addErrorMessage(this.i18nHelper.getText("bulk.operation.perform.error"));
                BulkEditCommandResult bulkEditCommandResult = new BulkEditCommandResult(System.currentTimeMillis() - startTime, (ErrorCollection)errorCollection);
                return bulkEditCommandResult;
            }
            finally {
                this.log.debug((Object)"Bulk-editing finished");
            }
        }

        @Override
        public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
            this.taskProgressSink = taskProgressSink;
        }
    }
}

