/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class DevModeSecretSauce {
    private final boolean boneFide;
    private final Properties properties;

    public DevModeSecretSauce(JiraProperties jiraSystemProperties) {
        File secretSauce = new File(jiraSystemProperties.getProperty("user.home") + "/.jiradev/secretsauce.properties");
        this.boneFide = JiraSystemProperties.isDevMode() && secretSauce.exists();
        this.properties = new Properties();
        if (this.boneFide) {
            try {
                this.properties.load(new FileReader(secretSauce));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isBoneFideJiraDeveloper() {
        return this.boneFide;
    }

    String getPrefilledLicence() {
        if (this.isBoneFideJiraDeveloper()) {
            return StringUtils.defaultString((String)this.properties.getProperty("licence"));
        }
        return null;
    }

    public String getSecretSauceProperty(String propertyName) {
        return this.isBoneFideJiraDeveloper() ? StringUtils.defaultString((String)this.properties.getProperty(propertyName)) : null;
    }
}

