/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.bootstrap.DefaultAtlassianBootstrapManager;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.config.db.DatabaseList;
import com.atlassian.core.util.PairType;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.database.DatabaseDriverRegisterer;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.InvalidDatabaseDriverException;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.config.database.MySQL57DefaultRowFormatChecker;
import com.atlassian.jira.config.database.MySQL57OrLaterVersionPredicate;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.startup.DatabaseInitialImporter;
import com.atlassian.jira.startup.FaultDescription;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.JiraProductInformation;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.jira.web.util.HelpUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;

public class SetupDatabase
extends AbstractSetupAction {
    private static final int DEFAULT_POOL_SIZE = 20;
    public static final String REDIRECT_URL = "SetupDatabase!default.jspa";
    private final BuildUtilsInfo buildUtilsInfo;
    private final DatabaseConfigurationManager databaseConfigurationManager;
    private final VelocityTemplatingEngine velocityEngine;
    private final DatabaseInitialImporter databaseInitialImporter;
    private final HelpUrls helpUrls;
    private final JiraProperties jiraProperties;
    private final ExternalLinkUtil externalLinkUtil;
    private String databaseOption = "internal";
    private String importOption = "none";
    private String databaseType;
    private String schemaName;
    private static final Map<String, String> SCHEMA_NAMES = ImmutableMap.of((Object)"postgres72", (Object)"public", (Object)"mssql", (Object)"dbo", (Object)"postgresaurora96", (Object)"public");
    private String jdbcHostname;
    private String jdbcPort;
    private String jdbcDatabase;
    private String jdbcSid;
    private String jdbcUsername;
    private String jdbcPassword;
    private Integer poolSize = 20;
    private DatabaseList databaseList = new DatabaseList();
    private boolean isTestConnectionSuccessful;
    @VisibleForTesting
    static final Map<String, DatabaseType> databaseTypeMap = MapBuilder.newBuilder().add((Object)DatabaseType.ORACLE.getTypeName(), (Object)DatabaseType.ORACLE).add((Object)DatabaseType.POSTGRES.getTypeName(), (Object)DatabaseType.POSTGRES).add((Object)DatabaseType.AURORA_POSTGRES.getTypeName(), (Object)DatabaseType.AURORA_POSTGRES).add((Object)DatabaseType.MY_SQL.getTypeName(), (Object)DatabaseType.MY_SQL).add((Object)DatabaseType.MY_SQL57.getTypeName(), (Object)DatabaseType.MY_SQL57).add((Object)DatabaseType.SQL_SERVER.getTypeName(), (Object)DatabaseType.SQL_SERVER).toMap();

    public SetupDatabase(FileFactory fileFactory, BuildUtilsInfo buildUtilsInfo, DatabaseConfigurationManager databaseConfigurationManager, VelocityTemplatingEngine velocityEngine, DatabaseInitialImporter databaseInitialImporter, HelpUrls helpUrls, JiraProperties jiraProperties, JiraProductInformation jiraProductInformation, ExternalLinkUtil externalLinkUtil) {
        super(fileFactory, jiraProperties, jiraProductInformation);
        this.buildUtilsInfo = buildUtilsInfo;
        this.databaseConfigurationManager = databaseConfigurationManager;
        this.velocityEngine = velocityEngine;
        this.databaseInitialImporter = databaseInitialImporter;
        this.helpUrls = helpUrls;
        this.jiraProperties = jiraProperties;
        this.externalLinkUtil = externalLinkUtil;
    }

    public String doInput() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        return "input";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doConnectionCheck() throws IOException {
        HttpServletResponse response = this.getHttpResponse();
        JSONObject json = new JSONObject();
        response.setContentType("application/json");
        this.databaseOption = "external";
        this.doValidation();
        try {
            json.put("data", this.getSoyDataForConnectionCheck());
            response.getWriter().write(json.toString());
        }
        catch (JSONException e) {
            response.getWriter().write("{}");
        }
        finally {
            response.getWriter().flush();
        }
        return "none";
    }

    public String doDefault() {
        if (this.isDatabaseSetup()) {
            this.databaseInitialImporter.importInitialData(this.getLoggedInUser(), true);
            return this.forceRedirect("SetupApplicationProperties!default.jspa");
        }
        this.setIndexingLanguageForDefaultServerLocale();
        return "input";
    }

    protected void doValidation() {
        if (this.setupAlready()) {
            return;
        }
        if (this.isExternalDatabase()) {
            if ("".equals(this.databaseType) || this.databaseType == null) {
                this.addError("databaseType", this.getText("setupdb.error.selectDatabaseType"));
            }
            if (StringUtils.isEmpty((CharSequence)this.jdbcHostname)) {
                this.addError("jdbcHostname", this.getText("setupdb.error.requireJdbcHostname"));
            }
            if (StringUtils.isEmpty((CharSequence)this.jdbcPort)) {
                this.addError("jdbcPort", this.getText("setupdb.error.requireJdbcPort"));
            }
            if (this.isOracleDatabaseType()) {
                if (StringUtils.isEmpty((CharSequence)this.jdbcSid)) {
                    this.addError("jdbcSid", this.getText("setupdb.error.requireSID"));
                }
            } else if (StringUtils.isEmpty((CharSequence)this.jdbcDatabase)) {
                this.addError("jdbcDatabase", this.getText("setupdb.error.requireDatabase"));
            }
            if (StringUtils.isEmpty((CharSequence)this.jdbcUsername)) {
                this.addError("jdbcUsername", this.getText("setupdb.error.requireJdbcUsername"));
            }
        }
        this.testConnection();
        this.validateDatabaseIsEmpty();
        super.doValidation();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        String locale = this.getLocale().toString();
        if (!this.isDatabaseSetup()) {
            DatabaseConfig databaseConfiguration = this.createDatabaseConfiguration();
            this.databaseConfigurationManager.setDatabaseConfiguration(databaseConfiguration);
            this.databaseConfigurationManager.activateDatabase();
        }
        this.databaseInitialImporter.importInitialData(this.getLoggedInUser());
        this.setJiraLocale(locale);
        this.setIndexingLanguageForDefaultServerLocale();
        return this.forceRedirect("SetupApplicationProperties!default.jspa");
    }

    private void testConnection() {
        if (!this.hasAnyErrors()) {
            try {
                DatabaseConfig databaseConfiguration = this.createDatabaseConfiguration();
                FaultDescription startupCheck = databaseConfiguration.testConnection((AtlassianBootstrapManager)new DefaultAtlassianBootstrapManager());
                if (startupCheck != null) {
                    this.addErrorMessage(startupCheck.getFaultDescription());
                }
            }
            catch (BootstrapException e) {
                this.addErrorMessage(this.getText("setupdb.error.connectionFailed"));
                Throwable cause = e.getCause();
                this.addErrorMessage(cause.getLocalizedMessage());
                if (cause.getCause() != null && !cause.getLocalizedMessage().equals(cause.getCause().getLocalizedMessage())) {
                    this.addErrorMessage(cause.getCause().getLocalizedMessage());
                }
            }
            catch (InvalidDatabaseDriverException e) {
                this.addErrorMessage(this.getText("setupdb.error.invalidDriver", e.driverClassName()));
            }
            this.isTestConnectionSuccessful = !this.hasAnyErrors();
        }
    }

    private void validateDatabaseIsEmpty() {
        if (!this.hasAnyErrors()) {
            boolean isMySQLConfigurationCorrect;
            boolean isMySQLVersionCorrect;
            boolean isDatabaseEmpty;
            block20: {
                isDatabaseEmpty = false;
                isMySQLVersionCorrect = true;
                isMySQLConfigurationCorrect = true;
                DatabaseConfig databaseConfiguration = this.createDatabaseConfiguration();
                DefaultAtlassianBootstrapManager bootstrapManager = new DefaultAtlassianBootstrapManager();
                try (Connection conn = databaseConfiguration.getDatasource().getConnection((AtlassianBootstrapManager)bootstrapManager);){
                    isDatabaseEmpty = databaseConfiguration.isDatabaseEmpty((AtlassianBootstrapManager)bootstrapManager);
                    if ("mysql57".equals(databaseConfiguration.getDatabaseType())) {
                        isMySQLVersionCorrect = new MySQL57OrLaterVersionPredicate().test(conn);
                        isMySQLConfigurationCorrect = new MySQL57DefaultRowFormatChecker().test(conn);
                    }
                }
                catch (BootstrapException | SQLException e) {
                    this.addErrorMessage(this.getText("setupdb.error.connectionFailed"));
                    Throwable cause = e.getCause();
                    this.addErrorMessage(cause.getLocalizedMessage());
                    if (cause.getCause() == null || cause.getLocalizedMessage().equals(cause.getCause().getLocalizedMessage())) break block20;
                    this.addErrorMessage(cause.getCause().getLocalizedMessage());
                }
            }
            if (!isDatabaseEmpty) {
                this.addErrorMessage(this.getText("setupdb.error.nonemptyDatabase.with.upgrade.documentation", this.getHelpPaths().get("upgrade")));
            }
            if (!isMySQLVersionCorrect) {
                this.addErrorMessage(this.getText("setupdb.error.mysqlVersion57.not.compatible.with.instance", this.getHelpPaths().get("upgrade")));
            } else if (!isMySQLConfigurationCorrect) {
                this.addErrorMessage(this.getText("setupdb.error.mysqlVersion57.wrong.default.configuration", this.getHelpPaths().get("upgrade")));
            }
            this.isTestConnectionSuccessful = !this.hasAnyErrors();
        }
    }

    private DatabaseConfig createDatabaseConfiguration() {
        if (this.isExternalDatabase()) {
            DatabaseDetails databaseDetails = this.getDatabaseDetails(this.databaseType);
            this.poolSize = databaseDetails.getPoolSize();
            String instanceName = this.isOracleDatabaseType() ? this.jdbcSid : this.jdbcDatabase;
            DatabaseType type = this.getDatabaseTypeEnum();
            ConnectionPoolInfo.Builder connectionPoolInfoBuilder = ConnectionPoolInfo.builder();
            connectionPoolInfoBuilder.setPoolMaxSize(this.poolSize).setPoolMaxWait(Long.valueOf(30000L)).setPoolMinSize(this.poolSize).setRemoveAbandonedOnBorrow(Boolean.valueOf(true)).setRemoveAbandonedTimeout(Integer.valueOf(300)).setTestWhileIdle(Boolean.valueOf(true)).setTestOnBorrow(Boolean.valueOf(false)).setMinEvictableTimeMillis(Long.valueOf(60000L)).setTimeBetweenEvictionRunsMillis(Long.valueOf(300000L));
            if (type == DatabaseType.MY_SQL || type == DatabaseType.MY_SQL57) {
                connectionPoolInfoBuilder.setValidationQuery("select 1");
                connectionPoolInfoBuilder.setValidationQueryTimeout(Integer.valueOf(3));
            }
            if (type == DatabaseType.SQL_SERVER || type.isPostgreSQlCompatible().booleanValue()) {
                connectionPoolInfoBuilder.setValidationQuery("select 1");
            }
            if (type == DatabaseType.ORACLE) {
                connectionPoolInfoBuilder.setValidationQuery("select 1 from dual");
            }
            if (type == DatabaseType.HSQL) {
                connectionPoolInfoBuilder.setMinEvictableTimeMillis(Long.valueOf(4000L));
                connectionPoolInfoBuilder.setTimeBetweenEvictionRunsMillis(Long.valueOf(5000L));
            }
            JdbcDatasource.Builder builder = JdbcDatasource.builder().setDatabaseType(type).setHostname(this.jdbcHostname).setPort(this.jdbcPort).setInstance(instanceName).setUsername(this.jdbcUsername).setPassword(this.jdbcPassword).setConnectionPoolInfo(connectionPoolInfoBuilder.build());
            JdbcDatasource datasource = builder.build();
            return new DatabaseConfig(this.databaseType, this.schemaName, datasource);
        }
        return this.databaseConfigurationManager.getInternalDatabaseConfiguration();
    }

    @ActionViewData
    public List<Map<String, Object>> getDatabaseOptions() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)ImmutableMap.of((Object)"id", (Object)"jira-setup-database-field-database-internal", (Object)"isChecked", (Object)"internal".equals(this.getDatabaseOption()), (Object)"labelText", (Object)this.getText("setupdb.internal.label"), (Object)"value", (Object)"internal"));
        builder.add((Object)ImmutableMap.of((Object)"id", (Object)"jira-setup-database-field-database-external", (Object)"isChecked", (Object)"external".equals(this.getDatabaseOption()), (Object)"labelText", (Object)this.getText("setupdb.external.label"), (Object)"value", (Object)"external"));
        return builder.build();
    }

    @ActionViewData
    public List<Map<String, Object>> getImportOptions() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)ImmutableMap.of((Object)"id", (Object)"jira-setup-database-field-import-none", (Object)"isChecked", (Object)"none".equals(this.getImportOption()), (Object)"labelText", (Object)this.getText("setupdb.import.none"), (Object)"value", (Object)"none"));
        builder.add((Object)ImmutableMap.of((Object)"id", (Object)"jira-setup-database-field-import-import", (Object)"isChecked", (Object)"import".equals(this.getImportOption()), (Object)"labelText", (Object)this.getText("setupdb.import.import"), (Object)"value", (Object)"import"));
        return builder.build();
    }

    private Map<String, String> getHelpPaths() {
        HelpUtil helpUtil = new HelpUtil();
        return ImmutableMap.of((Object)"connecting", (Object)helpUtil.getHelpPath("dbconfig.index").getUrl(), (Object)"external", (Object)helpUtil.getHelpPath("dbconfig.index").getUrl(), (Object)"migration", (Object)helpUtil.getHelpPath("dbconfig.switchdbs").getUrl(), (Object)"upgrade", (Object)helpUtil.getHelpPath("dbconfig.upgrade.instructions").getUrl());
    }

    @ActionViewDataMappings(value={"input", "error"})
    public Map<String, Object> getSoyData() {
        Map errors = this.getErrors();
        ImmutableMap.Builder errorsTransformed = ImmutableMap.builder();
        for (Map.Entry entry : errors.entrySet()) {
            errorsTransformed.put(entry.getKey(), (Object)ImmutableList.of(entry.getValue()));
        }
        return ImmutableMap.builder().put((Object)"databaseMessagesContent", this.getDatabaseMessages()).put((Object)"databaseWarningMessagesContent", this.getDatabaseWarningMessages()).put((Object)"errors", (Object)errorsTransformed.build()).put((Object)"globalErrors", (Object)this.getErrorMessages()).put((Object)"fieldValues", this.getFieldValues()).put((Object)"helpPaths", this.getHelpPaths()).build();
    }

    public Map<String, Object> getSoyDataForConnectionCheck() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(this.getSoyData());
        builder.put((Object)"externalDatabases", this.getExternalDatabases());
        builder.put((Object)"dbTestSuccessful", (Object)this.getDbTestSuccessful());
        return builder.build();
    }

    private Map<String, String> getFieldValues() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"jdbcHostname", MoreObjects.firstNonNull((Object)this.getJdbcHostname(), (Object)""));
        builder.put((Object)"jdbcPort", MoreObjects.firstNonNull((Object)this.getJdbcPort(), (Object)""));
        builder.put((Object)"jdbcDatabase", MoreObjects.firstNonNull((Object)this.getJdbcDatabase(), (Object)""));
        builder.put((Object)"jdbcSid", MoreObjects.firstNonNull((Object)this.getJdbcSid(), (Object)""));
        builder.put((Object)"jdbcUsername", MoreObjects.firstNonNull((Object)this.getJdbcUsername(), (Object)""));
        builder.put((Object)"jdbcPassword", MoreObjects.firstNonNull((Object)this.getJdbcPassword(), (Object)""));
        builder.put((Object)"schemaName", MoreObjects.firstNonNull((Object)this.getSchemaName(), (Object)""));
        return builder.build();
    }

    @ActionViewData
    public List<Map<String, Object>> getExternalDatabases() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)ImmutableMap.of((Object)"selected", (Object)(this.databaseType == null ? 1 : 0), (Object)"text", (Object)this.getText("setupdb.database.selectType"), (Object)"value", (Object)""));
        for (PairType pairType : this.databaseList.getDatabases()) {
            builder.add((Object)ImmutableMap.of((Object)"selected", (Object)(this.databaseType != null && this.databaseType.equals(pairType.getKey()) ? 1 : 0), (Object)"text", (Object)pairType.getValue(), (Object)"value", (Object)pairType.getKey()));
        }
        return builder.build();
    }

    private Map<String, String> getDatabaseMessages() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<String, DatabaseType> databaseType : databaseTypeMap.entrySet()) {
            DatabaseDriverRegisterer registerer = DatabaseDriverRegisterer.forType(databaseType.getValue());
            if (!this.isNotShippedDriver(databaseType.getValue()) || registerer.isDriverRegistered()) continue;
            result.put((Object)databaseType.getKey(), (Object)this.createNotPresentMessage(databaseType.getValue()));
        }
        return result.build();
    }

    private Map<String, String> getDatabaseWarningMessages() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        String secureMACUrl = this.externalLinkUtil.getProperty("external.link.atlassian.my.account.secure");
        result.put((Object)DatabaseType.AURORA_POSTGRES.getTypeName(), (Object)this.getText("setupdb.databasetype.dcExclusiveFeature", "Aurora PostgreSQL", String.format("<a href='%s' target='_blank'>", secureMACUrl), "</a>"));
        return result.build();
    }

    public DatabaseDetails getDatabaseDetails(String database) {
        try {
            return DatabaseDetails.getDefaults((String)database);
        }
        catch (ConfigurationException e) {
            this.log.debug((Object)e);
            return null;
        }
    }

    public String getSchemaName(String database) {
        return SCHEMA_NAMES.get(database);
    }

    private ApplicationProperties getFreshApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    private boolean isNotShippedDriver(DatabaseType databaseType) {
        return databaseType == DatabaseType.MY_SQL || databaseType == DatabaseType.ORACLE;
    }

    private String createNotPresentMessage(DatabaseType dbType) {
        return this.getText("setupdb.database.drivernotpresent", dbType.getDisplayName(), this.getDocLink(dbType, this.getText("setupdb.database.drivernotpresent.linktext")));
    }

    private String getDocLink(DatabaseType type, String linkText) {
        HelpUrl helpPath = DatabaseDriverRegisterer.getDbConfigLink(type, this.helpUrls);
        return this.velocityEngine.render(TemplateSources.file((String)"/templates/jira/simplelink.vm")).applying((Map)ImmutableMap.of((Object)"targetUrl", (Object)helpPath.getUrl(), (Object)"title", (Object)helpPath.getTitle(), (Object)"alt", (Object)helpPath.getAlt(), (Object)"newWindow", (Object)true, (Object)"linkText", (Object)linkText)).asHtml();
    }

    private DatabaseType getDatabaseTypeEnum() {
        DatabaseType type = databaseTypeMap.get(this.databaseType);
        if (type == null) {
            throw new IllegalStateException("Unknown database type '" + this.databaseType + "'");
        }
        return type;
    }

    private boolean isOracleDatabaseType() {
        return "oracle10g".equals(this.databaseType);
    }

    private boolean isExternalDatabase() {
        return "external".equals(this.databaseOption);
    }

    public boolean getDbTestSuccessful() {
        return this.isTestConnectionSuccessful;
    }

    public boolean isDatabaseSetup() {
        return this.databaseConfigurationManager.isDatabaseSetup();
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseOption() {
        return this.databaseOption;
    }

    public void setDatabaseOption(String databaseOption) {
        this.databaseOption = databaseOption;
    }

    public String getImportOption() {
        return this.importOption;
    }

    public void setImportOption(String importOption) {
        this.importOption = importOption;
    }

    public BuildUtilsInfo getBuildUtilsInfo() {
        return this.buildUtilsInfo;
    }

    public String getJdbcHostname() {
        return this.jdbcHostname;
    }

    public void setJdbcHostname(String jdbcHostname) {
        this.jdbcHostname = jdbcHostname;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public String getJdbcPort() {
        return this.jdbcPort;
    }

    public void setJdbcPort(String jdbcPort) {
        this.jdbcPort = jdbcPort;
    }

    public String getJdbcDatabase() {
        return this.jdbcDatabase;
    }

    public void setJdbcDatabase(String jdbcDatabase) {
        this.jdbcDatabase = jdbcDatabase;
    }

    public String getJdbcSid() {
        return this.jdbcSid;
    }

    public void setJdbcSid(String jdbcSid) {
        this.jdbcSid = jdbcSid;
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    public void setJdbcUsername(String jdbcUsername) {
        this.jdbcUsername = jdbcUsername;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    protected String getCurrentTrackerStepId() {
        return "setup-tracker-database";
    }
}

