/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.sharing.SharePermissionUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.bean.ShareTypeRendererBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class EditPortalPage
extends JiraWebActionSupport {
    private static final String SHARES_FIELD = "shares";
    private final ShareTypeFactory shareTypeFactory;
    private String shareString = null;
    private SharedEntity.SharePermissions sharePermissions = SharedEntity.SharePermissions.PRIVATE;
    private boolean favourite = true;
    private Long pageId = null;
    private String portalPageName = null;
    private String portalPageDescription = null;
    private final PortalPageService portalPageService;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionsManager;
    private final FavouritesService favouritesService;
    private final FeatureManager featureManager;

    public EditPortalPage(PortalPageService portalPageService, JiraAuthenticationContext authenticationContext, ShareTypeFactory shareTypeFactory, PermissionManager permissionsManager, FavouritesService favouritesService, FeatureManager featureManager) {
        this.portalPageService = portalPageService;
        this.authenticationContext = authenticationContext;
        this.shareTypeFactory = shareTypeFactory;
        this.permissionsManager = permissionsManager;
        this.favouritesService = favouritesService;
        this.featureManager = featureManager;
    }

    public Long getPageId() {
        return this.pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public String doDefault() {
        this.tagMauEventWithApplication(MauApplicationKey.family());
        PortalPage portalPage = this.getPortalPage();
        if (portalPage != null) {
            if (portalPage.isSystemDefaultPortalPage()) {
                this.addErrorMessage(this.getText("admin.errors.user.cannot.edit.default.dashboard"));
                return "error";
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.user.must.select.page"));
            return "error";
        }
        this.portalPageName = portalPage.getName();
        this.portalPageDescription = portalPage.getDescription();
        this.setPermissions(portalPage.getPermissions());
        this.setFavourite(this.favouritesService.isFavourite(this.getLoggedInUser(), (SharedEntity)portalPage));
        return "input";
    }

    protected void doValidation() {
        PortalPage portalPage;
        this.setPermissions(SharedEntity.SharePermissions.PRIVATE);
        if (StringUtils.isNotBlank((CharSequence)this.shareString)) {
            try {
                SharedEntity.SharePermissions permissions = SharePermissionUtils.fromJsonArrayString((String)this.shareString);
                this.setPermissions(permissions);
            }
            catch (JSONException e) {
                this.log.error((Object)("Unable to parse the returned SharePermissions: " + e.getMessage()), (Throwable)e);
                this.addError(SHARES_FIELD, this.getText("common.sharing.parse.error"));
                return;
            }
        }
        if ((portalPage = this.createUpdatedPortalPage()) == null) {
            this.addErrorMessage(this.getText("admin.errors.user.must.select.page"));
        } else if (portalPage.isSystemDefaultPortalPage()) {
            this.addErrorMessage(this.getText("admin.errors.user.cannot.edit.default.dashboard"));
        } else {
            this.portalPageService.validateForUpdate(this.getJiraServiceContext(), portalPage);
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() {
        PortalPage portalPage = this.createUpdatedPortalPage();
        if (portalPage != null) {
            this.portalPageService.updatePortalPage(this.getJiraServiceContext(), portalPage, this.favourite);
        }
        return this.getRedirect("ConfigurePortalPages.jspa");
    }

    private PortalPage createUpdatedPortalPage() {
        PortalPage portalPage = this.getPortalPage();
        if (portalPage != null) {
            return PortalPage.portalPage((PortalPage)portalPage).name(this.getPortalPageName()).description(this.getPortalPageDescription()).permissions(this.getPermissions()).build();
        }
        return portalPage;
    }

    private PortalPage getPortalPage() {
        if (this.pageId != null) {
            JiraServiceContextImpl ignoredCtx = new JiraServiceContextImpl(this.getLoggedInUser());
            return this.portalPageService.getPortalPage((JiraServiceContext)ignoredCtx, this.pageId);
        }
        return null;
    }

    public String getPortalPageName() {
        return this.portalPageName;
    }

    public void setPortalPageName(String portalPageName) {
        this.portalPageName = portalPageName;
    }

    public String getPortalPageDescription() {
        return this.portalPageDescription;
    }

    public void setPortalPageDescription(String portalPageDescription) {
        this.portalPageDescription = StringUtils.isNotBlank((CharSequence)portalPageDescription) ? portalPageDescription : null;
    }

    public void setShareValues(String values) {
        this.shareString = values;
    }

    private void setPermissions(SharedEntity.SharePermissions sharePermissions) {
        this.sharePermissions = sharePermissions;
    }

    private SharedEntity.SharePermissions getPermissions() {
        return this.sharePermissions;
    }

    public boolean isFavourite() {
        return this.favourite;
    }

    public void setFavourite(boolean favourite) {
        this.favourite = favourite;
    }

    public Collection<ShareTypeRendererBean> getShareTypes() {
        Collection sharesTypes = this.shareTypeFactory.getAllShareTypes();
        ArrayList<ShareTypeRendererBean> types = new ArrayList<ShareTypeRendererBean>(sharesTypes.size());
        for (ShareType shareType : sharesTypes) {
            types.add(new ShareTypeRendererBean(shareType, this.authenticationContext, ShareTypeRenderer.RenderMode.EDIT, PortalPage.ENTITY_TYPE));
        }
        return types;
    }

    public Collection<ShareTypeRendererBean> getViewTypes() {
        return ShareTypeRendererBean.getShareTypeRendererBeans(this.authenticationContext, this.shareTypeFactory, ShareType.UsageContextType.VIEW, PortalPage.ENTITY_TYPE);
    }

    public Collection<ShareTypeRendererBean> getEditTypes() {
        return ShareTypeRendererBean.getShareTypeRendererBeans(this.authenticationContext, this.shareTypeFactory, ShareType.UsageContextType.VIEW_EDIT, PortalPage.ENTITY_TYPE);
    }

    public boolean showShares() {
        return this.isEditEnabled() || !this.getPermissions().isEmpty();
    }

    public boolean showEditors() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.SHARED_ENTITY_EDIT_RIGHTS);
    }

    public boolean isEditEnabled() {
        return this.permissionsManager.hasPermission(22, this.getLoggedInUser());
    }

    public String getJsonString() {
        ArrayList sortedShares = new ArrayList(this.getPermissions().getPermissionSet());
        Collections.sort(sortedShares, this.shareTypeFactory.getPermissionComparator());
        try {
            return SharePermissionUtils.toJsonArray(sortedShares).toString();
        }
        catch (JSONException e) {
            this.log.error((Object)("Unable to create JSON representation of shares: " + e.getMessage()), (Throwable)e);
            return "";
        }
    }
}

