/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.user.UserEventDispatcher;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.mobile.JiraMobileUtils;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;

public class ForgotLoginDetails
extends JiraWebActionSupport {
    private final UserUtil userUtil;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final UserSearchService userSearchService;
    private final PageBuilderService pageBuilderService;
    private String username;
    private String email;
    private boolean forgotPassword = false;
    private boolean forgotUserName = false;
    private static final String FORGOT_PASSWORD = "forgotPassword";
    private static final String FORGOT_USER_NAME = "forgotUserName";
    private static final String JIRA_LOGIN_URI = "/login.jsp";
    private static final String JIRA_HOME_URI = "/secure/MyJiraHome.jspa";

    public ForgotLoginDetails(UserUtil userUtil, ApplicationProperties applicationProperties, UserManager userManager, UserSearchService userSearchService, PageBuilderService pageBuilderService) {
        this.userUtil = userUtil;
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
        this.userSearchService = userSearchService;
        this.pageBuilderService = pageBuilderService;
    }

    protected String doExecute() throws Exception {
        if (this.isExternalUserManagement() || !this.userManager.hasPasswordWritableDirectory()) {
            throw new IllegalStateException("User login details can not be reset for this JIRA site.");
        }
        if (!this.forgotPassword && !this.forgotUserName) {
            this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:forgot-login-details-validation");
            this.forgotPassword = true;
            return "input";
        }
        if (this.forgotPassword) {
            return this.doPassword();
        }
        return this.doUserNames();
    }

    private String doPassword() {
        Map eventParams;
        int userEventType;
        if (!this.isSubmittedUserNameValid()) {
            return this.passwordSuccessPage();
        }
        ApplicationUser user = this.userUtil.getUser(this.username);
        if (this.userManager.canUpdateUserPassword(user)) {
            userEventType = 2;
            UserUtil.PasswordResetToken passwordResetToken = this.userUtil.generatePasswordResetToken(user);
            eventParams = MapBuilder.build((Object)"username", (Object)this.username, (Object)"password.token", (Object)passwordResetToken.getToken(), (Object)"password.hours", (Object)passwordResetToken.getExpiryHours());
        } else {
            userEventType = 4;
            eventParams = MapBuilder.build((Object)"username", (Object)this.username);
        }
        UserEventDispatcher.dispatchEvent(userEventType, user, eventParams);
        return this.passwordSuccessPage();
    }

    private String passwordSuccessPage() {
        return "password_success";
    }

    private boolean isSubmittedUserNameValid() {
        return this.username != null && this.userUtil.getUser(this.username) != null;
    }

    private String doUserNames() {
        if (!this.isSubmittedEmailValid()) {
            return this.userNameSuccessPage();
        }
        ArrayList users = Lists.newArrayList((Iterable)this.userSearchService.findUsersByEmail(this.email));
        ArrayList managedUsers = Lists.newArrayListWithCapacity((int)users.size());
        ArrayList unManagedUsers = Lists.newArrayListWithCapacity((int)users.size());
        for (ApplicationUser user : users) {
            if (this.userManager.canUpdateUserPassword(user)) {
                managedUsers.add(user);
                continue;
            }
            unManagedUsers.add(user);
        }
        UserEventDispatcher.dispatchEvent(3, (ApplicationUser)users.get(0), MapBuilder.build((Object)"users", (Object)users, (Object)"managedUsers", (Object)managedUsers, (Object)"unmanagedUsers", (Object)unManagedUsers));
        return this.userNameSuccessPage();
    }

    private String userNameSuccessPage() {
        return "username_success";
    }

    private boolean isSubmittedEmailValid() {
        return this.userSearchService.findUsersByEmail(this.email).iterator().hasNext();
    }

    private boolean isExternalUserManagement() {
        return this.applicationProperties.getOption("jira.option.user.externalmanagement");
    }

    public boolean checked(String id) {
        if (FORGOT_PASSWORD.equals(id)) {
            return this.forgotPassword;
        }
        if (FORGOT_USER_NAME.equals(id)) {
            return this.forgotUserName;
        }
        return false;
    }

    public String displayStyle(String id) {
        if (FORGOT_PASSWORD.equals(id)) {
            return this.forgotPassword ? "" : "display:none";
        }
        if (FORGOT_USER_NAME.equals(id)) {
            return this.forgotUserName ? "" : "display:none";
        }
        return "";
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setForgotten(String forgotten) {
        this.forgotPassword = FORGOT_PASSWORD.equals(forgotten);
        this.forgotUserName = FORGOT_USER_NAME.equals(forgotten);
    }

    public String getCancelLinkURI() {
        return JiraMobileUtils.isMobileAppRequest(this.getHttpRequest()) ? JIRA_LOGIN_URI : JIRA_HOME_URI;
    }
}

