/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.navigation.FooterModuleDescriptor;
import com.atlassian.jira.plugin.navigation.PluggableFooter;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.MetalResourcesManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.seraph.config.SecurityConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;

public class Error404
extends JiraWebActionSupport {
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final FeatureManager featureManager;

    public Error404(ApplicationProperties applicationProperties, PluginAccessor pluginAccessor, FeatureManager featureManager) {
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = pluginAccessor;
        this.featureManager = featureManager;
    }

    protected String doExecute() throws Exception {
        Object loggedInUser = this.getLoggedInUserUsingSeraphAuthenticator();
        try {
            if (loggedInUser == null && this.featureManager.isEnabled(JiraFeatureFlagRegistrar.REDIRECTING_ANONYMOUS_ACCESS_TO_404_ERRORS)) {
                this.log.warn((Object)String.format("Detected anonymous access to page <%s> redirecting to login page", this.getOriginalURL()));
                return this.redirectToLogin();
            }
        }
        catch (NullPointerException e) {
            this.log.error((Object)"Error occurred during verification. Displaying error page without verification", (Throwable)e);
        }
        return "success";
    }

    private Object getLoggedInUserUsingSeraphAuthenticator() {
        SecurityConfig securityConfig = (SecurityConfig)this.getHttpRequest().getServletContext().getAttribute("seraph_config");
        return securityConfig.getAuthenticator().getUser(this.getHttpRequest());
    }

    private String redirectToLogin() {
        HttpServletRequest request = this.getHttpRequest();
        String returnURL = this.getOriginalURL();
        if (request.getQueryString() != null) {
            returnURL = returnURL + "?" + request.getQueryString();
        }
        try {
            return this.getRedirect("/login.jsp?os_destination=" + URLEncoder.encode(returnURL, ComponentAccessor.getApplicationProperties().getEncoding()), false);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)"Unsupported encoding in Jira detected. JVM doesn't work correctly with selected encoding", (Throwable)e);
            throw new IllegalStateException("Jira encoding is unsupported by jvm tools", e);
        }
    }

    public HttpServletRequest getHttpRequest() {
        return ExecutingHttpRequest.get();
    }

    @ActionViewData
    public String getOriginalURL() {
        String baseUrl;
        String attribute = (String)this.getHttpRequest().getAttribute("javax.servlet.forward.servlet_path");
        if (attribute == null) {
            attribute = this.getHttpRequest().getRequestURI().substring(this.getHttpRequest().getContextPath().length());
        }
        if ((baseUrl = this.applicationProperties.getDefaultBackedString("jira.baseurl")) == null) {
            baseUrl = JiraUrl.constructBaseUrl((HttpServletRequest)this.getHttpRequest());
        }
        return baseUrl + attribute;
    }

    @ActionViewData
    public String getJiraTitle() {
        return this.applicationProperties.getDefaultBackedString("jira.title");
    }

    @ActionViewData
    public String getFooterContent() {
        FooterModuleDescriptor footer = (FooterModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("jira.footer:standard-footer");
        if (footer != null) {
            return ((PluggableFooter)footer.getModule()).getFullFooterHtml(this.getHttpRequest());
        }
        return "";
    }

    @ActionViewData
    public String getResourcesContent() {
        return MetalResourcesManager.getMetalResources(this.getHttpRequest().getContextPath());
    }
}

