/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SequencedCollection;

public class FilterUtils {
    public static String verifyString(String s) {
        if (TextUtils.stringSet((String)TextUtils.noNull((String)s).trim())) {
            return s;
        }
        return null;
    }

    public static String[] verifyStringArray(String[] sa) {
        ArrayList result = Lists.newArrayListWithCapacity((int)sa.length);
        for (String aSa : sa) {
            String s = FilterUtils.verifyString(aSa);
            if (s == null) continue;
            result.add(s);
        }
        if (result.size() == 0) {
            return null;
        }
        String[] resultSa = new String[result.size()];
        int count = 0;
        for (String aResult : result) {
            resultSa[count++] = aResult;
        }
        return resultSa;
    }

    public static Long verifyLong(Long id) {
        if (id != null && id > 0L) {
            return id;
        }
        return null;
    }

    public static Collection getGroups(ApplicationUser user) {
        SequencedCollection<String> groups;
        if (user == null) {
            return null;
        }
        UserUtil userUtil = (UserUtil)ComponentAccessor.getComponent(UserUtil.class);
        GroupManager groupManager = (GroupManager)ComponentAccessor.getComponent(GroupManager.class);
        if (ComponentAccessor.getPermissionManager().hasPermission(0, user)) {
            groups = Lists.newArrayListWithCapacity((int)groupManager.getAllGroups().size());
            for (Group group : groupManager.getAllGroups()) {
                groups.add(group.getName());
            }
        } else {
            groups = userUtil.getGroupNamesForUser(user.getName());
        }
        return groups;
    }
}

