/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.dispatcher;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.JiraPluginCacheResetEvent;
import com.atlassian.jira.plugin.webwork.WebworkModuleDescriptor;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Map;
import webwork.dispatcher.ConfigurationViewMapping;
import webwork.dispatcher.DynamicViewMapping;
import webwork.dispatcher.ViewMapping;

public class PluginsAwareViewMapping
implements ViewMapping {
    ViewMapping getDelegateComponent() {
        return (ViewMapping)ComponentAccessor.getComponentOfType(Component.class);
    }

    public Object getView(String anActionName, String aViewName) {
        return this.getDelegateComponent().getView(anActionName, aViewName);
    }

    @EventComponent
    public static class Component
    implements ViewMapping {
        @ClusterSafe(value="Driven by plugin state, which is kept in synch across the cluster")
        private final LazyReference<ResettableDynamicViewMapping> resettableDynamicViewMapping = new LazyReference<ResettableDynamicViewMapping>(){

            protected ResettableDynamicViewMapping create() throws Exception {
                return new ResettableDynamicViewMapping((ViewMapping)new ConfigurationViewMapping());
            }
        };

        public Object getView(String anActionName, String aViewName) {
            return ((ResettableDynamicViewMapping)((Object)this.resettableDynamicViewMapping.get())).getView(anActionName, aViewName);
        }

        @EventListener
        public void onJiraPluginCacheResetEvent(JiraPluginCacheResetEvent event) {
            if (event.hasAnyEventWithModuleDescriptorMatching(WebworkModuleDescriptor.class::isInstance)) {
                ((ResettableDynamicViewMapping)((Object)this.resettableDynamicViewMapping.get())).getCache().clear();
            }
        }

        private static class ResettableDynamicViewMapping
        extends DynamicViewMapping {
            public ResettableDynamicViewMapping(ViewMapping aDelegate) {
                super(aDelegate);
            }

            Map getCache() {
                return this.cache;
            }
        }
    }
}

