/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.util.thread.ForceCleanJiraThreadLocalFilterStep;
import com.atlassian.jira.web.debug.BreakpointReadyHttpServletRequest;
import com.atlassian.jira.web.debug.BreakpointReadyHttpServletResponse;
import com.atlassian.jira.web.filters.ClearInstrumentationStep;
import com.atlassian.jira.web.filters.steps.ChainedFilterStepRunner;
import com.atlassian.jira.web.filters.steps.FilterStep;
import com.atlassian.jira.web.filters.steps.i18n.I18nTranslationsModeThreadlocaleStep;
import com.atlassian.jira.web.filters.steps.instrumentation.InstrumentationStep;
import com.atlassian.jira.web.filters.steps.newrelic.NewRelicTransactionNameStep;
import com.atlassian.jira.web.filters.steps.requestinfo.RequestInfoFirstStep;
import com.atlassian.jira.web.filters.steps.security.HttpSecurityStep;
import com.atlassian.jira.web.filters.steps.senderror.CaptureSendErrorMessageStep;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JiraFirstFilter
extends ChainedFilterStepRunner {
    @Override
    protected List<FilterStep> getFilterSteps() {
        return Lists.newArrayList((Object[])new FilterStep[]{new ForceCleanJiraThreadLocalFilterStep(), new RequestInfoFirstStep(), InstrumentationStep.create(), new CaptureSendErrorMessageStep(), new I18nTranslationsModeThreadlocaleStep(), new NewRelicTransactionNameStep(), new ClearInstrumentationStep(), new HttpSecurityStep()});
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Pair<ServletRequest, ServletResponse> debugWrapped = this.wrap(servletRequest, servletResponse);
        super.doFilter((ServletRequest)debugWrapped.first(), (ServletResponse)debugWrapped.second(), filterChain);
    }

    private Pair<ServletRequest, ServletResponse> wrap(ServletRequest servletRequest, ServletResponse servletResponse) {
        if (JiraSystemProperties.getInstance().isDevMode()) {
            return Pair.of((Object)((Object)new BreakpointReadyHttpServletRequest((HttpServletRequest)servletRequest)), (Object)this.wrapServletResponse(servletResponse));
        }
        return Pair.of((Object)servletRequest, (Object)servletResponse);
    }

    private ServletResponse wrapServletResponse(ServletResponse servletResponse) {
        return new BreakpointReadyHttpServletResponse((HttpServletResponse)servletResponse);
    }
}

