/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.accesslog;

import java.text.DecimalFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class AccessLogBuilder {
    private ReadableInstant dateOfEvent;
    private String requestId;
    private final HttpServletRequest httpReq;
    private String url;
    private String userName;
    private String sessionId;
    private long responseTimeMS = -1L;
    private int httpStatusCode = -1;
    private long responseContentLength = -1L;
    private static final String LOG_DF = "[dd/MMM/yyyy:HH:mm:ss Z]";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"[dd/MMM/yyyy:HH:mm:ss Z]");

    public AccessLogBuilder(HttpServletRequest httpReq) {
        this.httpReq = httpReq;
    }

    public ReadableInstant getDateOfEvent() {
        return this.dateOfEvent;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public HttpServletRequest getHttpReq() {
        return this.httpReq;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getResponseTimeMS() {
        return this.responseTimeMS;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public long getResponseContentLength() {
        return this.responseContentLength;
    }

    public AccessLogBuilder setDateOfEvent(ReadableInstant dateOfEvent) {
        this.dateOfEvent = dateOfEvent;
        return this;
    }

    public AccessLogBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public AccessLogBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public AccessLogBuilder setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public AccessLogBuilder setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public AccessLogBuilder setResponseTimeMS(long responseTimeMS) {
        this.responseTimeMS = responseTimeMS;
        return this;
    }

    public AccessLogBuilder setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
        return this;
    }

    public AccessLogBuilder setResponseContentLength(long responseContentLength) {
        this.responseContentLength = responseContentLength;
        return this;
    }

    public String toApacheCombinedLogFormat() {
        String transportProtocol = this.httpReq.getProtocol();
        String httpMethod = this.httpReq.getMethod();
        String remoteAddress = this.httpReq.getRemoteAddr();
        String userAgent = this.httpReq.getHeader("User-Agent");
        String referer = this.httpReq.getHeader("Referer");
        String dateStr = this.dateOfEvent == null ? AccessLogBuilder.getDateString((ReadableInstant)new DateTime()) : AccessLogBuilder.getDateString(this.dateOfEvent);
        Long contentLen = this.responseContentLength < 0L ? null : Long.valueOf(this.responseContentLength);
        Long responseTimeMillis = this.responseTimeMS < 0L ? null : Long.valueOf(this.responseTimeMS);
        Integer httpStatus = this.httpStatusCode < 0 ? null : Integer.valueOf(this.httpStatusCode);
        StringBuilder urlStr = new StringBuilder().append(AccessLogBuilder.enc(httpMethod)).append(" ").append(AccessLogBuilder.enc(this.url)).append(" ").append(AccessLogBuilder.enc(transportProtocol));
        return AccessLogBuilder.enc(remoteAddress) + " " + AccessLogBuilder.enc(this.requestId) + " " + AccessLogBuilder.enc(this.userName) + " " + AccessLogBuilder.enc(dateStr) + " " + AccessLogBuilder.quote(urlStr) + " " + AccessLogBuilder.enc(httpStatus) + " " + AccessLogBuilder.enc(contentLen) + " " + AccessLogBuilder.enc(AccessLogBuilder.formatMStoDecimalSecs(responseTimeMillis)) + " " + AccessLogBuilder.quote(referer) + " " + AccessLogBuilder.quote(userAgent) + " " + AccessLogBuilder.quote(this.sessionId);
    }

    static String quote(Object o) {
        if (o == null || StringUtils.isBlank((CharSequence)o.toString())) {
            return "-";
        }
        return "\"" + o.toString().trim() + "\"";
    }

    static String enc(Object o) {
        if (o == null || StringUtils.isBlank((CharSequence)o.toString())) {
            return "-";
        }
        return o.toString().trim();
    }

    static String getDateString(ReadableInstant date) {
        if (date == null) {
            return "-";
        }
        return DATE_FORMAT.print(date);
    }

    static String formatMStoDecimalSecs(Long responseMS) {
        if (responseMS == null) {
            return null;
        }
        float secs = (float)responseMS.longValue() / 1000.0f;
        return new DecimalFormat("#0.0000").format(secs);
    }
}

