/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.i18n.BootstrapJiraAuthenticationContext;
import com.atlassian.jira.plugin.navigation.FooterModuleDescriptor;
import com.atlassian.jira.plugin.navigation.PluggableFooter;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtilsImpl;
import com.atlassian.jira.web.servlet.InternalServerErrorServlet;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.jira.web.util.InternalServerErrorDataSource;
import com.atlassian.jira.web.util.MetalResourcesManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class InternalServerErrorHelper {
    private static final Logger logger = LoggerFactory.getLogger(InternalServerErrorServlet.class);
    private final String id;
    private final HttpServletRequest req;
    private final ImmutableMap.Builder<String, Object> map;
    private final Writer writer;
    private final I18nHelper i18n;
    private final boolean isDevMode;
    private final boolean isAdmin;
    private final boolean isSysAdmin;
    private final InternalServerErrorDataSource dataSource;

    public static void render500ResponsePage(HttpServletRequest req, Writer writer) throws IOException {
        String errorId = UUID.randomUUID().toString();
        try {
            InternalServerErrorHelper instance = new InternalServerErrorHelper(req, writer, errorId);
            InternalServerErrorHelper.logError(instance.getDataSource(), errorId);
            instance.render();
        }
        catch (RuntimeException re) {
            logger.error("Cannot render the 500 page for error {}", (Object)errorId, (Object)re);
            writer.write(InternalServerErrorHelper.simple500ErrorPage(errorId));
        }
    }

    private static void logError(InternalServerErrorDataSource dataSource, String errorId) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("errorId", errorId);
        map.putAll(dataSource.getGeneralInfo());
        logger.error(((Object)map).toString());
    }

    private static String simple500ErrorPage(String errorId) {
        return "<html>\n<head><title>JIRA &mdash; Internal Server Error</title>\n<meta name=\"decorator\" content=\"none\"/>\n</head><body>\n<h1>JIRA &mdash; Internal Server Error</h1>\n<p>Error reference: " + errorId + "</p>\n<p>Unable to render full error details at this time.\nPlease consult the error logs for more information.</p>\n</body></html>\n";
    }

    private InternalServerErrorHelper(HttpServletRequest req, Writer writer, String id) {
        JiraAuthenticationContext authenticationContext = ComponentAccessor.getComponentSafely(JiraAuthenticationContext.class).orElseGet(BootstrapJiraAuthenticationContext::new);
        ApplicationUser user = authenticationContext.getLoggedInUser();
        this.id = id;
        this.req = req;
        this.map = ImmutableMap.builder();
        this.writer = writer;
        this.i18n = authenticationContext.getI18nHelper();
        this.isDevMode = JiraSystemProperties.getInstance().isDevMode();
        this.isAdmin = InternalServerErrorHelper.isAdmin(user);
        this.isSysAdmin = InternalServerErrorHelper.isSysAdmin(user);
        this.dataSource = this.initializeInternalServerErrorDS(req, logger);
    }

    private boolean render() throws IOException {
        this.addBasicInfo();
        this.addTechnicalDetails(this.dataSource);
        return this.renderSoy();
    }

    public InternalServerErrorDataSource getDataSource() {
        return this.dataSource;
    }

    private boolean renderSoy() {
        SoyTemplateRenderer renderer;
        if (ComponentAccessor.getComponentSafely(PluginAccessor.class).isPresent() && (renderer = (SoyTemplateRenderer)ComponentAccessor.getOSGiComponentInstanceOfType(SoyTemplateRenderer.class)) != null) {
            renderer.render((Appendable)this.writer, "jira.webresources:jira-errors", "JIRA.Templates.errors.InternalError.page", (Map)this.map.build());
            return true;
        }
        return false;
    }

    private void addTechnicalDetails(InternalServerErrorDataSource ds) {
        boolean shouldShowFullInfo;
        ImmutableMap.Builder technicalDetails = ImmutableMap.builder();
        boolean bl = shouldShowFullInfo = this.isAdmin || this.isDevMode;
        if (shouldShowFullInfo && !Boolean.parseBoolean(this.req.getParameter("short"))) {
            ds.appendFullMessageData((ImmutableMap.Builder<String, Object>)technicalDetails, this.isSysAdmin || this.isDevMode);
            this.map.put((Object)"fullInfo", (Object)true);
        } else {
            ds.appendSimpleMessageData((ImmutableMap.Builder<String, Object>)technicalDetails);
            this.map.put((Object)"fullInfo", (Object)false);
        }
        this.map.put((Object)"technicalDetails", (Object)technicalDetails.build());
    }

    private void addBasicInfo() {
        this.map.put((Object)"footer", (Object)this.getFooterContent());
        this.map.put((Object)"helpsteps", this.getHelpSteps());
        this.map.put((Object)"resourcesContent", (Object)MetalResourcesManager.getMetalResources(this.req.getContextPath()));
        this.map.put((Object)"errorId", (Object)this.id);
    }

    private String getFooterContent() {
        return ComponentAccessor.getComponentSafely(PluginAccessor.class).map(InternalServerErrorHelper::getFooterModule).map(footer -> ((PluggableFooter)footer.getModule()).getFullFooterHtml(this.req)).orElse("");
    }

    private static FooterModuleDescriptor getFooterModule(PluginAccessor pluginAccessor) {
        return (FooterModuleDescriptor)pluginAccessor.getEnabledPluginModule("jira.footer:standard-footer");
    }

    private InternalServerErrorDataSource initializeInternalServerErrorDS(HttpServletRequest req, Logger log) {
        Optional localeManager = ComponentAccessor.getComponentSafely(LocaleManager.class);
        ExtendedSystemInfoUtilsImpl extendedSystemInfoUtils = null;
        try {
            if (localeManager.isPresent()) {
                extendedSystemInfoUtils = new ExtendedSystemInfoUtilsImpl(this.i18n);
            }
        }
        catch (RuntimeException e) {
            log.warn("Cannot initialize ExtendedSystemInfoUtilsImpl", (Throwable)e);
        }
        return new InternalServerErrorDataSource(this.i18n, extendedSystemInfoUtils, req.getServletContext(), localeManager.orElse(null), req);
    }

    private List<String> getHelpSteps() {
        return this.isAdmin ? this.getJiraSupportHelpSteps() : this.getContactJiraAdminHelpSteps();
    }

    private List<String> getContactJiraAdminHelpSteps() {
        String contactAdministratorsLink = this.getContactAdministratorLink();
        return ImmutableList.of((Object)(contactAdministratorsLink != null ? this.i18n.getText("500.send.with.ref.to.your.jira.admin.contact.form", "<a target=\"_blank\" href=\"" + contactAdministratorsLink + "\">", "</a>") : this.i18n.getText("500.send.with.ref.to.your.jira.admin")));
    }

    private List<String> getJiraSupportHelpSteps() {
        ExternalLinkUtilImpl externalLinkUtil = new ExternalLinkUtilImpl();
        String sac = externalLinkUtil.getProperty("external.link.jira.support.site");
        String stp = this.req.getContextPath() + "/plugins/servlet/troubleshooting/view/#support-zip";
        return ImmutableList.of((Object)this.i18n.getText("500.collect.when.problem.occurred"), (Object)this.i18n.getText("500.collect.server.log"), (Object)this.i18n.getText("500.create.support.zip", "<a target=\"_blank\" href=\"" + stp + "\">", "</a>"), (Object)this.i18n.getText("500.raise.an.issue.with.all.info", "<a href=\"" + sac + "\">", "</a>"));
    }

    private List<String> getContactCloudAdminHelpSteps() {
        String contactAdministratorsLink = this.getContactAdministratorLink();
        return ImmutableList.of((Object)(contactAdministratorsLink != null ? this.i18n.getText("500.send.to.your.jira.admin.contact.form", "<a target=\"_blank\" href=\"" + contactAdministratorsLink + "\">", "</a>") : this.i18n.getText("500.send.to.your.jira.admin")));
    }

    private List<String> getCloudSupportHelpSteps() {
        ExternalLinkUtilImpl externalLinkUtil = new ExternalLinkUtilImpl();
        String sac = externalLinkUtil.getProperty("external.link.jira.support.site");
        return ImmutableList.of((Object)this.i18n.getText("500.raise.an.issue.on.sac", "<a href=\"" + sac + "\">", "</a>"));
    }

    private String getContactAdministratorLink() {
        try {
            return ComponentAccessor.getComponentSafely(JiraContactHelper.class).filter(JiraContactHelper::isAdministratorContactFormEnabled).map(helper -> helper.getAdministratorContactLink(this.req.getContextPath())).orElse(null);
        }
        catch (RuntimeException re) {
            logger.debug("[{}] Error retrieving contact adminstrator link", (Object)this.id, (Object)re);
            return null;
        }
    }

    private static boolean isSysAdmin(ApplicationUser user) {
        return user != null && ComponentAccessor.getComponentSafely(PermissionManager.class).map(permissionManager -> permissionManager.hasPermission(44, user)).orElse(false) != false;
    }

    private static boolean isAdmin(ApplicationUser user) {
        return user != null && ComponentAccessor.getComponentSafely(PermissionManager.class).map(permissionManager -> permissionManager.hasPermission(0, user) || permissionManager.hasPermission(44, user)).orElse(false) != false;
    }
}

