/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.edit;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.edit.TransitionOptions;
import com.atlassian.jira.workflow.edit.layout.display.TransitionOption;
import com.atlassian.jira.workflow.edit.utilities.MetadataUtils;
import com.atlassian.jira.workflow.tabs.WorkflowTransitionTabProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class TransitionOptionsImpl
implements TransitionOptions {
    private static final Comparator<TransitionOption> TRANSITION_OPTION_COMPARATOR = new Comparator<TransitionOption>(){

        @Override
        public int compare(TransitionOption transitionOption, TransitionOption transitionOption2) {
            return Double.compare(transitionOption.getWeight(), transitionOption2.getWeight());
        }
    };
    @VisibleForTesting
    static final int PROPERTIES_WEIGHT = 10;
    @VisibleForTesting
    private static final String PROPERTIES_KEY = "properties.key";
    private final WorkflowTransitionTabProvider tabProvider;
    private final I18nHelper i18nHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final WorkflowService workflowService;

    @Autowired
    public TransitionOptionsImpl(WorkflowTransitionTabProvider tabProvider, I18nHelper i18nHelper, JiraAuthenticationContext jiraAuthenticationContext, WorkflowService workflowService) {
        this.tabProvider = tabProvider;
        this.i18nHelper = i18nHelper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.workflowService = workflowService;
    }

    @Override
    public List<TransitionOption> getOptionsForAction(ActionDescriptor actionDescriptor, JiraWorkflow workflow) {
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), workflow)) {
            return ImmutableList.of();
        }
        ArrayList transitionTabs = Lists.newArrayList(this.tabProvider.getTabs(actionDescriptor, workflow));
        ArrayList transitionOptions = Lists.newArrayListWithCapacity((int)transitionTabs.size());
        for (WorkflowTransitionTabProvider.WorkflowTransitionTab tab : transitionTabs) {
            int parsedCount = this.getItemCountOfTransitionTab(tab);
            transitionOptions.add(new TransitionOption(tab.getModule().getCompleteKey(), tab.getLabel(), parsedCount, this.getTransitionOptionUrl(actionDescriptor, workflow, tab), tab.getModule().getWeight()));
        }
        transitionOptions.add(this.createPropertiesOption(actionDescriptor, workflow));
        Collections.sort(transitionOptions, TRANSITION_OPTION_COMPARATOR);
        return ImmutableList.copyOf((Collection)transitionOptions);
    }

    private int getItemCountOfTransitionTab(WorkflowTransitionTabProvider.WorkflowTransitionTab tab) {
        int parsedCount;
        try {
            parsedCount = Integer.parseInt(tab.getCount());
        }
        catch (NumberFormatException e) {
            parsedCount = 0;
        }
        return parsedCount;
    }

    private String getTransitionOptionUrl(ActionDescriptor actionDescriptor, JiraWorkflow workflow, WorkflowTransitionTabProvider.WorkflowTransitionTab transitionTab) {
        return new WorkflowUrlBuilder("/secure/admin/workflows/ViewWorkflowTransition.jspa").addTransitionQueryParams(actionDescriptor, workflow).addQueryParam("descriptorTab", transitionTab.getModule().getKey()).build();
    }

    private TransitionOption createPropertiesOption(ActionDescriptor actionDescriptor, JiraWorkflow workflow) {
        return new TransitionOption(PROPERTIES_KEY, this.i18nHelper.getText("common.words.properties"), this.getPropertiesCount(actionDescriptor), this.getPropertiesUrl(actionDescriptor, workflow), 10);
    }

    private int getPropertiesCount(ActionDescriptor actionDescriptor) {
        int propertiesCount = 0;
        for (Object key : actionDescriptor.getMetaAttributes().keySet()) {
            if (MetadataUtils.isReservedKey(key.toString())) continue;
            ++propertiesCount;
        }
        return propertiesCount;
    }

    private String getPropertiesUrl(ActionDescriptor actionDescriptor, JiraWorkflow workflow) {
        return new WorkflowUrlBuilder("/secure/admin/workflows/ViewWorkflowTransitionMetaAttributes.jspa").addTransitionQueryParams(actionDescriptor, workflow).build();
    }

    private static class WorkflowUrlBuilder {
        @Nonnull
        private final UrlBuilder builder;

        public WorkflowUrlBuilder(String baseUrl) {
            this.builder = new UrlBuilder(baseUrl);
        }

        public WorkflowUrlBuilder addQueryParam(String name, String value) {
            this.builder.addParameter(name, value);
            return this;
        }

        public WorkflowUrlBuilder addTransitionQueryParams(ActionDescriptor actionDescriptor, JiraWorkflow workflow) {
            this.builder.addParameter("workflowMode", workflow.isDraftWorkflow() ? "draft" : "live").addParameter("workflowName", workflow.getName()).addParameter("workflowTransition", (Object)actionDescriptor.getId());
            return this;
        }

        public String build() {
            return this.builder.toString();
        }
    }
}

