/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.edit;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.edit.TransitionData;
import com.atlassian.jira.workflow.edit.Workflow;
import com.atlassian.jira.workflow.edit.WorkflowGlobalTransitions;
import com.atlassian.jira.workflow.edit.Workflows;
import com.atlassian.jira.workflow.edit.utilities.OutcomeHelper;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class WorkflowGlobalTransitionsImpl
implements WorkflowGlobalTransitions {
    private static final Pattern GENERATED_GLOBAL_TRANSITION_NAME_PATTERN = Pattern.compile("(.*)\\(([0-9]+)\\)$");
    private final Workflows workflows;
    private final StatusManager statusManager;
    private final FieldScreenManager fieldScreenManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final OutcomeHelper outcomeHelper;
    private final WorkflowService workflowService;

    public WorkflowGlobalTransitionsImpl(StatusManager statusManager, Workflows workflows, FieldScreenManager fieldScreenManager, JiraAuthenticationContext jiraAuthenticationContext, OutcomeHelper outcomeHelper, WorkflowService workflowService) {
        this.workflows = workflows;
        this.statusManager = statusManager;
        this.fieldScreenManager = fieldScreenManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.outcomeHelper = outcomeHelper;
        this.workflowService = workflowService;
    }

    @Override
    public ServiceOutcome<Workflow> createGlobalTransition(String statusId, String workflowName, String globalTransitionName, String globalTransitionDescription, Long screenId) {
        Status status = this.statusManager.getStatus(statusId);
        ServiceOutcome<Workflow> verificationResult = this.verifyGlobalTransitionCanBeAdded(globalTransitionName, status, workflowName, screenId);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        globalTransitionName = this.resolveUniqueGlobalTransitionName(workflow, globalTransitionName);
        ServiceOutcome<Workflow> result = workflow.addGlobalTransition(Workflow.AddTransitionParameters.builder().name(globalTransitionName).description(globalTransitionDescription).screen(this.fieldScreenManager.getFieldScreen(screenId)).targetStatus(status).build());
        if (!result.isValid()) {
            return result;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    @Override
    public ServiceOutcome<TransitionData> addGlobalTransitionToWorkflow(String workflowName, String statusId, String globalTransitionName, String globalTransitionDescription, Long screenId) {
        ServiceOutcome<Workflow> verificationResult = this.verifyGlobalTransitionCanBeAdded(globalTransitionName, this.statusManager.getStatus(statusId), workflowName, screenId);
        if (!verificationResult.isValid()) {
            return this.outcomeHelper.errorOutcome(verificationResult.getErrorCollection());
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        globalTransitionName = this.resolveUniqueGlobalTransitionName(workflow, globalTransitionName);
        ServiceOutcome<TransitionData> transitionAdded = workflow.addGlobalTransitionReturningId(Workflow.AddTransitionParameters.builder().name(globalTransitionName).description(globalTransitionDescription).screen(this.fieldScreenManager.getFieldScreen(screenId)).targetStatusId(statusId).build());
        if (transitionAdded.isValid()) {
            this.workflows.saveWorkflow(workflow);
        }
        return transitionAdded;
    }

    @Override
    public ServiceOutcome<Workflow> deleteGlobalTransition(String globalTransitionId, String workflowName) {
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), workflowName))) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return workflowOutcome;
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        ServiceOutcome<Workflow> result = workflow.deleteGlobalTransition(globalTransitionId);
        if (!result.isValid()) {
            return result;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    @Override
    public ServiceOutcome<Workflow> updateGlobalTransition(int transitionId, String name, String description, Long screenId, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyGlobalTransitionCanBeUpdated(transitionId, name, workflowName, screenId);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> updateOutcome = workflow.updateGlobalTransition(transitionId, name, description, this.fieldScreenManager.getFieldScreen(screenId));
        if (!updateOutcome.isValid()) {
            return updateOutcome;
        }
        return this.workflows.saveWorkflow((Workflow)updateOutcome.getReturnedValue());
    }

    private ServiceOutcome<Workflow> verifyGlobalTransitionCanBeAdded(String name, Status status, String workflowName, Long screenId) {
        FieldScreen fieldScreen;
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), workflowName))) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        if (status == null) {
            return this.outcomeHelper.errorOutcome("workflow.edit.status.not.found", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.statusExistsOnWorkflow(status)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.adding.global.transition.no.status", new Object[0]);
        }
        if (workflow.statusHasGlobalTransition(status)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.adding.global.transition.duplicate", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return this.outcomeHelper.errorOutcome("workflow.edit.transition.screen.not.found", new Object[0]);
        }
        return this.outcomeHelper.okOutcome(workflow);
    }

    @Override
    public ServiceOutcome<Workflow> verifyGlobalTransitionCanBeUpdated(int transitionId, String name, String workflowName, Long screenId) {
        FieldScreen fieldScreen;
        if (!this.workflowService.isWorkflowEditable(this.jiraAuthenticationContext.getLoggedInUser(), this.workflowService.getWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()), workflowName))) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.hasTransition(transitionId)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.updating.transition.not.found", new Object[0]);
        }
        if (!name.equals(workflow.getTransitionName(transitionId)) && (workflow.isDuplicateGlobalTransitionName(name) || workflow.targetStatusHasExistingTransitionWithName(transitionId, name))) {
            return this.outcomeHelper.errorOutcome("workflow.edit.transition.name.exists", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return this.outcomeHelper.errorOutcome("workflow.edit.transition.screen.not.found", new Object[0]);
        }
        return this.outcomeHelper.okOutcome(workflow);
    }

    private boolean screenIdSet(Long screenId) {
        return screenId != null && screenId != 0L;
    }

    private String nextGlobalTransitionName(@Nonnull String transitionName, @Nonnull Set<String> usedStrings) {
        String candidate;
        String baseCandidate = this.extractBaseTransitionName(transitionName);
        int i = 2;
        do {
            candidate = baseCandidate + "(" + i + ")";
            ++i;
        } while (usedStrings.contains(candidate));
        return candidate;
    }

    private String extractBaseTransitionName(String transitionName) {
        Matcher matcher = GENERATED_GLOBAL_TRANSITION_NAME_PATTERN.matcher(transitionName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return transitionName + " ";
    }

    @Override
    public String resolveUniqueGlobalTransitionName(Workflow workflow, String globalTransitionName) {
        Set<String> allTransitions = workflow.getDistinctTransitionNames();
        if (allTransitions.contains(globalTransitionName)) {
            return this.nextGlobalTransitionName(globalTransitionName, allTransitions);
        }
        return globalTransitionName;
    }
}

