/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.configurable;

import com.atlassian.configurable.EnabledCondition;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.component.pico.ComponentManager;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class EnabledConditionFactory {
    private static final Logger log = LoggerFactory.getLogger(EnabledConditionFactory.class);

    static EnabledCondition create(String enabledConditionClass) {
        if (enabledConditionClass == null) {
            log.debug("Cannot instantiate null EnabledCondition");
            return null;
        }
        try {
            Class conditionClass = ClassLoaderUtils.loadClass((String)enabledConditionClass, EnabledConditionFactory.class);
            return (EnabledCondition)ComponentManager.getInstance().loadComponent(conditionClass, Collections.emptyList());
        }
        catch (ClassNotFoundException e) {
            log.warn(String.valueOf(MessageFormatter.format((String)"Cannot find Enabled Condition: '{}'", (Object)e)));
        }
        catch (ClassCastException e) {
            log.warn(String.valueOf(MessageFormatter.format((String)"Enabled Condition : '{}' must implement {}, '{}'", (Object)new String[]{enabledConditionClass, EnabledCondition.class.getName(), e.toString()})));
        }
        return null;
    }
}

