/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.admin;

import com.atlassian.analytics.api.annotations.EventName;

@EventName(value="com.atlassian.jira.admin.tab.loaded")
public class TabLoadedEvent {
    private final Long projectId;
    private final String tab;
    private final boolean admin;
    private final boolean sysAdmin;
    private final boolean hasExtPermission;

    public TabLoadedEvent(Long projectId, String tab, boolean isAdmin, boolean isSysAdmin, boolean hasExtPermission) {
        this.projectId = projectId;
        this.tab = tab;
        this.admin = isAdmin;
        this.sysAdmin = isSysAdmin;
        this.hasExtPermission = hasExtPermission;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public String getTab() {
        return this.tab;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isSysAdmin() {
        return this.sysAdmin;
    }

    public boolean isHasExtPermission() {
        return this.hasExtPermission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TabLoadedEvent that = (TabLoadedEvent)o;
        if (this.admin != that.admin) {
            return false;
        }
        if (this.sysAdmin != that.sysAdmin) {
            return false;
        }
        if (this.hasExtPermission != that.hasExtPermission) {
            return false;
        }
        if (this.projectId != null ? !this.projectId.equals(that.projectId) : that.projectId != null) {
            return false;
        }
        return this.tab != null ? this.tab.equals(that.tab) : that.tab == null;
    }

    public int hashCode() {
        int result = this.projectId != null ? this.projectId.hashCode() : 0;
        result = 31 * result + (this.tab != null ? this.tab.hashCode() : 0);
        result = 31 * result + (this.admin ? 1 : 0);
        result = 31 * result + (this.sysAdmin ? 1 : 0);
        result = 31 * result + (this.hasExtPermission ? 1 : 0);
        return result;
    }
}

