/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency;

import com.atlassian.johnson.event.EventLevel;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class FakeHealthCheckEvent {
    private final EventLevel eventLevel;
    private final boolean dismissible;
    private final boolean configCustomisation;
    private final boolean configCustomisationReadOnly;
    private final boolean configCustomisationSuccess;

    @Nonnull
    static FakeHealthCheckEvent createPhase(String error) {
        String[] errorParsed = error.split("-");
        boolean isDismissible = FakeHealthCheckEvent.getDismissible(errorParsed);
        boolean isConfigCustomisation = FakeHealthCheckEvent.isConfigCustomisation(errorParsed);
        boolean isConfigCustomisationReadOnly = FakeHealthCheckEvent.isConfigCustomisationReadOnly(errorParsed);
        boolean isConfigCustomisationSuccess = FakeHealthCheckEvent.isConfigCustomisationSuccess(errorParsed);
        return new FakeHealthCheckEvent(errorParsed[0], isDismissible, isConfigCustomisation, isConfigCustomisationReadOnly, isConfigCustomisationSuccess);
    }

    private static boolean isConfigCustomisation(String[] errorParsed) {
        return errorParsed.length >= 2 && errorParsed[1].equals(configCustomisationTypes.CONFIG_CUSTOMISATION.description);
    }

    private static boolean isConfigCustomisationReadOnly(String[] errorParsed) {
        return errorParsed.length >= 2 && errorParsed[1].equals(configCustomisationTypes.CONFIG_CUSTOMISATION_READ_ONLY.description);
    }

    private static boolean isConfigCustomisationSuccess(String[] errorParsed) {
        return errorParsed.length >= 2 && errorParsed[1].equals(configCustomisationTypes.CONFIG_CUSTOMISATION_SUCCESS.description);
    }

    private static boolean getDismissible(String[] errorParsed) {
        if (errorParsed.length < 2) {
            return false;
        }
        return errorParsed[1].equals("dismissible") || errorParsed[1].equals(configCustomisationTypes.CONFIG_CUSTOMISATION.description) || errorParsed[1].equals(configCustomisationTypes.CONFIG_CUSTOMISATION_READ_ONLY.description);
    }

    private FakeHealthCheckEvent(String level, boolean isDismissible, boolean configCustomisation, boolean configCustomisationReadOnly, boolean configCustomisationSuccess) {
        this.eventLevel = EventLevel.get((String)level);
        this.dismissible = isDismissible;
        this.configCustomisation = configCustomisation;
        this.configCustomisationReadOnly = configCustomisationReadOnly;
        this.configCustomisationSuccess = configCustomisationSuccess;
    }

    EventLevel getLevel() {
        return this.eventLevel;
    }

    boolean isDismissible() {
        return this.dismissible;
    }

    boolean isConfigCustomisation() {
        return this.configCustomisation;
    }

    boolean isConfigCustomisationReadOnly() {
        return this.configCustomisationReadOnly;
    }

    boolean isConfigCustomisationSuccess() {
        return this.configCustomisationSuccess;
    }

    static enum configCustomisationTypes {
        CONFIG_CUSTOMISATION("configCustomisation"),
        CONFIG_CUSTOMISATION_READ_ONLY("configCustomisationReadOnly"),
        CONFIG_CUSTOMISATION_SUCCESS("configCustomisationSuccess");

        String description;

        private configCustomisationTypes(String description) {
            this.description = description;
        }
    }
}

