/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.amendment.DeleteEntityAmendment;
import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import java.util.ArrayList;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFilterSubscriptionsCheck
extends CheckImpl {
    private static final Logger log = LoggerFactory.getLogger(BaseFilterSubscriptionsCheck.class);

    protected BaseFilterSubscriptionsCheck(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public List<DeleteEntityAmendment> preview() throws IntegrityException {
        return this.doCheck(false);
    }

    @Override
    public List<DeleteEntityAmendment> correct() throws IntegrityException {
        return this.doCheck(true);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUnavailableMessage() {
        return "";
    }

    protected List<DeleteEntityAmendment> doCheck(boolean correct) throws IntegrityException {
        ArrayList<DeleteEntityAmendment> messages = new ArrayList<DeleteEntityAmendment>();
        try (OfBizListIterator listIterator = this.ofBizDelegator.findListIteratorByCondition("FilterSubscription", null);){
            GenericValue subscription = listIterator.next();
            while (subscription != null) {
                this.doRealCheck(correct, subscription, messages);
                subscription = listIterator.next();
            }
        }
        catch (Exception e) {
            throw new IntegrityException("Error occurred while performing check.", e);
        }
        if (correct && !messages.isEmpty()) {
            for (DeleteEntityAmendment message : messages) {
                GenericValue subscriptionGV = message.getEntity();
                try {
                    ComponentAccessor.getSubscriptionManager().deleteSubscription(subscriptionGV.getLong("id"));
                }
                catch (Exception e) {
                    log.warn("Unable to remove the subscription from the database", (Throwable)e);
                    throw new IntegrityException(e);
                }
            }
        }
        return messages;
    }

    protected abstract void doRealCheck(boolean var1, GenericValue var2, List<DeleteEntityAmendment> var3) throws IntegrityException;
}

