/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application.install;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import java.io.File;
import java.util.Optional;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Nonnull
public class BundlesVersionDiscovery {
    public static final Logger LOGGER = LoggerFactory.getLogger(BundlesVersionDiscovery.class);

    public Optional<PluginIdentification> getBundleNameAndVersion(File jarFile) {
        try {
            JarPluginArtifact pluginArtifact = new JarPluginArtifact(jarFile);
            Manifest manifest = OsgiHeaderUtil.getManifest((PluginArtifact)pluginArtifact);
            return Optional.ofNullable(this.getBundleNameAndVersion(manifest));
        }
        catch (Exception x) {
            LOGGER.warn("Can't read manifest of file: " + jarFile.getAbsolutePath(), (Throwable)x);
            return Optional.empty();
        }
    }

    private PluginIdentification getBundleNameAndVersion(Manifest manifest) {
        PluginInformation pluginInformation = OsgiHeaderUtil.extractOsgiPluginInformation((Manifest)manifest, (boolean)true);
        String pluginKey = OsgiHeaderUtil.getValidatedAttribute((Manifest)manifest, (String)"Bundle-SymbolicName");
        String version = pluginInformation.getVersion();
        return new PluginIdentification(pluginKey, version);
    }

    public static class PluginIdentification {
        private final String symbolicName;
        private final Version version;

        public PluginIdentification(String symbolicName, String version) {
            this.symbolicName = symbolicName;
            this.version = new Version(version);
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public Version getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginIdentification that = (PluginIdentification)o;
            return this.symbolicName.equals(that.symbolicName) && this.version.equals((Object)that.version);
        }

        public int hashCode() {
            int result = this.symbolicName.hashCode();
            result = 31 * result + this.version.hashCode();
            return result;
        }
    }
}

