/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.ParentlessAssociatedItem;
import com.atlassian.jira.util.NamedWithId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AffectedScheme
extends ParentlessAssociatedItem {
    @Nonnull
    private final String schemeName;
    @Nonnull
    private final Long schemeId;

    public AffectedScheme(@Nonnull NamedWithId scheme) {
        this(scheme.getName(), scheme.getId());
    }

    public AffectedScheme(@Nonnull String schemeName, @Nonnull Long schemeId) {
        this.schemeName = schemeName;
        this.schemeId = schemeId;
    }

    @Nonnull
    public String getObjectName() {
        return this.schemeName;
    }

    @Nullable
    public String getObjectId() {
        return Long.toString(this.schemeId);
    }

    @Nonnull
    public AssociatedItem.Type getObjectType() {
        return AssociatedItem.Type.SCHEME;
    }
}

