/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.ProjectEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.ProjectCreatedEvent;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.jira.event.ProjectUpdatedEvent;
import com.atlassian.jira.event.project.ProjectArchivedEvent;
import com.atlassian.jira.event.project.ProjectAvatarUpdateEvent;
import com.atlassian.jira.event.project.ProjectCategoryChangeEvent;
import com.atlassian.jira.event.project.ProjectCategoryUpdateEvent;
import com.atlassian.jira.event.project.ProjectRestoredEvent;
import com.atlassian.jira.event.role.ProjectRoleCreatedEvent;
import com.atlassian.jira.event.role.ProjectRoleDeletedEvent;
import com.atlassian.jira.event.role.ProjectRoleUpdatedEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@AuditExceptionSafe
public class ProjectEventHandlerImpl
implements ProjectEventHandler {
    @VisibleForTesting
    static final AuditType PROJECT_ROLES_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.PROJECTS, "jira.auditing.project.roles.created", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType PROJECT_REINDEX_STARTED = AuditEntitiesUtils.newAuditType(CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.INDEXING, "jira.auditing.project.reindex.started", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType PROJECT_REINDEX_FINISHED = AuditEntitiesUtils.newAuditType(CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.INDEXING, "jira.auditing.project.reindex.finished", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType PROJECT_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.PROJECTS, "jira.auditing.project.created", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType PROJECT_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.PROJECTS, "jira.auditing.project.updated", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType PROJECT_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.PROJECTS, "jira.auditing.project.deleted", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType PROJECT_CATEGORY_CHANGED = AuditEntitiesUtils.newAuditType(CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.PROJECTS, "jira.auditing.project.category.changed", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType PROJECT_ROLE_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.PROJECTS, "jira.auditing.project.roles.changed", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType PROJECT_ROLE_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.PROJECTS, "jira.auditing.project.role.deleted", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType PROJECT_ARCHIVE = AuditEntitiesUtils.newAuditType(CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.PROJECTS, "jira.auditing.project.archived", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType PROJECT_RESTORED = AuditEntitiesUtils.newAuditType(CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.PROJECTS, "jira.auditing.project.restored", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType PROJECT_CATEGORY_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.PROJECTS, "jira.auditing.project.category.updated", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType PROJECT_AVATAR_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.PROJECTS, "jira.auditing.project.avatar.changed", CoverageLevel.BASE);
    private final I18nHelper.BeanFactory i18n;
    private final ProjectManager projectManager;
    private final AuditService auditService;

    public ProjectEventHandlerImpl(I18nHelper.BeanFactory i18n, ProjectManager projectManager, AuditService auditService) {
        this.i18n = i18n;
        this.projectManager = projectManager;
        this.auditService = auditService;
    }

    @Override
    public void onProjectCreatedEvent(ProjectCreatedEvent event) {
        List<AuditResource> affectedObjects = Arrays.asList(this.projectInfoAuditResource(event), this.projectLeadInfoAuditResource(event.getProject()));
        this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_CREATED).affectedObjects(affectedObjects).changedValues(this.buildChangedValues(event.getProject())).build());
    }

    private AuditResource projectInfoAuditResource(ProjectCreatedEvent event) {
        return AuditEntitiesUtils.newAuditResource(event.getProject().getName(), AssociatedItem.Type.PROJECT.name(), Long.toString(event.getProject().getId()));
    }

    private AuditResource projectLeadInfoAuditResource(Project project) {
        return AuditEntitiesUtils.newAuditResource(project.getProjectLead().getUsername(), AssociatedItem.Type.USER.name(), project.getProjectLead().getKey());
    }

    @Override
    public void onProjectUpdatedEvent(ProjectUpdatedEvent event) {
        List<ChangedValue> changedValues = this.buildChangedValues(event.getOldProject(), event.getProject());
        if (changedValues.isEmpty()) {
            return;
        }
        this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_UPDATED).affectedObject(AuditEntitiesUtils.newAuditResource(event.getProject().getName(), AssociatedItem.Type.PROJECT.name(), Long.toString(event.getProject().getId()))).changedValues(changedValues).build());
    }

    @Override
    public void onProjectDeletedEvent(ProjectDeletedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_DELETED).affectedObject(AuditEntitiesUtils.newAuditResource(event.getProject().getName(), AssociatedItem.Type.PROJECT.name(), Long.toString(event.getProject().getId()))).build());
    }

    @Override
    public void onProjectCategoryChangeEvent(ProjectCategoryChangeEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_CATEGORY_CHANGED).affectedObject(AuditEntitiesUtils.newAuditResource(event.getProject().getName(), AssociatedItem.Type.PROJECT.name(), Long.toString(event.getProject().getId()))).changedValues(this.buildChangedValuesForCategoryChange(event.getOldProjectCategory(), event.getNewProjectCategory())).build());
    }

    @Override
    public void onProjectAvatarUpdateEvent(ProjectAvatarUpdateEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_AVATAR_UPDATED).affectedObject(AuditEntitiesUtils.newAuditResource(event.getProject().getName(), AssociatedItem.Type.PROJECT.name(), Long.toString(event.getProject().getId()))).build());
    }

    @Override
    @ThrowSafe
    public void handleProjectRoleCreatedEvent(ProjectRoleCreatedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_ROLES_CREATED).affectedObject(AuditEntitiesUtils.newAuditResource(StringUtils.defaultString((String)event.getProjectRole().getName()), AssociatedItem.Type.PROJECT_ROLE.name(), Long.toString(event.getProjectRole().getId()))).build());
    }

    @Override
    @ThrowSafe
    public void handleProjectReindexStarted(@Nonnull Project project) {
        this.auditService.audit(this.handleProjectReindexEvent(project, PROJECT_REINDEX_STARTED));
    }

    @Override
    @ThrowSafe
    public void handleProjectReindexFinished(@Nonnull Project project) {
        this.auditService.audit(this.handleProjectReindexEvent(project, PROJECT_REINDEX_FINISHED));
    }

    private AuditEvent handleProjectReindexEvent(Project project, AuditType auditType) {
        return AuditEvent.builder((AuditType)auditType).affectedObject(AuditEntitiesUtils.newAuditResource(project.getName(), AssociatedItem.Type.PROJECT.name(), Long.toString(project.getId()))).build();
    }

    @Override
    public void onProjectRoleUpdatedEvent(ProjectRoleUpdatedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_ROLE_UPDATED).affectedObjects(Arrays.asList(AuditEntitiesUtils.newAuditResource(event.getProjectRole().getName(), AssociatedItem.Type.PROJECT_ROLE.name(), Long.toString(event.getProjectRole().getId())), AuditEntitiesUtils.newAuditResource(event.getProject().getName(), AssociatedItem.Type.PROJECT.name(), Long.toString(event.getProject().getId())))).changedValues(this.computeChangedValues(event.getOriginalRoleActors(), event.getRoleActors())).build());
    }

    @Override
    public void onProjectRoleDeletedEvent(ProjectRoleDeletedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_ROLE_DELETED).affectedObject(AuditEntitiesUtils.newAuditResource(event.getProjectRole().getName(), AssociatedItem.Type.PROJECT_ROLE.name(), Long.toString(event.getProjectRole().getId()))).build());
    }

    @Nonnull
    private List<ChangedValue> computeChangedValues(@Nonnull ProjectRoleActors originalRoleActors, @Nonnull ProjectRoleActors roleActors) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        ListMultimap<String, String> originalActors = this.getCategorisedActors(originalRoleActors);
        List originalUsers = originalActors.get((Object)"atlassian-user-role-actor");
        List originalGroups = originalActors.get((Object)"atlassian-group-role-actor");
        ListMultimap<String, String> newActors = this.getCategorisedActors(roleActors);
        List newUsers = newActors.get((Object)"atlassian-user-role-actor");
        List newGroups = newActors.get((Object)"atlassian-group-role-actor");
        changedValues.addIfDifferent("admin.common.words.users", (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.join((Iterable)originalUsers, (String)", "), null), (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.join((Iterable)newUsers, (String)", "), null));
        changedValues.addIfDifferent("common.words.groups", (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.join((Iterable)originalGroups, (String)", "), null), (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.join((Iterable)newGroups, (String)", "), null));
        return changedValues.build();
    }

    @Nonnull
    private ListMultimap<String, String> getCategorisedActors(ProjectRoleActors originalRoleActors) {
        LinkedListMultimap result = LinkedListMultimap.create((int)2);
        for (RoleActor actor : originalRoleActors.getRoleActors()) {
            result.put((Object)actor.getType(), (Object)actor.getParameter());
        }
        return result;
    }

    @Override
    public void onProjectCategoryUpdateEvent(ProjectCategoryUpdateEvent event) {
        Collection projectsFromProjectCategory = this.projectManager.getProjectsFromProjectCategory(event.getOldProjectCategory());
        if (!projectsFromProjectCategory.isEmpty()) {
            AuditResource mainAffectedObject = AuditEntitiesUtils.newAuditResource(event.getNewProjectCategory().getName(), AssociatedItem.Type.PROJECT_CATEGORY.name(), Long.toString(event.getNewProjectCategory().getId()));
            List affectedObjects = projectsFromProjectCategory.stream().map(this::toAuditResource).collect(Collectors.toList());
            affectedObjects.add(0, mainAffectedObject);
            this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_CATEGORY_UPDATED).affectedObjects(affectedObjects).changedValues(this.buildChangedValuesForCategoryUpdate(event.getOldProjectCategory(), event.getNewProjectCategory())).build());
        }
    }

    private AuditResource toAuditResource(Project project) {
        return AuditEntitiesUtils.newAuditResource(project.getName(), AssociatedItem.Type.PROJECT.name(), Long.toString(project.getId()));
    }

    @Override
    public void onProjectArchivedEvent(ProjectArchivedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_ARCHIVE).affectedObject(AuditEntitiesUtils.newAuditResource(event.getProject().getName(), AssociatedItem.Type.PROJECT.name(), Long.toString(event.getProject().getId()))).build());
    }

    @Override
    public void onProjectRestoredEvent(ProjectRestoredEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_RESTORED).affectedObject(AuditEntitiesUtils.newAuditResource(event.getProject().getName(), AssociatedItem.Type.PROJECT.name(), Long.toString(event.getProject().getId()))).build());
    }

    private List<ChangedValue> buildChangedValues(Project project) {
        return this.buildChangedValues(null, project);
    }

    private List<ChangedValue> buildChangedValues(Project originalProject, Project currentProject) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("common.words.name", originalProject == null ? null : originalProject.getName(), currentProject.getName());
        changedValues.addIfDifferent("common.words.key", originalProject == null ? null : originalProject.getKey(), currentProject.getKey());
        changedValues.addIfDifferent("common.concepts.description", originalProject == null ? null : originalProject.getDescription(), currentProject.getDescription());
        changedValues.addIfDifferent("common.concepts.url", originalProject == null ? null : originalProject.getUrl(), currentProject.getUrl());
        changedValues.addIfDifferent("common.concepts.projectlead", originalProject == null ? null : originalProject.getLeadUserName(), currentProject.getLeadUserName());
        changedValues.addIfDifferent("admin.projects.default.assignee", originalProject == null ? null : this.pre(originalProject.getAssigneeType()), this.pre(currentProject.getAssigneeType()));
        return changedValues.build();
    }

    private List<ChangedValue> buildChangedValuesForCategoryChange(ProjectCategory oldProjectCategory, ProjectCategory newProjectCategory) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        return changedValues.addIfDifferent("common.concepts.category", this.getNameOrNone(oldProjectCategory), this.getNameOrNone(newProjectCategory)).build();
    }

    private List<ChangedValue> buildChangedValuesForCategoryUpdate(ProjectCategory oldProjectCategory, ProjectCategory newProjectCategory) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("common.concepts.name", oldProjectCategory.getName(), newProjectCategory.getName());
        changedValues.addIfDifferent("common.concepts.description", oldProjectCategory.getDescription(), newProjectCategory.getDescription());
        return changedValues.build();
    }

    private String pre(Long assigneeType) {
        return this.getI18n().getText(ProjectAssigneeTypes.getPrettyAssigneeType((Long)assigneeType));
    }

    protected I18nHelper getI18n() {
        return this.i18n.getInstance(Locale.ENGLISH);
    }

    private String getNameOrNone(ProjectCategory category) {
        return category != null ? category.getName() : "None";
    }
}

