/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.throwsafe;

import com.atlassian.jira.component.pico.throwsafe.ThrowSavableBean;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditExceptionHandler
implements ThrowSavableBean {
    private static final Logger log = LoggerFactory.getLogger(AuditExceptionHandler.class);

    @Override
    public void handleException(@NotNull Throwable exception, @NotNull Object target, @NotNull Method method, @NotNull Object[] args) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nAUDIT FAIL!\nAn exception while auditing JIRA operation. An audit log entry may be not saved.\n").append("The following method execution failed\n").append("\nClass: ").append(target.getClass().getSimpleName()).append("\nMethod: ").append(method.getName()).append("\nArguments: ");
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            stringBuilder.append("\n    ").append(parameters[i].getType().getSimpleName()).append(" ").append(parameters[i].getName()).append(" = ").append(args[i]);
        }
        stringBuilder.append("\n\nAudit exception details: ");
        String message = stringBuilder.toString();
        log.error(message, exception);
    }
}

