/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.filter;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.scheduler.cron.CronValidator;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.component.cron.CronEditorBean;
import com.atlassian.jira.web.component.cron.generator.CronExpressionDescriptor;
import com.atlassian.jira.web.component.cron.parser.CronExpressionParser;
import com.atlassian.scheduler.SchedulerService;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;

public class DefaultFilterSubscriptionService
implements FilterSubscriptionService {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SubscriptionManager subscriptionManager;
    private final I18nHelper i18nHelper;
    private final FeatureManager featureManager;
    private final GlobalPermissionManager globalPermissionManager;
    private SchedulerService schedulerService;

    public DefaultFilterSubscriptionService(JiraAuthenticationContext jiraAuthenticationContext, SubscriptionManager subscriptionManager, SchedulerService schedulerService, FeatureManager featureManager, GlobalPermissionManager globalPermissionManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.subscriptionManager = subscriptionManager;
        this.schedulerService = schedulerService;
        this.featureManager = featureManager;
        this.globalPermissionManager = globalPermissionManager;
        this.i18nHelper = jiraAuthenticationContext.getI18nHelper();
    }

    public void validateCronExpression(JiraServiceContext context, String expr) {
        this.validateCron(context, expr);
    }

    private void validateCron(JiraServiceContext context, String expr) {
        Option<String> cronError = new CronValidator(this.i18nHelper, this.schedulerService).validateCron(expr);
        if (cronError.isDefined()) {
            context.getErrorCollection().addErrorMessage((String)cronError.get());
        }
    }

    public void storeSubscription(JiraServiceContext context, Long filterId, String groupName, String expr, boolean emailOnEmpty) {
        this.validateCronExpression(context, expr);
        if (expr != null && !context.getErrorCollection().hasAnyErrors()) {
            this.subscriptionManager.createSubscription(context.getLoggedInApplicationUser(), filterId, groupName, expr, Boolean.valueOf(emailOnEmpty));
        }
    }

    public void updateSubscription(JiraServiceContext context, Long subscriptionId, String groupName, String expr, boolean emailOnEmpty) {
        this.updateSubscription(context, context.getLoggedInApplicationUser(), subscriptionId, groupName, expr, emailOnEmpty);
    }

    public void updateSubscription(JiraServiceContext context, ApplicationUser owner, Long subscriptionId, String groupName, String expr, boolean emailOnEmpty) {
        this.validateCronExpression(context, expr);
        if (expr != null && !context.getErrorCollection().hasAnyErrors()) {
            this.subscriptionManager.updateSubscription(owner, subscriptionId, groupName, expr, Boolean.valueOf(emailOnEmpty));
        }
    }

    public String getPrettySchedule(JiraServiceContext context, String cronExpression) {
        CronExpressionParser cronExpresionParser = new CronExpressionParser(cronExpression);
        if (cronExpresionParser.isValidForEditor()) {
            CronEditorBean cronEditorBean = cronExpresionParser.getCronEditorBean();
            return new CronExpressionDescriptor(this.jiraAuthenticationContext.getI18nHelper()).getPrettySchedule(cronEditorBean);
        }
        return cronExpression;
    }

    public String getCronExpression(JiraServiceContext context, FilterSubscription subscription) {
        return this.subscriptionManager.getCronExpressionForSubscription(subscription);
    }

    public Collection<FilterSubscription> getVisibleFilterSubscriptions(ApplicationUser user, SearchRequest filter) {
        if (filter == null || user == null) {
            return ImmutableList.of();
        }
        try {
            if (user.equals((Object)filter.getOwner())) {
                return this.subscriptionManager.getAllFilterSubscriptions(filter.getId());
            }
            if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS) && this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
                return this.subscriptionManager.getAllFilterSubscriptions(filter.getId());
            }
            return this.subscriptionManager.getFilterSubscriptions(user, filter.getId());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Nullable
    public Date getNextSendTime(@Nonnull FilterSubscription subscription) {
        return this.subscriptionManager.getNextSendTime(subscription);
    }
}

