/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.safeguards.issue.comment;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.core.spi.service.IpAddressProvider;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.safeguards.SafeguardsManager;
import com.atlassian.jira.bc.safeguards.config.RestrictedUsersComponent;
import com.atlassian.jira.bc.safeguards.issue.comment.CommentLimitContext;
import com.atlassian.jira.bc.safeguards.issue.comment.CommentsPerIssueLimitNotifier;
import com.atlassian.jira.bc.safeguards.issue.comment.CommentsPerIssueLimitValidator;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.exception.CommentsPerIssueLimitExceededException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.CommentSearchManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommentsPerIssueLimitValidator
implements CommentsPerIssueLimitValidator {
    @VisibleForTesting
    static final String LIMIT_REACHED_ERROR_MESSAGE_KEY = "jira.safeguards.issue.comments.add.not.allowed";
    private static final long UNDEFINED_COMMENT_LIMIT = -1L;
    private static final String NOT_SPECIFIED_USER = "not specified";
    private static final Logger log = LoggerFactory.getLogger(DefaultCommentsPerIssueLimitValidator.class);
    private final CommentSearchManager commentSearchManager;
    private final FeatureManager featureManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final RestrictedUsersComponent restrictedUsersComponent;
    private final SafeguardsManager safeguardsManager;
    private final CommentsPerIssueLimitNotifier notifier;
    private final ClusterManager clusterManager;
    private final IpAddressProvider ipAddressProvider;

    public DefaultCommentsPerIssueLimitValidator(CommentSearchManager commentSearchManager, FeatureManager featureManager, JiraAuthenticationContext jiraAuthenticationContext, RestrictedUsersComponent restrictedUsersComponent, SafeguardsManager safeguardsManager, CommentsPerIssueLimitNotifier notifier, ClusterManager clusterManager, IpAddressProvider ipAddressProvider) {
        this.commentSearchManager = commentSearchManager;
        this.featureManager = featureManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.restrictedUsersComponent = restrictedUsersComponent;
        this.safeguardsManager = safeguardsManager;
        this.notifier = notifier;
        this.clusterManager = clusterManager;
        this.ipAddressProvider = ipAddressProvider;
    }

    public boolean isValid(@Nonnull Issue issue, @Nullable ApplicationUser author, @Nonnull String commentBody, @Nonnull ErrorCollection errorCollection) {
        boolean valid = this.isValid(issue, author, commentBody, false);
        if (!valid) {
            errorCollection.addError("comment", this.getLimitReachedErrorMessage());
        }
        return valid;
    }

    @Nonnull
    public List<Issue> getInvalidIssues(@Nonnull List<Issue> issues) {
        Optional<Long> optionalLimit = this.getLimitWhenAvailable();
        if (!optionalLimit.isPresent()) {
            return Collections.emptyList();
        }
        long limit = optionalLimit.get();
        ApplicationUser executor = this.jiraAuthenticationContext.getLoggedInUser();
        if (!this.restrictedUsersComponent.isUserRestricted(executor)) {
            return Collections.emptyList();
        }
        ArrayList<Issue> breachedIssues = new ArrayList<Issue>();
        for (Issue issue : issues) {
            long commentsCount = this.commentSearchManager.getCommentsCount(issue);
            if (this.fitsLimit(limit, commentsCount)) continue;
            breachedIssues.add(issue);
        }
        return breachedIssues;
    }

    public void validate(@Nonnull Issue issue, @Nullable ApplicationUser author, @Nonnull String commentBody) throws CommentsPerIssueLimitExceededException {
        if (!this.isValid(issue, author, commentBody, true)) {
            throw new CommentsPerIssueLimitExceededException();
        }
    }

    public long getLimit() {
        return this.getConfiguredLimit();
    }

    private boolean isValid(Issue issue, ApplicationUser author, String commentBody, boolean shouldNotifySoftLimit) {
        Optional<Long> optionalLimit = this.getLimitWhenAvailable();
        if (!optionalLimit.isPresent()) {
            return true;
        }
        long limit = optionalLimit.get();
        ApplicationUser executor = this.jiraAuthenticationContext.getLoggedInUser();
        long commentsCount = this.commentSearchManager.getCommentsCount(issue);
        boolean isValid = this.fitsLimit(limit, commentsCount);
        Boolean isUserRestricted = null;
        if (isValid) {
            log.debug("The comment count ({}) is within the limit ({}), pass the issue comment.", (Object)commentsCount, (Object)limit);
        } else {
            isUserRestricted = this.restrictedUsersComponent.isUserRestricted(executor);
            boolean bl = isValid = isUserRestricted == false;
            if (!isUserRestricted.booleanValue()) {
                log.debug("The user ({}) is not restricted, pass the issue comment.", (Object)(executor == null ? NOT_SPECIFIED_USER : executor.getUsername()));
            }
        }
        if (!isValid || shouldNotifySoftLimit) {
            this.notifySafely(issue, author, commentBody, limit, executor, commentsCount, isValid, isUserRestricted);
        }
        return isValid;
    }

    private void notifySafely(Issue issue, ApplicationUser author, String commentBody, long limit, ApplicationUser executor, long commentsCount, boolean isValid, Boolean isUserRestricted) {
        try {
            CommentLimitContext context = this.buildContext(issue, author, commentBody, limit, executor, isUserRestricted, commentsCount, isValid);
            this.notifier.notify(context);
        }
        catch (Exception ex) {
            log.error("Safeguards comments per issue notifying failure.", (Throwable)ex);
        }
    }

    private CommentLimitContext buildContext(Issue issue, ApplicationUser author, String commentBody, long limit, ApplicationUser executor, Boolean userRestricted, long commentsCount, boolean valid) {
        CommentLimitContext.Builder contextBuilder = CommentLimitContext.builder().setIssueId(issue.getId()).setIssueKey(issue.getKey()).setIpAddress(this.ipAddressProvider.remoteIpAddress()).setCommentBody(commentBody).setCreatedDate(new Date()).setLimit(limit).setCommentsCount(this.calculateTargetCommentCount(commentsCount, valid)).setUserRestricted(userRestricted).setValid(valid).setRestrictedGroups(this.restrictedUsersComponent.getConfiguredRestrictedGroups());
        if (author != null) {
            contextBuilder.setAuthor(author.getUsername());
        }
        if (executor != null) {
            contextBuilder.setExecutor(executor.getUsername());
        }
        return contextBuilder.build();
    }

    private Optional<Long> getLimitWhenAvailable() {
        if (!this.isEnabled()) {
            log.debug("Validator is disabled, pass the issue comment.");
            return Optional.empty();
        }
        long limit = this.getConfiguredLimit();
        if (limit == -1L) {
            log.debug("Validator is enabled but limit is undefined, pass the issue comment.");
            return Optional.empty();
        }
        return Optional.of(limit);
    }

    private boolean isEnabled() {
        return this.clusterManager.isClusterLicensed() && this.featureManager.isEnabled(JiraFeatureFlagRegistrar.SAFEGUARDS);
    }

    private boolean fitsLimit(long limit, long commentsCount) {
        return commentsCount < limit;
    }

    private long getConfiguredLimit() {
        String limitStr = this.safeguardsManager.getLimit("jira.safeguards.issue.comments");
        try {
            return limitStr == null ? -1L : Long.parseLong(limitStr);
        }
        catch (NumberFormatException e) {
            log.warn("Incorrect format of property {}. Should be a positive number. Ignoring the limit.", (Object)"jira.safeguards.issue.comments");
            return -1L;
        }
    }

    private String getLimitReachedErrorMessage() {
        return this.jiraAuthenticationContext.getI18nHelper().getText(LIMIT_REACHED_ERROR_MESSAGE_KEY);
    }

    private long calculateTargetCommentCount(long commentsCount, boolean valid) {
        return commentsCount + (long)(valid ? 1 : 0);
    }
}

