/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directories;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.user.search.IteratedSearcher;
import com.atlassian.jira.bc.user.search.UserMatcherPredicate;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.bc.user.search.UserSearchIssueContext;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.bc.user.search.UserSearchUtilities;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.crowd.embedded.EventuallyConsistentQuery;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.UserCachingComparator;
import com.atlassian.jira.mention.stats.UserSearchServiceStats;
import com.atlassian.jira.permission.IssueUserSearchManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.StopWatch;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserPickerSearchService
implements UserPickerSearchService,
UserSearchService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserPickerSearchService.class);
    private static final String USE_OPTIMISED_USER_LOOKUP = "com.atlassian.jira.use.optimised.user.lookup";
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final GroupManager groupManager;
    private final ProjectManager projectManager;
    private final ProjectRoleManager projectRoleManager;
    private final CrowdService crowdService;
    private final DirectoryManager directoryManager;
    private final ApplicationFactory applicationFactory;
    private final UserKeyStore userKeyStore;
    private final IssueUserSearchManager issueUserSearchManager;
    private final UserSearchServiceStats userSearchServiceStats;
    private static final String VISIBILITY_PUBLIC = "show";
    private static final String VISIBILITY_USER = "user";
    private static final String VISIBILITY_MASKED = "mask";
    private static Function<DirectoryMapping, Directory> DIRECTORY_FROM_MAPPING = new Function<DirectoryMapping, Directory>(){

        public Directory apply(DirectoryMapping from) {
            return from.getDirectory();
        }
    };

    public DefaultUserPickerSearchService(UserManager userManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, GroupManager groupManager, ProjectManager projectManager, ProjectRoleManager projectRoleManager, CrowdService crowdService, DirectoryManager directoryManager, ApplicationFactory applicationFactory, UserKeyStore userKeyStore, IssueUserSearchManager issueUserSearchManager, UserSearchServiceStats userSearchServiceStats) {
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.groupManager = groupManager;
        this.projectManager = projectManager;
        this.projectRoleManager = projectRoleManager;
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
        this.applicationFactory = applicationFactory;
        this.userKeyStore = userKeyStore;
        this.issueUserSearchManager = issueUserSearchManager;
        this.userSearchServiceStats = userSearchServiceStats;
    }

    public List<ApplicationUser> findUsers(JiraServiceContext jiraServiceContext, String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return Collections.emptyList();
        }
        return this.findUsers(jiraServiceContext, query, UserSearchParams.ACTIVE_USERS_IGNORE_EMPTY_QUERY);
    }

    public ApplicationUser getUserByName(JiraServiceContext jiraServiceContext, String query) {
        return this.userManager.getUserByName(query);
    }

    public List<ApplicationUser> findUsersAllowEmptyQuery(JiraServiceContext jiraServiceContext, String query) {
        return this.findUsers(jiraServiceContext, query, UserSearchParams.ACTIVE_USERS_ALLOW_EMPTY_QUERY);
    }

    public List<ApplicationUser> findUsers(JiraServiceContext jiraServiceContext, String query, UserSearchParams userSearchParams) {
        if (userSearchParams.ignorePermissionCheck() || this.canPerformAjaxSearch(jiraServiceContext)) {
            return this.findUsers(query, UserSearchParams.builder((UserSearchParams)userSearchParams).canMatchEmail(this.canShowEmailAddresses(jiraServiceContext)).build());
        }
        return Collections.emptyList();
    }

    public List<ApplicationUser> findUsers(String query, UserSearchParams userSearchParams) {
        return this.findUsers(query, null, userSearchParams);
    }

    @Nonnull
    private <T, C extends Comparable<C>> Iterable<T> attemptFindUsersWithCrowd(String nameQuery, String emailQuery, UserSearchParams userSearchParams, UserQueryResultType<T, C> resultType) throws SearchNotSupportedWithCrowdException {
        TermRestriction activeFilter;
        if (!userSearchParams.includeActive() && !userSearchParams.includeInactive()) {
            return Collections.emptyList();
        }
        if (userSearchParams.getUserFilter() != null && userSearchParams.getUserFilter().isEnabled()) {
            throw new SearchNotSupportedWithCrowdException();
        }
        if (resultType.getCrowdResultType() != User.class && userSearchParams.getPostProcessingFilter() != Predicates.alwaysTrue()) {
            Iterable<ApplicationUser> results = this.attemptFindUsersWithCrowd(nameQuery, emailQuery, userSearchParams, new ApplicationUserResultType());
            return resultType.convertApplicationUserResults(results);
        }
        Predicate postProcFilter = userSearchParams.getPostProcessingFilter();
        Object with = null;
        if (!Strings.isNullOrEmpty((String)nameQuery)) {
            ImmutableList searchFields = userSearchParams.canMatchEmail() ? ImmutableList.of((Object)UserTermKeys.USERNAME, (Object)UserTermKeys.DISPLAY_NAME, (Object)UserTermKeys.EMAIL) : ImmutableList.of((Object)UserTermKeys.USERNAME, (Object)UserTermKeys.DISPLAY_NAME);
            Collection<SearchRestriction> searchRestrictions = UserSearchUtilities.userSearchTermRestrictions(nameQuery, (Iterable<Property<String>>)searchFields);
            with = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, searchRestrictions);
        }
        if (!Strings.isNullOrEmpty((String)emailQuery)) {
            Collection<SearchRestriction> searchRestrictions = UserSearchUtilities.userSearchTermRestrictions(emailQuery, (Iterable<Property<String>>)ImmutableList.of((Object)UserTermKeys.EMAIL));
            BooleanRestrictionImpl emailRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, searchRestrictions);
            with = with != null ? new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{with, emailRestriction}) : emailRestriction;
        }
        if (!userSearchParams.includeInactive()) {
            activeFilter = new TermRestriction(UserTermKeys.ACTIVE, (Object)true);
            with = with != null ? new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{with, activeFilter}) : activeFilter;
        }
        if (!userSearchParams.includeActive()) {
            activeFilter = new TermRestriction(UserTermKeys.ACTIVE, (Object)false);
            with = with != null ? new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{with, activeFilter}) : activeFilter;
        }
        if (with == null) {
            with = NullRestrictionImpl.INSTANCE;
        }
        IteratedSearcher searcher = new IteratedSearcher();
        List results = searcher.iteratedSearch(new CrowdSearchSource(QueryBuilder.queryFor(resultType.getCrowdResultType(), (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)with), userSearchParams.isForcingStrongConsistency()), postProcFilter, this.normalizeRidiculousUserPickerLimits(userSearchParams.getMaxResults()));
        return resultType.convertCrowdResults(results);
    }

    private int normalizeRidiculousUserPickerLimits(Integer resultLimit) {
        if (resultLimit == null || resultLimit == -1) {
            return 1000;
        }
        return resultLimit;
    }

    public List<ApplicationUser> findUsers(String nameQuery, String emailQuery, UserSearchParams userSearchParams) {
        return this.findUsersGeneric(nameQuery, emailQuery, userSearchParams, new ApplicationUserResultType());
    }

    public List<String> findUserNames(String query, UserSearchParams userSearchParams) {
        return this.findUserNames(query, null, userSearchParams);
    }

    public List<String> findUserNames(String nameQuery, String emailQuery, UserSearchParams userSearchParams) {
        return this.findUsersGeneric(nameQuery, emailQuery, userSearchParams, new UserIdResultType());
    }

    public List<ApplicationUser> findTopMentionableUsers(String searchName, UserSearchIssueContext userSearchIssueContext, int topN) {
        if (Boolean.parseBoolean(JiraSystemProperties.getInstance().getProperty(USE_OPTIMISED_USER_LOOKUP, "true"))) {
            try {
                return this.issueUserSearchManager.findTopMentionableUsers(searchName, userSearchIssueContext, topN);
            }
            catch (UnsupportedOperationException e) {
                log.trace("Mention search via legacy mode: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.findTopMentionableUsersInIssueLegacyMode(searchName, userSearchIssueContext, topN);
    }

    private List<ApplicationUser> findTopMentionableUsersInIssueLegacyMode(String searchName, UserSearchIssueContext userSearchIssueContext, int topN) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        UserSearchParams anyActiveUser = UserSearchParams.builder().allowEmptyQuery(true).filter(arg_0 -> this.createIssueWithPermissionPredicate(userSearchIssueContext, ProjectPermissions.BROWSE_PROJECTS).test(arg_0)).maxResults(Integer.valueOf(topN)).build();
        List<ApplicationUser> result = this.findUsers(searchName, anyActiveUser);
        this.userSearchServiceStats.findTopMentionableUsersInIssueLegacyMode(userSearchIssueContext.getIssue().isPresent(), searchName.length(), topN, result.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    public List<ApplicationUser> findTopAssignableUsers(String searchName, UserSearchIssueContext userSearchIssueContext, int topN) {
        if (Boolean.parseBoolean(JiraSystemProperties.getInstance().getProperty(USE_OPTIMISED_USER_LOOKUP, "true"))) {
            try {
                return this.issueUserSearchManager.findTopAssignableUsers(searchName, userSearchIssueContext, topN);
            }
            catch (UnsupportedOperationException e) {
                log.trace("Assignee search via legacy mode: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.findTopAssignableUsersLegacyMode(searchName, userSearchIssueContext, topN);
    }

    private List<ApplicationUser> findTopAssignableUsersLegacyMode(String searchName, UserSearchIssueContext userSearchIssueContext, int topN) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        UserSearchParams searchParams = UserSearchParams.builder().allowEmptyQuery(true).filter(arg_0 -> this.createIssueWithPermissionPredicate(userSearchIssueContext, ProjectPermissions.ASSIGNABLE_USER).test(arg_0)).maxResults(Integer.valueOf(topN)).build();
        List<ApplicationUser> result = this.findUsers(searchName, searchParams);
        this.userSearchServiceStats.findTopAssignableUsersLegacyMode(userSearchIssueContext.getIssue().isPresent(), searchName.length(), topN, result.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    private Predicate<User> createIssueWithPermissionPredicate(UserSearchIssueContext userSearchIssueContext, ProjectPermissionKey permissionKey) {
        if (userSearchIssueContext.getIssue().isPresent()) {
            return user -> this.permissionManager.hasPermission(permissionKey, (Issue)userSearchIssueContext.getIssue().get(), ApplicationUsers.from(user));
        }
        return user -> this.permissionManager.hasPermission(permissionKey, userSearchIssueContext.getProject(), ApplicationUsers.from(user), true);
    }

    /*
     * WARNING - void declaration
     */
    private <T> List<T> findUsersGeneric(String nameQuery, String emailQuery, UserSearchParams userSearchParams, UserQueryResultType<T, ?> resultType) {
        if (DefaultUserPickerSearchService.areQueriesNotAllowed(nameQuery, emailQuery, userSearchParams)) {
            return Collections.emptyList();
        }
        String convertedQuery = DefaultUserPickerSearchService.convertQuery(nameQuery);
        String convertedEmailQuery = DefaultUserPickerSearchService.convertQuery(emailQuery);
        try {
            Iterable<T> usersFromCrowd = this.attemptFindUsersWithCrowd(convertedQuery, convertedEmailQuery, userSearchParams, resultType);
            log.debug("We did a nice efficient crowd query!");
            return ImmutableList.copyOf(usersFromCrowd);
        }
        catch (SearchNotSupportedWithCrowdException e) {
            void var13_17;
            Integer maxResults;
            log.debug("Yuck we are doing a horrible slow all-in-memory query");
            StopWatch stopWatch = new StopWatch();
            if (log.isDebugEnabled()) {
                log.debug("Running user-picker search: '" + convertedQuery + "', emailQuery '" + convertedEmailQuery + "'");
            }
            ArrayList<ApplicationUser> returnUsers = new ArrayList<ApplicationUser>();
            Collection<Object> allUsers = this.getUsersByUserFilter(userSearchParams.getUserFilter(), userSearchParams.getProjectIds());
            if (allUsers == null) {
                allUsers = this.userManager.getAllApplicationUsers();
            }
            if (log.isDebugEnabled()) {
                log.debug("Found all " + allUsers.size() + " users in " + stopWatch.getIntervalTime() + "ms");
            }
            UserMatcherPredicate userMatcher = new UserMatcherPredicate(convertedQuery, convertedEmailQuery, userSearchParams.canMatchEmail());
            for (ApplicationUser applicationUser : allUsers) {
                if (!DefaultUserPickerSearchService.userMatchesQueries(applicationUser, userSearchParams, userMatcher)) continue;
                returnUsers.add(applicationUser);
            }
            if (log.isDebugEnabled()) {
                log.debug("Matched " + returnUsers.size() + " users in " + stopWatch.getIntervalTime() + "ms");
            }
            Collections.sort(returnUsers, new UserCachingComparator(this.authenticationContext.getLocale()));
            if (log.isDebugEnabled()) {
                log.debug("Sorted top " + returnUsers.size() + " users in " + stopWatch.getIntervalTime() + "ms");
                log.debug("ApplicationUser-picker search completed in " + stopWatch.getTotalTime() + "ms");
            }
            if ((maxResults = userSearchParams.getMaxResults()) != null && maxResults >= 0 && maxResults < returnUsers.size()) {
                ArrayList arrayList = new ArrayList(returnUsers.subList(0, maxResults));
            } else {
                ArrayList<ApplicationUser> arrayList = returnUsers;
            }
            return ImmutableList.copyOf(resultType.convertApplicationUserResults((Iterable<ApplicationUser>)var13_17));
        }
    }

    private Set<ApplicationUser> getUsersByUserFilter(UserFilter userFilter, Set<Long> projectIds) {
        if (userFilter == null || !userFilter.isEnabled()) {
            return null;
        }
        Set<ApplicationUser> allUsers = this.getUsersByGroups(userFilter.getGroups(), null);
        allUsers = this.getUsersByRoles(userFilter.getRoleIds(), projectIds, allUsers);
        return allUsers == null ? Sets.newHashSet() : allUsers;
    }

    private Set<ApplicationUser> getUsersByRoles(Set<Long> roleIds, Set<Long> projectIds, Set<ApplicationUser> existingUsers) {
        if (CollectionUtils.isEmpty(projectIds) || CollectionUtils.isEmpty(roleIds)) {
            return existingUsers;
        }
        Set<Object> allUsers = existingUsers == null ? Sets.newHashSet() : existingUsers;
        for (Project project : this.getProjects(projectIds)) {
            for (long roleId : roleIds) {
                ProjectRole projectRole = this.projectRoleManager.getProjectRole(Long.valueOf(roleId));
                if (projectRole == null) continue;
                allUsers.addAll(this.projectRoleManager.getProjectRoleActors(projectRole, project).getUsers());
            }
        }
        return allUsers;
    }

    private Set<ApplicationUser> getUsersByGroups(Set<String> groupNames, Set<ApplicationUser> existingUsers) {
        if (CollectionUtils.isEmpty(groupNames)) {
            return existingUsers;
        }
        Set<Object> allUsers = existingUsers == null ? Sets.newHashSet() : existingUsers;
        for (String groupName : groupNames) {
            allUsers.addAll(this.groupManager.getUsersInGroup(groupName));
        }
        return allUsers;
    }

    public boolean userMatches(ApplicationUser user, UserSearchParams userSearchParams) {
        UserSearchParams allowEmptyQueryParams = userSearchParams.allowEmptyQuery() ? userSearchParams : UserSearchParams.builder((UserSearchParams)userSearchParams).allowEmptyQuery(true).build();
        UserSearchParams noMaxResultsParams = UserSearchParams.builder((UserSearchParams)allowEmptyQueryParams).maxResults(null).sorted(false).build();
        return !this.filterUsers(Collections.singletonList(user), null, null, noMaxResultsParams).isEmpty();
    }

    private boolean userMatchesByUserFilter(ApplicationUser user, UserFilter userFilter, Set<Long> projectIds) {
        return userFilter == null || !userFilter.isEnabled() || this.userMatchesByGroups(user, userFilter.getGroups()) || this.userMatchesByRoles(user, userFilter.getRoleIds(), projectIds);
    }

    private boolean userMatchesByRoles(ApplicationUser user, Set<Long> roleIds, Set<Long> projectIds) {
        if (CollectionUtils.isEmpty(roleIds)) {
            return false;
        }
        for (Project project : this.getProjects(projectIds)) {
            for (long roleId : roleIds) {
                ProjectRole projectRole = this.projectRoleManager.getProjectRole(Long.valueOf(roleId));
                if (projectRole == null || !this.projectRoleManager.isUserInProjectRole(user, projectRole, project)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<Project> getProjects(final Set<Long> projectIds) {
        if (CollectionUtils.isEmpty(projectIds)) {
            return ImmutableList.of();
        }
        if (projectIds.size() == 1) {
            Project project = this.projectManager.getProjectObj(projectIds.iterator().next());
            return project == null ? ImmutableList.of() : ImmutableList.of((Object)project);
        }
        List projects = this.projectManager.getProjectObjects();
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)projects, (Predicate)new Predicate<Project>(){

            public boolean apply(@Nullable Project input) {
                return input != null && projectIds.contains(input.getId());
            }
        }));
    }

    private boolean userMatchesByGroups(ApplicationUser user, Set<String> groupNames) {
        if (CollectionUtils.isEmpty(groupNames)) {
            return false;
        }
        Collection groupsUser = this.groupManager.getGroupNamesForUser(user);
        for (String groupUser : groupsUser) {
            if (!groupNames.contains(groupUser)) continue;
            return true;
        }
        return false;
    }

    private static String convertQuery(String nameQuery) {
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)nameQuery));
    }

    private static boolean areQueriesNotAllowed(String nameQuery, String emailQuery, UserSearchParams userSearchParams) {
        return !userSearchParams.allowEmptyQuery() && StringUtils.isBlank((CharSequence)nameQuery) && (!userSearchParams.canMatchEmail() || StringUtils.isBlank((CharSequence)emailQuery));
    }

    private static boolean userMatchesQueries(ApplicationUser user, UserSearchParams userSearchParams, Predicate<ApplicationUser> userMatcher) {
        return (user.isActive() ? userSearchParams.includeActive() : userSearchParams.includeInactive()) && userMatcher.apply((Object)user) && userSearchParams.getPostProcessingFilter().apply((Object)user.getDirectoryUser());
    }

    public boolean canShowEmailAddresses(JiraServiceContext jiraServiceContext) {
        String emailVisibility;
        return this.canPerformAjaxSearch(jiraServiceContext) && (VISIBILITY_PUBLIC.equals(emailVisibility = this.applicationProperties.getDefaultBackedString("jira.option.emailvisible")) || VISIBILITY_MASKED.equals(emailVisibility) || VISIBILITY_USER.equals(emailVisibility) && jiraServiceContext.getLoggedInApplicationUser() != null);
    }

    public boolean canPerformAjaxSearch(JiraServiceContext jiraServiceContext) {
        ApplicationUser loggedInUser = jiraServiceContext != null ? jiraServiceContext.getLoggedInApplicationUser() : null;
        return this.canPerformAjaxSearch(loggedInUser);
    }

    public boolean canPerformAjaxSearch(ApplicationUser user) {
        return this.permissionManager.hasPermission(27, user);
    }

    private <T extends Comparable<T>> Iterable<T> searchCrowdLimitedResults(EntityQuery<T> query, boolean forceStrongConsistency) {
        Preconditions.checkArgument((query.getMaxResults() >= 0 ? 1 : 0) != 0, (Object)"Only result-limited queries can be searched by this method.");
        ArrayList allResults = new ArrayList();
        int resultsPlusOffset = query.getStartIndex() + query.getMaxResults();
        for (Directory directory : this.getActiveDirectories()) {
            EntityQuery directoryQuery = QueryBuilder.queryFor((Class)query.getReturnType(), (EntityDescriptor)query.getEntityDescriptor(), (SearchRestriction)query.getSearchRestriction(), (int)0, (int)resultsPlusOffset);
            try {
                directoryQuery = forceStrongConsistency ? directoryQuery : new EventuallyConsistentQuery(directoryQuery);
                allResults.addAll(this.directoryManager.searchUsers(directory.getId().longValue(), directoryQuery));
            }
            catch (DirectoryNotFoundException directoryNotFoundException) {
            }
            catch (OperationFailedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        Collections.sort(allResults);
        return this.getPagedResults(query, allResults);
    }

    @VisibleForTesting
    <T extends Comparable<T>> Iterable<T> getPagedResults(EntityQuery<T> query, List<T> allResults) {
        int toIndex;
        int fromIndex = query.getStartIndex();
        if (fromIndex > (toIndex = Math.min(query.getMaxResults() + query.getStartIndex(), allResults.size()))) {
            log.warn("Something weird happened on getting a paged result. Returning empty list because our search fromIndex is " + fromIndex + " but the toIndex is only " + toIndex);
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(allResults.subList(fromIndex, toIndex));
    }

    private Iterable<Directory> getActiveDirectories() {
        return Iterables.filter((Iterable)Iterables.transform((Iterable)this.applicationFactory.getApplication().getDirectoryMappings(), DIRECTORY_FROM_MAPPING), (Predicate)Directories.ACTIVE_FILTER);
    }

    @Nonnull
    public Iterable<String> findUserKeysByFullName(@Nullable String fullName) {
        if (Strings.isNullOrEmpty((String)fullName)) {
            return Collections.emptyList();
        }
        Iterable results = Iterables.transform((Iterable)this.crowdService.search(this.getUserNameFullNameEqualsQuery(fullName)), (Function)new KeyFromUserNameFunction());
        results = Iterables.filter((Iterable)results, (Predicate)Predicates.notNull());
        return results;
    }

    @Nonnull
    public Iterable<String> findUserKeysByEmail(@Nullable String email) {
        if (Strings.isNullOrEmpty((String)email)) {
            return Collections.emptyList();
        }
        Iterable results = Iterables.transform((Iterable)this.crowdService.search(this.getUserNameEmailEqualsQuery(email)), (Function)new KeyFromUserNameFunction());
        results = Iterables.filter((Iterable)results, (Predicate)Predicates.notNull());
        return results;
    }

    @Nonnull
    public Iterable<ApplicationUser> findUsersByFullName(@Nullable String fullName) {
        if (Strings.isNullOrEmpty((String)fullName)) {
            return Collections.emptyList();
        }
        Iterable results = this.crowdService.search(this.getUserFullNameEqualsQuery(fullName));
        return ApplicationUsers.from(results);
    }

    @Nonnull
    public Iterable<ApplicationUser> findUsersByEmail(@Nullable String email) {
        if (Strings.isNullOrEmpty((String)email)) {
            return Collections.emptyList();
        }
        Iterable results = this.crowdService.search(this.getUserEmailEqualsQuery(email));
        return ApplicationUsers.from(results);
    }

    @Nonnull
    public List<ApplicationUser> filterUsers(List<ApplicationUser> applicationUsers, String nameQuery, UserSearchParams userSearchParams) {
        return this.filterUsers(applicationUsers, nameQuery, null, userSearchParams);
    }

    @Nonnull
    public List<ApplicationUser> filterUsers(List<ApplicationUser> applicationUsers, String nameQuery, String emailQuery, UserSearchParams userSearchParams) {
        if (DefaultUserPickerSearchService.areQueriesNotAllowed(nameQuery, emailQuery, userSearchParams)) {
            return Collections.emptyList();
        }
        UserMatcherPredicate userMatcher = new UserMatcherPredicate(DefaultUserPickerSearchService.convertQuery(nameQuery), DefaultUserPickerSearchService.convertQuery(emailQuery), userSearchParams.canMatchEmail());
        Stream<ApplicationUser> applicationUserStream = applicationUsers.stream().filter(Objects::nonNull).filter(applicationUser -> DefaultUserPickerSearchService.userMatchesQueries(applicationUser, userSearchParams, userMatcher)).filter(applicationUser -> this.userMatchesByUserFilter((ApplicationUser)applicationUser, userSearchParams.getUserFilter(), userSearchParams.getProjectIds()));
        if (userSearchParams.isSorted()) {
            applicationUserStream = applicationUserStream.sorted((Comparator<ApplicationUser>)new UserCachingComparator(this.authenticationContext.getLocale())).distinct();
        }
        if (userSearchParams.getMaxResults() != null && userSearchParams.getMaxResults() >= 0) {
            applicationUserStream = applicationUserStream.limit(userSearchParams.getMaxResults().intValue());
        }
        return applicationUserStream.collect(Collectors.toList());
    }

    private EntityQuery<User> getUserFullNameEqualsQuery(String fullName) {
        return QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)new TermRestriction(UserTermKeys.DISPLAY_NAME, (Object)fullName)).returningAtMost(1000);
    }

    private EntityQuery<String> getUserNameFullNameEqualsQuery(String fullName) {
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)new TermRestriction(UserTermKeys.DISPLAY_NAME, (Object)fullName)).returningAtMost(1000);
    }

    private EntityQuery<User> getUserEmailEqualsQuery(String email) {
        return QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)new TermRestriction(UserTermKeys.EMAIL, (Object)email)).returningAtMost(1000);
    }

    private EntityQuery<String> getUserNameEmailEqualsQuery(String email) {
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)new TermRestriction(UserTermKeys.EMAIL, (Object)email)).returningAtMost(1000);
    }

    private static class UserIdResultType
    extends UserQueryResultType<String, String> {
        public UserIdResultType() {
            super(String.class);
        }

        @Override
        public Iterable<String> convertApplicationUserResults(Iterable<ApplicationUser> applicationUserResults) {
            return ImmutableList.copyOf((Iterable)Iterables.transform(applicationUserResults, ApplicationUser::getUsername));
        }

        @Override
        public Iterable<String> convertCrowdResults(Iterable<String> crowdResults) {
            return crowdResults;
        }
    }

    private static class ApplicationUserResultType
    extends UserQueryResultType<ApplicationUser, User> {
        public ApplicationUserResultType() {
            super(User.class);
        }

        @Override
        public Iterable<ApplicationUser> convertApplicationUserResults(Iterable<ApplicationUser> applicationUserResults) {
            return applicationUserResults;
        }

        @Override
        public Iterable<ApplicationUser> convertCrowdResults(Iterable<User> crowdResults) {
            return ApplicationUsers.from(crowdResults);
        }
    }

    private static abstract class UserQueryResultType<T, C extends Comparable<C>> {
        private final Class<C> crowdResultType;

        protected UserQueryResultType(Class<C> crowdResultType) {
            this.crowdResultType = crowdResultType;
        }

        public final Class<C> getCrowdResultType() {
            return this.crowdResultType;
        }

        public abstract Iterable<T> convertCrowdResults(Iterable<C> var1);

        public abstract Iterable<T> convertApplicationUserResults(Iterable<ApplicationUser> var1);
    }

    private static class SearchNotSupportedWithCrowdException
    extends Exception {
        private SearchNotSupportedWithCrowdException() {
        }
    }

    private class KeyFromUserNameFunction
    implements Function<String, String> {
        private KeyFromUserNameFunction() {
        }

        public String apply(@Nullable String userName) {
            if (userName == null) {
                return null;
            }
            return DefaultUserPickerSearchService.this.userKeyStore.getKeyForUsername(userName);
        }
    }

    private class CrowdSearchSource<T extends Comparable<T>>
    implements IteratedSearcher.Source<T> {
        private final QueryBuilder.PartialEntityQueryWithRestriction<T> query;
        private final boolean forceStrongConsistency;

        public CrowdSearchSource(QueryBuilder.PartialEntityQueryWithRestriction<T> query, boolean forceStrongConsistency) {
            this.query = query;
            this.forceStrongConsistency = forceStrongConsistency;
        }

        @Override
        public List<T> search(int offset, int limit) {
            log.debug("Crowd query: offset=" + offset + ", limit=" + limit);
            return ImmutableList.copyOf((Iterable)DefaultUserPickerSearchService.this.searchCrowdLimitedResults(this.query.startingAt(offset).returningAtMost(limit), this.forceStrongConsistency));
        }
    }
}

