/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.bulkedit.operation.BulkOperationException;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import com.atlassian.jira.workflow.WorkflowException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkMigrateOperation
implements ProgressAwareBulkOperation {
    public static final String OPERATION_NAME = "BulkMigrate";
    public static final String NAME_KEY = "bulk.move.operation.name";
    private static final String DESCRIPTION_KEY = "bulk.move.operation.description";
    private static final Logger log = LoggerFactory.getLogger(BulkMigrateOperation.class);
    private final BulkMoveOperation bulkMoveOperation;
    private final SubTaskManager subTaskManager;
    private final IssueManager issueManager;

    public BulkMigrateOperation(BulkMoveOperation bulkMoveOperation, SubTaskManager subTaskManager, IssueManager issueManager) {
        this.bulkMoveOperation = bulkMoveOperation;
        this.subTaskManager = subTaskManager;
        this.issueManager = issueManager;
    }

    public boolean canPerform(BulkEditBean bulkEditBean, ApplicationUser remoteUser) {
        return this.bulkMoveOperation.canPerform(bulkEditBean, remoteUser);
    }

    public void perform(BulkEditBean rootBulkEditBean, ApplicationUser applicationUser, Context taskContext) throws BulkOperationException {
        try {
            MultiBulkMoveBean multiBulkMoveBean = rootBulkEditBean.getRelatedMultiBulkMoveBean();
            for (Object value : multiBulkMoveBean.getBulkEditBeans().values()) {
                BulkEditBean bulkEditBean = (BulkEditBean)value;
                log.debug("Performing move for project " + bulkEditBean.getTargetProject().getName() + " issue type: " + bulkEditBean.getTargetIssueType().getName());
                this.bulkMoveOperation.moveIssuesAndIndex(bulkEditBean, applicationUser, taskContext);
                MultiBulkMoveBean relatedMultiBulkMoveBean = bulkEditBean.getRelatedMultiBulkMoveBean();
                if (relatedMultiBulkMoveBean == null || relatedMultiBulkMoveBean.getBulkEditBeans() == null) continue;
                for (Object o : relatedMultiBulkMoveBean.getBulkEditBeans().values()) {
                    BulkEditBean subTaskBulkEditBean = (BulkEditBean)o;
                    log.info("subTaskBulkEditBean move for project " + subTaskBulkEditBean.getTargetProject().getName() + " issue type: " + subTaskBulkEditBean.getTargetIssueType().getName());
                    this.bulkMoveOperation.moveIssuesAndIndex(subTaskBulkEditBean, applicationUser, taskContext);
                }
            }
        }
        catch (Exception e) {
            throw new BulkOperationException((Throwable)e);
        }
    }

    public Optional<Issue> isConcurrentIssueUpdate(BulkEditBean rootBulkEditBean) {
        MultiBulkMoveBean multiBulkMoveBean = rootBulkEditBean.getRelatedMultiBulkMoveBean();
        for (Object value : multiBulkMoveBean.getBulkEditBeans().values()) {
            BulkEditBean bulkEditBean = (BulkEditBean)value;
            Optional<Issue> updated = this.isConcurrentIssueUpdateSingleBulkEditBean(bulkEditBean);
            if (updated.isPresent()) {
                return updated;
            }
            MultiBulkMoveBean relatedMultiBulkMoveBean = bulkEditBean.getRelatedMultiBulkMoveBean();
            if (relatedMultiBulkMoveBean == null || relatedMultiBulkMoveBean.getBulkEditBeans() == null) continue;
            for (Object o : relatedMultiBulkMoveBean.getBulkEditBeans().values()) {
                BulkEditBean subTaskBulkEditBean = (BulkEditBean)o;
                updated = this.isConcurrentIssueUpdateSingleBulkEditBean(subTaskBulkEditBean);
                if (!updated.isPresent()) continue;
                return updated;
            }
        }
        return Optional.empty();
    }

    public Optional<Issue> isConcurrentIssueUpdateSingleBulkEditBean(BulkEditBean bulkEditBean) {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        for (Object selectedIssue : selectedIssues) {
            MutableIssue newIssue;
            MutableIssue issue = (MutableIssue)selectedIssue;
            if (!this.isConcurrentIssueUpdate(bulkEditBean, issue, newIssue = (MutableIssue)bulkEditBean.getTargetIssueObjects().get(issue))) continue;
            return Optional.of(issue);
        }
        return Optional.empty();
    }

    private boolean isConcurrentIssueUpdate(BulkEditBean bulkEditBean, MutableIssue issue, MutableIssue newIssue) {
        Set actualSubtasksIds;
        Set oldSubtaskIds;
        if (!(issue.isSubTask() || !newIssue.isSubTask() && issue.getProjectId().equals(newIssue.getProjectId()) || (oldSubtaskIds = (Set)bulkEditBean.getSubTaskOfSelectedIssues().stream().filter(st -> st.getParentId().equals(issue.getId())).map(Issue::getId).collect(CollectorsUtil.toImmutableSet())).equals(actualSubtasksIds = (Set)this.subTaskManager.getSubTaskIssueLinks(issue.getId()).stream().map(IssueLink::getDestinationId).collect(CollectorsUtil.toImmutableSet())))) {
            String errorMsg = String.format("Unable to move parent issue '%d [%s]' - subtask have changed from %s to %s", issue.getId(), issue.getKey(), oldSubtaskIds.toString(), actualSubtasksIds);
            log.warn(errorMsg);
            return true;
        }
        if (this.isNewParentIssueChanged(issue, newIssue)) {
            String errorMsg = String.format("Concurrent update of new parent issue '%d [%s]' occured during move of '%d [%s]' issue", newIssue.getParentObject().getId(), newIssue.getParentObject().getKey(), issue.getId(), issue.getKey());
            log.warn(errorMsg);
            return true;
        }
        MutableIssue issueFromDb = this.issueManager.getIssueObject(issue.getId());
        if (this.isIssueChanged((Issue)issue, (Issue)issueFromDb)) {
            String errorMsg = String.format("Concurrent update of issue '%d [%s]' occured during move", issue.getId(), issue.getKey());
            log.warn(errorMsg);
            return true;
        }
        return false;
    }

    private boolean isIssueChanged(Issue issue, Issue issueFromDb) {
        if (issueFromDb == null) {
            return true;
        }
        boolean projectChanged = !Objects.equals(issue.getProjectId(), issueFromDb.getProjectId());
        boolean securityLevelChanged = false;
        if (!issueFromDb.isSubTask()) {
            securityLevelChanged = !Objects.equals(issue.getSecurityLevelId(), issueFromDb.getSecurityLevelId());
        }
        boolean changedIssueType = !issue.getIssueTypeId().equals(issueFromDb.getIssueTypeId());
        boolean parentIssueChanged = !Objects.equals(issue.getParentId(), issueFromDb.getParentId());
        boolean changedWorkflow = !issue.getWorkflowId().equals(issueFromDb.getWorkflowId());
        return securityLevelChanged || projectChanged || parentIssueChanged || changedIssueType || changedWorkflow;
    }

    private boolean isNewParentIssueChanged(MutableIssue issueOld, MutableIssue issueNew) {
        Issue oldParent = issueOld.getParentObject();
        Issue newParent = issueNew.getParentObject();
        if (oldParent == null && newParent == null || oldParent != null && newParent == null) {
            return false;
        }
        if (this.newParentSetOrParentChanged(oldParent, newParent)) {
            MutableIssue newParentFromDb = this.issueManager.getIssueObject(issueNew.getParentObject().getId());
            return this.isIssueChanged(newParent, (Issue)newParentFromDb);
        }
        return false;
    }

    private boolean newParentSetOrParentChanged(Issue oldParent, Issue newParent) {
        return oldParent == null && newParent != null || oldParent != null && newParent != null && !oldParent.getId().equals(newParent.getId());
    }

    public int getNumberOfTasks(BulkEditBean rootBulkEditBean) {
        int count = 0;
        for (Object o1 : rootBulkEditBean.getRelatedMultiBulkMoveBean().getBulkEditBeans().values()) {
            BulkEditBean bulkEditBean = (BulkEditBean)o1;
            count += bulkEditBean.getSelectedIssues().size();
            MultiBulkMoveBean relatedMultiBulkMoveBean = bulkEditBean.getRelatedMultiBulkMoveBean();
            if (relatedMultiBulkMoveBean == null || relatedMultiBulkMoveBean.getBulkEditBeans() == null) continue;
            for (Object o : relatedMultiBulkMoveBean.getBulkEditBeans().values()) {
                BulkEditBean subTaskBulkEditBean = (BulkEditBean)o;
                count += subTaskBulkEditBean.getSelectedIssues().size();
            }
        }
        return count;
    }

    public void chooseContext(BulkEditBean rootBulkEditBean, ApplicationUser applicationUser, I18nHelper i18nHelper, ErrorCollection errors) {
        BulkEditBean bulkEditBean;
        HashSet allIssuesByKey = new HashSet();
        for (Object o : rootBulkEditBean.getRelatedMultiBulkMoveBean().getBulkEditBeans().values()) {
            bulkEditBean = (BulkEditBean)o;
            this.bulkMoveOperation.chooseContext(bulkEditBean, applicationUser, i18nHelper, errors);
            allIssuesByKey.addAll((Collection)bulkEditBean.getSelectedIssues().stream().map(Issue::getKey).collect(CollectorsUtil.toImmutableSet()));
        }
        for (Object o : rootBulkEditBean.getRelatedMultiBulkMoveBean().getBulkEditBeans().values()) {
            bulkEditBean = (BulkEditBean)o;
            Optional.ofNullable(bulkEditBean.getParentIssueKey()).filter(key -> allIssuesByKey.contains(key)).ifPresent(key -> errors.addError(bulkEditBean.getKey() + "parentIssueKey", i18nHelper.getText("convert.issue.to.subtask.error.parentincurrentgroup")));
        }
    }

    public void chooseContextNoValidate(BulkEditBean rootBulkEditBean, ApplicationUser applicationUser) {
        this.bulkMoveOperation.chooseContextNoValidate(rootBulkEditBean.getRelatedMultiBulkMoveBean().getCurrentBulkEditBean(), applicationUser);
    }

    public boolean isStatusValid(BulkEditBean rootBulkEditBean) {
        return this.bulkMoveOperation.isStatusValid(rootBulkEditBean.getRelatedMultiBulkMoveBean().getCurrentBulkEditBean());
    }

    public void setStatusFields(BulkEditBean rootBulkEditBean) throws WorkflowException {
        this.bulkMoveOperation.setStatusFields(rootBulkEditBean.getRelatedMultiBulkMoveBean().getCurrentBulkEditBean());
    }

    public void validatePopulateFields(BulkEditBean rootBulkEditBean, I18nHelper i18nHelper, ErrorCollection errors) {
        this.bulkMoveOperation.validatePopulateFields(rootBulkEditBean.getRelatedMultiBulkMoveBean().getCurrentBulkEditBean(), errors, i18nHelper);
    }

    public String getNameKey() {
        return NAME_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public String getOperationName() {
        return OPERATION_NAME;
    }

    public String getCannotPerformMessageKey() {
        return "bulk.move.cannotperform";
    }

    public BulkMoveOperation getBulkMoveOperation() {
        return this.bulkMoveOperation;
    }
}

