/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.request;

import com.atlassian.jira.config.properties.OptionalProperties;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestCacheConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RequestCacheConfiguration.class);
    private static final String BOUNDED_REQUEST_CACHE_ENABLED_PROPERTY_KEY = "jira.cache.request.bounded.enabled";
    private static final String BOUNDED_REQUEST_CACHE_SIZE_PROPERTY_KEY = "jira.cache.request.bounded.size";
    private static final String LONG_RUNNING_CONTEXT_THRESHOLD_SECONDS_PROPERTY_KEY = "jira.cache.request.bounded.context.longrunning.threshold";
    private static final int BOUNDED_CACHE_SIZE_DEFAULT = 1000;
    private static final int LONG_RUNNING_CONTEXT_THRESHOLD_SECONDS_DEFAULT = 60;
    private final boolean boundedCacheEnabled;
    private final int boundedCacheSize;
    private final int longRunningThresholdSeconds;

    RequestCacheConfiguration(Properties properties) {
        OptionalProperties optionalProperties = new OptionalProperties(properties);
        this.boundedCacheEnabled = optionalProperties.getBoolean(BOUNDED_REQUEST_CACHE_ENABLED_PROPERTY_KEY).orElse(false);
        this.boundedCacheSize = optionalProperties.getInteger(BOUNDED_REQUEST_CACHE_SIZE_PROPERTY_KEY).orElse(1000);
        this.longRunningThresholdSeconds = optionalProperties.getInteger(LONG_RUNNING_CONTEXT_THRESHOLD_SECONDS_PROPERTY_KEY).orElse(60);
        if (this.boundedCacheEnabled) {
            log.info("System property {} is enabled and your requests scope caches are bounded with maxsize={}", (Object)BOUNDED_REQUEST_CACHE_ENABLED_PROPERTY_KEY, (Object)this.boundedCacheSize);
        }
    }

    boolean isBoundedCacheEnabled() {
        return this.boundedCacheEnabled;
    }

    int getBoundedCacheSize() {
        return this.boundedCacheSize;
    }

    int getLongRunningThresholdSeconds() {
        return this.longRunningThresholdSeconds;
    }
}

