/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.cluster.ClusterInfo;
import com.atlassian.jira.cluster.ClusterStateException;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.NodeStatus;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.validation.constraints.NotNull;

public interface ClusterManager
extends ClusterInfo {
    public static final String ALL_NODES = "ALL";
    public static final String ANY_NODE = "ANY";

    @GuardedBy(value="com.atlassian.jira.start.index.lock")
    public void checkIndexOnStart();

    public boolean isActive();

    public Set<Node> getAllNodes();

    public Set<NodeStatus> getAllNodeStatuses();

    public boolean isClusterLicensed();

    public void requestCurrentIndexFromNode(String var1);

    public Collection<Node> findLiveNodes();

    public void refreshLiveNodes();

    public void removeIfOffline(@NotNull String var1) throws ClusterStateException;

    public List<String> removeOfflineNodesIfOlderThan(@NotNull Duration var1);

    public void moveToOffline(@NotNull String var1) throws ClusterStateException;

    public List<String> moveNodesToOfflineIfOlderThan(@NotNull Duration var1);

    public boolean isNodeAlive(@NotNull String var1);

    public boolean isNodePresent(@NotNull String var1);

    public boolean isNodeOffline(@NotNull String var1);

    public boolean isNodeActive(@NotNull String var1);

    public List<Node> findActiveAndNotAliveNodes();

    public List<Node> findOfflineNodes();
}

