/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.event.ClearCacheEvent;
import com.google.common.collect.Maps;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class ClusterNodePropertiesImpl
implements ClusterNodeProperties {
    private static final Logger log = LoggerFactory.getLogger(ClusterNodePropertiesImpl.class);
    public static final String JIRA_CLUSTER_CONFIG_PROPERTIES = "cluster.properties";
    public static final String JIRA_SHARED_HOME = "jira.shared.home";
    public static final String JIRA_NODE_ID = "jira.node.id";
    private final File overlayFile;
    private final JiraHome jiraHome;
    @ClusterSafe
    private final ResettableLazyReference<Map<String, String>> clusterPropertiesRef = new ResettableLazyReference<Map<String, String>>(){

        protected Map<String, String> create() throws Exception {
            return Maps.fromProperties((Properties)this.loadProperties());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties loadProperties() {
            FileInputStream in;
            Properties properties;
            block4: {
                properties = new Properties();
                in = null;
                try {
                    if (!ClusterNodePropertiesImpl.this.overlayFile.exists()) break block4;
                    in = new FileInputStream(ClusterNodePropertiesImpl.this.overlayFile);
                    properties.load(in);
                }
                catch (IOException e) {
                    try {
                        log.warn("Could not load config properties from '" + ClusterNodePropertiesImpl.this.overlayFile + "'.");
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            IOUtils.closeQuietly(in);
            return properties;
        }
    };

    public ClusterNodePropertiesImpl(JiraHome jiraHome) {
        this.jiraHome = jiraHome;
        this.overlayFile = new File(jiraHome.getLocalHomePath(), JIRA_CLUSTER_CONFIG_PROPERTIES);
    }

    @Override
    @Nullable
    public String getProperty(String property) {
        return (String)((Map)this.clusterPropertiesRef.get()).get(property);
    }

    @Override
    public Optional<String> getPropertySafely(String key) {
        return Optional.ofNullable(this.getProperty(key));
    }

    @Override
    public String getSharedHome() {
        return this.getProperty(JIRA_SHARED_HOME);
    }

    @Override
    public String getNodeId() {
        return this.getProperty(JIRA_NODE_ID);
    }

    @Override
    public void refresh() {
        this.clusterPropertiesRef.reset();
    }

    @Override
    public boolean propertyFileExists() {
        return this.overlayFile.exists();
    }

    @Override
    public boolean isValid() {
        return this.propertyFileExists() && this.allRequiredPropertiesExist();
    }

    private boolean allRequiredPropertiesExist() {
        Map properties = (Map)this.clusterPropertiesRef.get();
        return StringUtils.isNotBlank((CharSequence)((CharSequence)properties.get(JIRA_SHARED_HOME))) && StringUtils.isNotBlank((CharSequence)((CharSequence)properties.get(JIRA_NODE_ID)));
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }
}

