/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.LastValueSerializableStats;
import com.atlassian.jira.util.stats.ManagedStats;
import com.google.common.base.Strings;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;

public interface NodeStartIndexStats
extends ManagedStats {
    public static final String STATS_NAME = "NODE-START";

    public void indexOnStartConfiguration(boolean var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public void checkIndexOnStart(boolean var1, long var2);

    public void getIndexByRebuildLocalIndex(boolean var1, long var2);

    public void getIndexByPickIndexSnapshotFromSharedHome(String var1, long var2);

    public void getIndexByRequestIndexSnapshotFromAnotherNode(boolean var1, long var2);

    public void getIndexByPerformFullForegroundReindex(boolean var1, long var2);

    public void ensureFreshIndexSnapshot(boolean var1, boolean var2, long var3);

    public static NodeStartIndexStats create() {
        return new MutableNodeStartIndexStats();
    }

    public static class MutableNodeStartIndexStats
    implements NodeStartIndexStats {
        private final Configuration configuration = new Configuration();
        private CheckIndexOnStart checkIndexOnStart = new CheckIndexOnStart();
        private GetIndexBy getIndexBy = new GetIndexBy();
        private EnsureFreshIndexSnapshot ensureFreshIndexSnapshot = new EnsureFreshIndexSnapshot();

        @Override
        public JiraStats.Interval getMinInterval() {
            return JiraStats.Interval.INTERVAL60MIN;
        }

        @Override
        public String getStatsName() {
            return NodeStartIndexStats.STATS_NAME;
        }

        @Override
        public void indexOnStartConfiguration(boolean isRebuildLocalIndex, boolean isPickSnapshotFromSharedHome, boolean isRequestIndexSnapshotFromAnotherNode, boolean isTriggerFullReindex, boolean isEnsureSnapshotExist) {
            this.configuration.isRebuildLocalIndex.store(isRebuildLocalIndex);
            this.configuration.isPickSnapshotFromSharedHome.store(isPickSnapshotFromSharedHome);
            this.configuration.isRequestIndexSnapshotFromAnotherNode.store(isRequestIndexSnapshotFromAnotherNode);
            this.configuration.isTriggerFullReindex.store(isTriggerFullReindex);
            this.configuration.isEnsureSnapshotExist.store(isEnsureSnapshotExist);
        }

        @Override
        public void checkIndexOnStart(boolean success, long timeInSeconds) {
            this.checkIndexOnStart.resultWithTime(success, timeInSeconds);
            this.checkIndexOnStart.time = Instant.now().toString();
        }

        @Override
        public void getIndexByRebuildLocalIndex(boolean success, long timeInSeconds) {
            this.getIndexBy.rebuildLocalIndex.resultWithTime(success, timeInSeconds);
        }

        @Override
        public void getIndexByPickIndexSnapshotFromSharedHome(String snapshotName, long timeInSeconds) {
            this.getIndexBy.pickIndexSnapshotFromSharedHome.resultWithTime(!Strings.isNullOrEmpty((String)snapshotName), timeInSeconds);
            this.getIndexBy.pickIndexSnapshotFromSharedHome.snapshotName = snapshotName;
        }

        @Override
        public void getIndexByRequestIndexSnapshotFromAnotherNode(boolean success, long timeInSeconds) {
            this.getIndexBy.requestIndexSnapshotFromAnotherNode.resultWithTime(success, timeInSeconds);
        }

        @Override
        public void getIndexByPerformFullForegroundReindex(boolean success, long timeInSeconds) {
            this.getIndexBy.performFullForegroundReindex.resultWithTime(success, timeInSeconds);
        }

        @Override
        public void ensureFreshIndexSnapshot(boolean snapshotExisted, boolean snapshotCreated, long timeInSeconds) {
            this.ensureFreshIndexSnapshot.result = snapshotExisted || snapshotCreated ? Result.SUCCESS : Result.FAILED;
            this.ensureFreshIndexSnapshot.snapshotExisted = snapshotExisted;
            this.ensureFreshIndexSnapshot.snapshotCreated = snapshotCreated;
            this.ensureFreshIndexSnapshot.timeInSeconds.set(timeInSeconds);
        }

        static class EnsureFreshIndexSnapshot {
            private Result result = Result.NOT_RUN;
            private boolean snapshotExisted;
            private boolean snapshotCreated;
            private final AtomicLong timeInSeconds = new AtomicLong();

            EnsureFreshIndexSnapshot() {
            }
        }

        static class ResultWithTime {
            private Result result = Result.NOT_RUN;
            private final AtomicLong timeInSeconds = new AtomicLong();

            ResultWithTime() {
            }

            void resultWithTime(boolean success, long timeInSeconds) {
                this.result = success ? Result.SUCCESS : Result.FAILED;
                this.timeInSeconds.set(timeInSeconds);
            }
        }

        static enum Result {
            NOT_RUN,
            SUCCESS,
            FAILED;

        }

        static class GetIndexBy {
            private final ResultWithTime rebuildLocalIndex = new ResultWithTime();
            private final PickIndexSnapshotFromSharedHome pickIndexSnapshotFromSharedHome = new PickIndexSnapshotFromSharedHome();
            private final ResultWithTime requestIndexSnapshotFromAnotherNode = new ResultWithTime();
            private final ResultWithTime performFullForegroundReindex = new ResultWithTime();

            GetIndexBy() {
            }
        }

        static class PickIndexSnapshotFromSharedHome
        extends ResultWithTime {
            private String snapshotName;

            PickIndexSnapshotFromSharedHome() {
            }
        }

        static class CheckIndexOnStart
        extends ResultWithTime {
            private String time;

            CheckIndexOnStart() {
            }
        }

        static class Configuration {
            private final LastValueSerializableStats<Boolean> isRebuildLocalIndex = new LastValueSerializableStats();
            private final LastValueSerializableStats<Boolean> isPickSnapshotFromSharedHome = new LastValueSerializableStats();
            private final LastValueSerializableStats<Boolean> isRequestIndexSnapshotFromAnotherNode = new LastValueSerializableStats();
            private final LastValueSerializableStats<Boolean> isTriggerFullReindex = new LastValueSerializableStats();
            private final LastValueSerializableStats<Boolean> isEnsureSnapshotExist = new LastValueSerializableStats();

            Configuration() {
            }
        }
    }
}

