/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.rmi.auth;

import com.atlassian.jira.cluster.distribution.localq.rmi.auth.AuthenticatingSocketWrapper;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthServiceFactory;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthenticationResult;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterJoinRequest;
import com.atlassian.jira.cluster.distribution.localq.rmi.auth.SocketClusterJoinRequest;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.lucene.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAuthServerSocket
extends ServerSocket {
    private static final Logger log = LoggerFactory.getLogger(ClusterAuthServerSocket.class);
    private static final String SYSTEM_PROPERTY_AUTH_SO_TIMEOUT_MILLIS = "com.atlassian.jira.cluster.distribution.localq.rmi.server.auth.so.timeout.millis";
    private static final int AUTH_SO_TIMEOUT_MILLIS = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.cluster.distribution.localq.rmi.server.auth.so.timeout.millis", Integer.valueOf(10000));

    public ClusterAuthServerSocket(int port) throws IOException {
        super(port);
    }

    @Override
    public Socket accept() throws IOException {
        return new AuthenticatingSocketWrapper(this.getBackingSocket(), this::authenticate);
    }

    private void authenticate(Socket socket) throws IOException {
        log.debug("[JIRA-RMI-AUTH] [SERVER] Connection accepted from: {}. Starting authentication...", (Object)socket);
        ClusterJoinRequest request = SocketClusterJoinRequest.create(socket, true);
        int beforeSoTimout = socket.getSoTimeout();
        log.debug("[JIRA-RMI-AUTH] [SERVER] Setting socket timeout for authentication to: {} millis", (Object)AUTH_SO_TIMEOUT_MILLIS);
        socket.setSoTimeout(AUTH_SO_TIMEOUT_MILLIS);
        boolean beforeTcpNoDelay = socket.getTcpNoDelay();
        log.debug("[JIRA-RMI-AUTH] [SERVER] Setting socket TCP_NODELAY for authentication to: true");
        socket.setTcpNoDelay(true);
        ClusterAuthenticationResult result = ClusterAuthServiceFactory.getClusterAuthServiceFactory().getClusterAuthServiceInstance().authenticate(request);
        log.debug("[JIRA-RMI-AUTH] [SERVER] Restoring socket timeout back to: {} millis", (Object)beforeSoTimout);
        socket.setSoTimeout(beforeSoTimout);
        log.debug("[JIRA-RMI-AUTH] [SERVER] Restoring socket TCP_NODELAY back to: {}", (Object)beforeTcpNoDelay);
        socket.setTcpNoDelay(beforeTcpNoDelay);
        if (!result.isSuccessful()) {
            if (result.isTimeout()) {
                log.info("[JIRA-RMI-AUTH] [SERVER] Timeout when authenticating client: {}. Timout is set to: {}millis and can be overridden with system property: {}", new Object[]{socket, AUTH_SO_TIMEOUT_MILLIS, SYSTEM_PROPERTY_AUTH_SO_TIMEOUT_MILLIS});
            }
            log.debug("[JIRA-RMI-AUTH] [SERVER] Authentication failed: {}. Closing socket.", (Object)result.getMessage());
            IOUtils.close((Closeable[])new Closeable[]{request.out(), request.in(), socket});
            throw new IOException(result.getMessage(), result.getException());
        }
        log.debug("[JIRA-RMI-AUTH] [SERVER] Authentication OK: {}", (Object)result.getMessage());
    }

    protected Socket getBackingSocket() throws IOException {
        return super.accept();
    }
}

