/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.rmi.auth;

import com.atlassian.jira.cluster.distribution.localq.rmi.auth.ClusterAuthSharedKeySupplier;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.security.properties.SecurityPropertiesService;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterAuthSharedKeySupplier
implements ClusterAuthSharedKeySupplier {
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterAuthSharedKeySupplier.class);
    private static final String RMI_SOCKET_CLUSTER_AUTH_SECRET_KEY = "rmi.socket.cluster.auth.secret.key";
    private static final String SYSTEM_PROPERTY_RMI_AUTH_WARN_MIN = "com.atlassian.jira.cluster.distribution.localq.rmi.auth.warn.min";
    private static final long WARNING_PERIOD_MILLIS = TimeUnit.MINUTES.toMillis(JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.cluster.distribution.localq.rmi.auth.warn.min", Integer.valueOf(15)).intValue());
    private final SecurityPropertiesService securityPropertiesService;
    private volatile long lastWarningTimeMillis = 0L;
    private final AtomicInteger totalWarningCounter = new AtomicInteger(0);

    public DefaultClusterAuthSharedKeySupplier(SecurityPropertiesService securityPropertiesService) {
        this.securityPropertiesService = securityPropertiesService;
    }

    @Override
    public void refresh() {
        this.securityPropertiesService.invalidate(RMI_SOCKET_CLUSTER_AUTH_SECRET_KEY);
    }

    @Override
    public Optional<byte[]> get() {
        Optional<String> secret = this.securityPropertiesService.getSecret(RMI_SOCKET_CLUSTER_AUTH_SECRET_KEY);
        long currentTimeMillis = System.currentTimeMillis();
        if (!secret.isPresent() && this.lastWarningTimeMillis < currentTimeMillis - WARNING_PERIOD_MILLIS) {
            int counter = this.totalWarningCounter.incrementAndGet();
            log.warn("Cluster Authentication disabled due to missing security properties key {}, warning counter: {}. Note the frequency of this warning is controlled by {} system property", new Object[]{RMI_SOCKET_CLUSTER_AUTH_SECRET_KEY, counter, SYSTEM_PROPERTY_RMI_AUTH_WARN_MIN});
            this.lastWarningTimeMillis = currentTimeMillis;
        }
        return secret.map(Base64.getDecoder()::decode);
    }
}

