/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.lock.ClusterNodeHeartbeat;
import com.atlassian.jira.cluster.lock.TimedClusterNodeHeartBeatDao;
import com.atlassian.jira.database.DatabaseSystemTimeReader;
import com.atlassian.jira.database.DatabaseSystemTimeReaderFactory;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityOperator;

public class JiraClusterNodeHeartBeatDao
implements TimedClusterNodeHeartBeatDao {
    private final String localNodeId;
    private final EntityEngine entityEngine;
    private final DatabaseSystemTimeReader dbTimeReader;
    private final ClusterManager clusterManager;

    public JiraClusterNodeHeartBeatDao(ClusterManager clusterManager, EntityEngine entityEngine, DatabaseSystemTimeReaderFactory dbTimeReaderFactory) {
        this.entityEngine = entityEngine;
        this.clusterManager = clusterManager;
        this.dbTimeReader = dbTimeReaderFactory.getReader();
        this.localNodeId = clusterManager.isClustered() ? clusterManager.getNodeId() : "SINGLE_NODE";
    }

    @Override
    @Nonnull
    public String getNodeId() {
        return this.localNodeId;
    }

    @Override
    public void writeHeartBeat(long time) {
        long databaseTime;
        try {
            databaseTime = this.dbTimeReader.getDatabaseSystemTimeMillis();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        int rows = Update.into(Entity.CLUSTER_NODE_HEARTBEAT).set("heartbeatTime", time).set("databaseTime", databaseTime).whereEqual("nodeId", this.localNodeId).execute(this.entityEngine);
        if (rows == 0) {
            this.entityEngine.createValueWithoutId(Entity.CLUSTER_NODE_HEARTBEAT, new ClusterNodeHeartbeat(this.localNodeId, time, databaseTime));
        }
        this.clusterManager.refreshLiveNodes();
    }

    @Override
    @Nullable
    public Long getLastHeartbeatTime(@Nonnull String nodeId) {
        ClusterNodeHeartbeat heartbeat = (ClusterNodeHeartbeat)Select.from(Entity.CLUSTER_NODE_HEARTBEAT).whereEqual("nodeId", nodeId).runWith(this.entityEngine).singleValue();
        if (heartbeat == null) {
            return null;
        }
        return heartbeat.getHeartbeatTime();
    }

    @Override
    @Nonnull
    public Map<String, Long> getActiveNodesDatabaseTimeOffsets(long databaseActiveTime) {
        List results = Select.from(Entity.CLUSTER_NODE_HEARTBEAT).where("databaseTime", EntityOperator.GREATER_THAN, databaseActiveTime).runWith(this.entityEngine).asList();
        LinkedHashMap<String, Long> offsetMap = new LinkedHashMap<String, Long>();
        for (ClusterNodeHeartbeat result : results) {
            Long timeOffset = result.getDatabaseTime() == null ? null : Long.valueOf(result.getHeartbeatTime() - result.getDatabaseTime());
            offsetMap.put(result.getNodeId(), timeOffset);
        }
        return offsetMap;
    }

    @Override
    @Nonnull
    public Collection<String> findNodesWithHeartbeatsAfter(long time) {
        return Select.stringColumn("nodeId").from(Entity.CLUSTER_NODE_HEARTBEAT).where("heartbeatTime", EntityOperator.GREATER_THAN, time).runWith(this.entityEngine).asList();
    }
}

