/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.service;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.cluster.ClusterNodes;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.OfBizClusterNodeStore;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.startup.JiraShutdown;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.johnson.event.Event;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAutoShutdownIfOfflineService {
    private static final Logger log = LoggerFactory.getLogger(NodeAutoShutdownIfOfflineService.class);
    private static Clock clock = Clock.systemUTC();
    static final Duration WARNING_MESSAGE_PERIOD = Duration.ofDays(1L);
    public static final String NODE_SELF_SHUTDOWN_IF_OFFLINE_DISABLED_PROPERTY_KEY = "jira.cluster.node.self.shutdown.if.offline.disabled";
    public final ClusterNodes clusterNodes;
    private final OfBizClusterNodeStore clusterNodeStore;
    private final JohnsonProvider johnsonProvider;
    private final JiraShutdown jiraShutdown;
    private final JiraProperties jiraProperties;
    private volatile Instant nextWarningMessageRun;

    public NodeAutoShutdownIfOfflineService(ClusterNodes clusterNodes, OfBizClusterNodeStore clusterNodeStore, JohnsonProvider johnsonProvider, JiraShutdown jiraShutdown, JiraProperties jiraProperties) {
        this.clusterNodes = clusterNodes;
        this.clusterNodeStore = clusterNodeStore;
        this.johnsonProvider = johnsonProvider;
        this.jiraShutdown = jiraShutdown;
        this.jiraProperties = jiraProperties;
        this.nextWarningMessageRun = Instant.now(clock);
    }

    public void checkCurrentNodeState() {
        Node currentNode = this.clusterNodes.current();
        Node.NodeState nodeState = this.clusterNodeStore.getNode(currentNode.getNodeId()).getState();
        if (nodeState == Node.NodeState.OFFLINE) {
            if (this.isServiceDisabled()) {
                log.error("{} This node {} should be shut down as soon as possible because it is in OFFLINE state. If not, this Jira instance can corrupt cluster state. This must by done manually because this service is disabled by {} property. See [https://confluence.atlassian.com/jirakb/remove-abandoned-or-offline-nodes-in-jira-data-center-946616137.html] for details.", new Object[]{"[CLUSTER-STATE]", currentNode.getNodeId(), NODE_SELF_SHUTDOWN_IF_OFFLINE_DISABLED_PROPERTY_KEY});
                return;
            }
            log.error("{} This node {} was moved to OFFLINE by another node. This node needs to be shut down as soon as possible.", (Object)"[CLUSTER-STATE]", (Object)currentNode.getNodeId());
            try {
                this.sendFatalEvent();
            }
            finally {
                this.jiraShutdown.panic();
            }
        }
        this.ifServiceIsDisabledWarnAboutThatOncePerDay();
    }

    private void ifServiceIsDisabledWarnAboutThatOncePerDay() {
        Instant now = Instant.now(clock);
        if (this.isServiceDisabled() && now.isAfter(this.nextWarningMessageRun)) {
            log.warn("{} This service is disabled by {} system property.", (Object)"[CLUSTER-STATE]", (Object)NODE_SELF_SHUTDOWN_IF_OFFLINE_DISABLED_PROPERTY_KEY);
            this.nextWarningMessageRun = now.plusMillis(WARNING_MESSAGE_PERIOD.toMillis());
        }
    }

    private boolean isServiceDisabled() {
        return this.jiraProperties.getBoolean(NODE_SELF_SHUTDOWN_IF_OFFLINE_DISABLED_PROPERTY_KEY);
    }

    private void sendFatalEvent() {
        String description = "Jira instance was marked as OFFLINE. This node will be shut down soon.";
        Event event = new Event(JohnsonEventType.CLUSTERING.eventType(), "Jira instance was marked as OFFLINE. This node will be shut down soon.", JohnsonEventLevel.FATAL.eventLevel());
        this.johnsonProvider.getContainer().addEvent(event);
    }

    @VisibleForTesting
    static void setClock(Clock clock) {
        NodeAutoShutdownIfOfflineService.clock = clock;
    }
}

