/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.service;

import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.heartbeat.ClusterNodeHeartbeatService;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;

public class NodeTimeHelper {
    private final ClusterNodeHeartbeatService clusterNodeHeartbeatService;

    public NodeTimeHelper(ClusterNodeHeartbeatService clusterNodeHeartbeatService) {
        this.clusterNodeHeartbeatService = clusterNodeHeartbeatService;
    }

    public Duration getTimeOfNodeBeingInCurrentState(Node node, Clock clock) {
        Long lastHeartbeat = this.getNodeLastHeartbeat(node);
        Instant now = Instant.now(clock);
        Instant lastNodeHeartbeat = Instant.ofEpochMilli(lastHeartbeat);
        Duration howLongNodeIsState = Duration.between(lastNodeHeartbeat, now);
        if (howLongNodeIsState.isNegative()) {
            return Duration.ofMillis(0L);
        }
        return howLongNodeIsState;
    }

    public Duration getEstimatedRetentionTime(Node node, Duration retentionPeriod, Clock clock) {
        Instant nodeLiveThreshold;
        Long lastHeartbeat = this.getNodeLastHeartbeat(node);
        Instant now = Instant.now(clock);
        Duration estimatedTime = Duration.between(now, nodeLiveThreshold = Instant.ofEpochMilli(lastHeartbeat).plusMillis(retentionPeriod.toMillis()));
        if (estimatedTime.isNegative()) {
            return Duration.ofMillis(0L);
        }
        return estimatedTime;
    }

    private Long getNodeLastHeartbeat(Node node) {
        Long lastHeartbeat = this.clusterNodeHeartbeatService.getLastHeartbeatTime(node.getNodeId());
        long timestamp = node.getTimestamp();
        if (!this.isNodeHeartbeatValid(node) || node.getState() == Node.NodeState.OFFLINE) {
            lastHeartbeat = timestamp;
        }
        return lastHeartbeat;
    }

    public boolean isNodeHeartbeatValid(Node node) {
        Long heartbeat = this.clusterNodeHeartbeatService.getLastHeartbeatTime(node.getNodeId());
        long timestamp = node.getTimestamp();
        return heartbeat != null && heartbeat > 0L && heartbeat > timestamp;
    }
}

