/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.zdu;

import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.zdu.NodeBuildInfo;
import com.atlassian.jira.cluster.zdu.NodeBuildInfoFactory;
import com.atlassian.jira.model.querydsl.ClusterUpgradeStateDTO;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.inject.Inject;
import org.codehaus.jackson.annotate.JsonProperty;

public class DefaultNodeBuildInfoFactory
implements NodeBuildInfoFactory {
    private final BuildUtilsInfo buildUtilsInfo;

    @Inject
    public DefaultNodeBuildInfoFactory(BuildUtilsInfo buildUtilsInfo) {
        this.buildUtilsInfo = buildUtilsInfo;
    }

    @Override
    public NodeBuildInfo create(ClusterUpgradeStateDTO clusterUpgradeStateDTO) {
        return new DefaultNodeBuildInfo(clusterUpgradeStateDTO.getClusterBuildNumber(), clusterUpgradeStateDTO.getClusterVersion());
    }

    @Override
    public NodeBuildInfo create(Node node) {
        return new DefaultNodeBuildInfo(node.getNodeBuildNumber(), node.getNodeVersion());
    }

    @Override
    public NodeBuildInfo create(long buildNumber, String version) {
        return new DefaultNodeBuildInfo(buildNumber, version);
    }

    @Override
    public NodeBuildInfo currentApplicationInfo() {
        return new DefaultNodeBuildInfo(this.buildUtilsInfo.getApplicationBuildNumber(), this.buildUtilsInfo.getVersion());
    }

    private static class DefaultNodeBuildInfo
    implements NodeBuildInfo {
        private final long buildNumber;
        private final String version;

        private DefaultNodeBuildInfo(long buildNumber, String version) {
            this.buildNumber = buildNumber;
            this.version = version;
        }

        @JsonProperty(value="buildNumber")
        public long getBuildNumber() {
            return this.buildNumber;
        }

        @JsonProperty(value="version")
        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("buildNumber", this.buildNumber).add("version", (Object)this.version).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultNodeBuildInfo build = (DefaultNodeBuildInfo)o;
            return this.buildNumber == build.buildNumber && Objects.equal((Object)this.version, (Object)build.version);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.buildNumber, this.version});
        }
    }
}

