/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.comment;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeys;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import java.util.Map;
import webwork.action.Action;

public class AddCommentContextProvider
implements CacheableContextProvider {
    private final FieldLayoutManager fieldLayoutManager;
    private final FeatureManager featureManager;

    public AddCommentContextProvider(FieldLayoutManager fieldLayoutManager, FeatureManager featureManager) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.featureManager = featureManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        ProjectTypeKey projectTypeKey = issue.getProjectObject() != null ? issue.getProjectObject().getProjectTypeKey() : null;
        Action action = (Action)context.get("action");
        Map paramsBuilder = MapBuilder.newBuilder(context).toMutableMap();
        paramsBuilder.put("commentHtml", this.getCommentHtml(issue, action));
        paramsBuilder.put("shouldAttachAddCommentEventHandler", !ProjectTypeKeys.SERVICE_DESK.equals((Object)projectTypeKey));
        paramsBuilder.put("isStickyCommentEnabled", this.featureManager.isEnabled(JiraFeatureFlagRegistrar.COMMENT_STICKY_FOOTER));
        return paramsBuilder;
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = (ApplicationUser)context.get("user");
        return issue.getId() + "/" + (user == null ? "" : user.getName());
    }

    private String getCommentHtml(Issue issue, Action action) {
        OperationContext context = (OperationContext)action;
        MapBuilder displayParams = MapBuilder.newBuilder();
        displayParams.add((Object)"theme", (Object)"aui");
        displayParams.add((Object)"noHeader", (Object)true);
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue);
        FieldLayoutItem commentFieldLayoutItem = fieldLayout.getFieldLayoutItem("comment");
        OrderableField commentField = commentFieldLayoutItem.getOrderableField();
        return commentField.getCreateHtml(commentFieldLayoutItem, context, action, issue, displayParams.toMap());
    }
}

