/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.Datasource;
import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.checks.database.PostgresSchemaHealthCheck;
import com.atlassian.jira.health.checks.database.PublicSchemaHealthCheck;
import com.atlassian.jira.startup.FaultDescription;
import com.atlassian.jira.util.dbc.Assertions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.ofbiz.core.entity.config.DatasourceInfo;

public class DatabaseConfig {
    public static final String DEFAULT_DATASOURCE_NAME = "defaultDS";
    public static final String DEFAULT_DELEGATOR_NAME = "default";
    private final String datasourceName;
    private final String delegatorName;
    private final String databaseType;
    private final String schemaName;
    private final Datasource datasource;

    public DatabaseConfig(String databaseType, String schemaName, Datasource datasource) {
        this(DEFAULT_DATASOURCE_NAME, DEFAULT_DELEGATOR_NAME, databaseType, schemaName, datasource);
    }

    public DatabaseConfig(String datasourceName, String delegatorName, String databaseType, String schemaName, Datasource datasource) {
        this.datasourceName = Assertions.notBlank((String)"Datasource name", (String)datasourceName);
        this.delegatorName = Assertions.notBlank((String)"Delegator name", (String)delegatorName);
        this.databaseType = Assertions.notBlank((String)"Database type", (String)databaseType);
        this.schemaName = schemaName;
        this.datasource = (Datasource)Assertions.notNull((String)"Datasource", (Object)datasource);
    }

    public FaultDescription testConnection(AtlassianBootstrapManager bootstrapManager) throws BootstrapException {
        List<HealthCheckResult> postgresCheck = new PostgresSchemaHealthCheck(new HealthCheck[0]).performCheck(this.getDatasourceInfo());
        List<HealthCheckResult> schemaCheck = new PublicSchemaHealthCheck(new HealthCheck[0]).performCheck(this.getDatasourceInfo());
        ArrayList<HealthCheckResult> errors = new ArrayList<HealthCheckResult>(postgresCheck);
        errors.addAll(schemaCheck);
        Optional<FaultDescription> failedCheck = errors.stream().findFirst().map(r -> FaultDescription.fromString(r.getEvent().getException()));
        Connection connection = this.datasource.getConnection(bootstrapManager);
        DatabaseUtil.closeQuietly(connection);
        return failedCheck.orElse(null);
    }

    public boolean isDatabaseEmpty(AtlassianBootstrapManager bootstrapManager) throws BootstrapException {
        Connection conn = this.datasource.getConnection(bootstrapManager);
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            String[] types = new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM"};
            String lookupSchemaName = org.ofbiz.core.entity.jdbc.DatabaseUtil.getSchemaPattern((DatabaseMetaData)metaData, (String)this.getDatasourceInfo().getSchemaName());
            ResultSet tableSet = metaData.getTables(conn.getCatalog(), lookupSchemaName, null, types);
            if (tableSet != null && tableSet.next()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new BootstrapException((Throwable)e);
        }
        finally {
            DatabaseUtil.closeQuietly(conn);
        }
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public String getDelegatorName() {
        return this.delegatorName;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public boolean isH2() {
        return this.databaseType.startsWith("h2");
    }

    public boolean isMySql() {
        return this.databaseType.startsWith("mysql");
    }

    public boolean isMySql57() {
        return this.databaseType.startsWith("mysql57");
    }

    public boolean isMySql8() {
        return this.databaseType.startsWith("mysql8");
    }

    public boolean isOracle() {
        return this.databaseType.startsWith("oracle");
    }

    public boolean isPostgres() {
        return this.databaseType.startsWith("postgres");
    }

    public boolean isSqlServer() {
        return this.databaseType.startsWith("mssql");
    }

    public boolean isEmbeddedDatabase() {
        return this.isH2();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Datasource getDatasource() {
        return this.datasource;
    }

    public DatasourceInfo getDatasourceInfo() {
        String fieldType = this.databaseType.equalsIgnoreCase(DatabaseType.MY_SQL57.getTypeName()) ? "mysql" : this.databaseType;
        DatasourceInfo datasourceInfo = this.datasource.getDatasource(this.datasourceName, fieldType, this.schemaName);
        return datasourceInfo;
    }

    public String getDescriptorValue() {
        return this.datasource.getDescriptorValue(this.databaseType);
    }

    public String getDescriptorLabel() {
        return this.datasource.getDescriptorLabel();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

