/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.jira.config.database.jdbcurlparser.AuroraPostgresUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.JdbcUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.MySql57UrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.OracleUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.PostgresUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.SqlServerJtdsDriverUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.SqlServerMicrosoftDriverUrlParser;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public enum DatabaseType {
    H2("H2", "h2", "unknown", (ImmutableList<Driver>)ImmutableList.of((Object)new Driver("org.h2.Driver", false, null))),
    HSQL("HSQL", "hsql", "unknown", (ImmutableList<Driver>)ImmutableList.of((Object)new Driver("org.hsqldb.jdbcDriver", false, null))),
    SQL_SERVER("SQL Server", "mssql", "Database", (ImmutableList<Driver>)ImmutableList.of((Object)new Driver("com.microsoft.sqlserver.jdbc.SQLServerDriver", false, new SqlServerMicrosoftDriverUrlParser()), (Object)new Driver("net.sourceforge.jtds.jdbc.Driver", true, new SqlServerJtdsDriverUrlParser()))),
    MY_SQL57("MySQL 5.7", "mysql57", "Database", (ImmutableList<Driver>)ImmutableList.of((Object)new Driver("com.mysql.jdbc.Driver", false, new MySql57UrlParser()))),
    MY_SQL8("MySQL 8.0", "mysql8", "Database", (ImmutableList<Driver>)ImmutableList.of((Object)new Driver("com.mysql.cj.jdbc.Driver", false, new MySql57UrlParser()))),
    ORACLE("Oracle", "oracle10g", "Service", (ImmutableList<Driver>)ImmutableList.of((Object)new Driver("oracle.jdbc.OracleDriver", false, new OracleUrlParser()))),
    POSTGRES("PostgreSQL", "postgres72", "Database", (ImmutableList<Driver>)ImmutableList.of((Object)new Driver("org.postgresql.Driver", false, new PostgresUrlParser()))),
    AURORA_POSTGRES("Aurora PostgreSQL 9.6 (DC Only)", "postgresaurora96", "Database", (ImmutableList<Driver>)ImmutableList.of((Object)new Driver("org.postgresql.Driver", false, new AuroraPostgresUrlParser()))),
    UNKNOWN("Unknown", "unknown", "unknown", (ImmutableList<Driver>)ImmutableList.of());

    private static final String MYSQL_DRIVER_NAME = "com.mysql.jdbc.Driver";
    private static final String MYSQL_8_DRIVER_NAME = "com.mysql.cj.jdbc.Driver";
    private static final String POSTGRES_DRIVER_NAME = "org.postgresql.Driver";
    private static final String ORACLE_DRIVER_NAME = "oracle.jdbc.OracleDriver";
    private final String name;
    private final String typeName;
    private final ImmutableList<Driver> drivers;
    private final String instanceFieldName;

    private DatabaseType(String name, String typeName, String instanceFieldName, ImmutableList<Driver> drivers) {
        this.name = name;
        this.typeName = typeName;
        this.instanceFieldName = instanceFieldName;
        this.drivers = drivers;
        if (drivers.stream().filter(driver -> !driver.isDeprecated()).collect(Collectors.toSet()).size() > 1) {
            throw new IllegalArgumentException("Multiple non-deprecated drivers defined for " + this.name());
        }
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getJdbcDriverClassName() {
        List driverList = this.drivers.stream().filter(driver -> !driver.isDeprecated()).collect(Collectors.toList());
        if (driverList.isEmpty()) {
            throw new RuntimeException("No Driver class name defined for " + this.name());
        }
        return ((Driver)driverList.get(0)).getClassName();
    }

    public List<String> getDeprecatedJdbcDriverClassNames() {
        return this.drivers.stream().filter(Driver::isDeprecated).map(Driver::getClassName).collect(Collectors.toList());
    }

    public List<Driver> getAllDrivers() {
        return this.drivers;
    }

    public static Collection<DatabaseType> knownTypes() {
        return DatabaseType.allTypes().stream().filter(type -> type != UNKNOWN).collect(Collectors.toList());
    }

    public static Collection<DatabaseType> allTypes() {
        return ImmutableList.copyOf((Object[])DatabaseType.values());
    }

    public static Optional<DatabaseType> forJdbcDriverClassName(String jdbcDriverClass) {
        if (jdbcDriverClass == null) {
            return Optional.of(H2);
        }
        return DatabaseType.knownTypes().stream().filter(databaseType -> databaseType.drivers.stream().anyMatch(driver -> driver.getClassName().equals(jdbcDriverClass))).findFirst();
    }

    public static DatabaseType forDatabaseTypeName(String typeName) {
        return DatabaseType.knownTypes().stream().filter(databaseType -> databaseType.getTypeName().contains(typeName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown database type name " + typeName));
    }

    public JdbcUrlParser getJdbcUrlParser() {
        return this.drivers.stream().filter(driver -> !driver.isDeprecated()).map(Driver::getJdbcUrlParser).findFirst().orElseThrow(() -> new UnsupportedOperationException("Parser implementation not available for " + this.name()));
    }

    public JdbcUrlParser getJdbcUrlParser(String driverClassName) {
        return this.drivers.stream().filter(driver -> driver.getClassName().equals(driverClassName)).map(Driver::getJdbcUrlParser).findFirst().orElseThrow(() -> new UnsupportedOperationException("Parser implementation not available for " + driverClassName));
    }

    public static String noMatchingDriverClassNameErrorMessage(String className) {
        return "Couldn't find a DB type for the class name '" + className + "'";
    }

    public String getInstanceFieldName() {
        return this.instanceFieldName;
    }

    public Boolean isPostgreSQlCompatible() {
        return this.typeName.startsWith("postgres");
    }

    public Boolean isMySQLCompatible() {
        return this.typeName.startsWith("mysql");
    }

    public static class Driver {
        private final String className;
        private final boolean deprecated;
        private final JdbcUrlParser jdbcUrlParser;

        public Driver(String className, boolean deprecated, JdbcUrlParser jdbcUrlParser) {
            this.className = className;
            this.deprecated = deprecated;
            this.jdbcUrlParser = jdbcUrlParser;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public JdbcUrlParser getJdbcUrlParser() {
            return this.jdbcUrlParser;
        }
    }
}

