/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.db.config.password.CipherProvider;
import com.atlassian.jira.config.database.DatabaseConfigHandler;
import com.atlassian.jira.config.database.DatabaseDriverRegisterer;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.Datasource;
import com.atlassian.jira.config.database.ToStringBuilderExcludingPassword;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.util.KeyValuePair;
import com.atlassian.jira.util.KeyValueParser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.JdbcDatasourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcDatasource
implements Datasource {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConfigHandler.class);
    static final String JDBC_DATASOURCE = "jdbc-datasource";
    private static final String URL = "url";
    private static final String DRIVER_CLASS = "driver-class";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String CONNECTION_PROPERTIES = "connection-properties";
    private static final String POOL_SIZE = "pool-size";
    private static final String POOL_MAX_SIZE = "pool-max-size";
    private static final String POOL_MIN_SIZE = "pool-min-size";
    private static final String POOL_MAX_WAIT = "pool-max-wait";
    private static final String POOL_SLEEP_TIME = "pool-sleep-time";
    private static final String POOL_LIFE_TIME = "pool-life-time";
    private static final String DEADLOCK_MAX_WAIT = "deadlock-max-wait";
    private static final String DEADLOCK_RETRY_WAIT = "deadlock-retry-wait";
    private static final String VALIDATION_QUERY = "validation-query";
    private static final String MIN_EVICTABLE_IDLE_TIME_MILLIS = "min-evictable-idle-time-millis";
    private static final String TIME_BETWEEN_EVICTION_RUNS_MILLIS = "time-between-eviction-runs-millis";
    private static final String DEFAULT_CATALOG = "default-catalog";
    private static final String MAX_OPEN_PREPARED_STATEMENTS = "max-open-prepared-statements";
    private static final String POOL_INITIAL_SIZE = "pool-initial-size";
    private static final String POOL_MAX_IDLE = "pool-max-idle";
    private static final String POOL_NUM_TESTS_PER_EVICTION_RUN = "pool-num-tests-per-eviction-run";
    private static final String POOL_PREPARED_STATEMENTS = "pool-prepared-statements";
    private static final String POOL_REMOVE_ABANDONED_ON_BORROW = "pool-remove-abandoned";
    private static final String POOL_REMOVE_ABANDONED_ON_MAINTENANCE = "pool-remove-abandoned-on-maintenance";
    private static final String POOL_REMOVE_ABANDONED_TIMEOUT = "pool-remove-abandoned-timeout";
    private static final String POOL_TEST_ON_BORROW = "pool-test-on-borrow";
    private static final String POOL_TEST_ON_RETURN = "pool-test-on-return";
    private static final String POOL_TEST_WHILE_IDLE = "pool-test-while-idle";
    private static final String VALIDATION_QUERY_TIMEOUT = "validation-query-timeout";
    public static final String TCP_KEEP_ALIVE_PROPERTY = "tcpKeepAlive";
    public static final String SOCKET_TIMEOUT_PROPERTY = "socketTimeout";
    public static final String NULL_DATABASE_MEANS_CURRENT = "nullDatabaseMeansCurrent";
    private static final String NO_DBTYPE_OR_URL_EXCEPTION_MESSAGE = "Must set either the JDBC URL or the database type";
    private final String jdbcUrl;
    private final String driverClassName;
    private final String username;
    private final String password;
    private final Properties connectionProperties;
    private final ConnectionPoolInfo poolInfo;
    private final String cipherProviderClassName;
    private static boolean registerDriverOnConstruct = true;
    private static String SHOULD_IGNORE_SOCKET_TIMEOUT_PROPERTY = "com.atlassian.jira.config.database.remove.socket.timeout.property";
    private static String DEFAULT_SHOULD_IGNORE_SOCKET_TIMEOUT_PROPERTY_VALUE = "true";

    public static void setRegisterDriverOnConstruct(boolean registerDriverOnConstruct) {
        JdbcDatasource.registerDriverOnConstruct = registerDriverOnConstruct;
    }

    public static void registerDriver(String className) {
        DatabaseDriverRegisterer.forDriverClass(className).registerDriver();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public JdbcDatasource(String jdbcUrl, String driverClassName, String username, String password, int poolMaxSize, String validationQuery, Long minEvictableTimeMillis, Long timeBetweenEvictionRunsMillis) {
        this(JdbcDatasource.builder(username, password, poolMaxSize, validationQuery, minEvictableTimeMillis, timeBetweenEvictionRunsMillis).setJdbcUrl(jdbcUrl).setDriverClassName(driverClassName));
    }

    @Deprecated
    public JdbcDatasource(String jdbcUrl, String driverClassName, String username, String password, Properties connectionProperties, int poolMaxSize, String validationQuery, Long minEvictableTimeMillis, Long timeBetweenEvictionRunsMillis) {
        this(JdbcDatasource.builder(username, password, poolMaxSize, validationQuery, minEvictableTimeMillis, timeBetweenEvictionRunsMillis).setJdbcUrl(jdbcUrl).setDriverClassName(driverClassName).setConnectionProperties(connectionProperties));
    }

    @Deprecated
    public JdbcDatasource(DatabaseType databaseType, String hostname, String port, String instance, String username, String password, Integer poolMaxSize, String validationQuery, Long minEvictableTimeMillis, Long timeBetweenEvictionRunsMillis) {
        this(JdbcDatasource.builder(username, password, poolMaxSize, validationQuery, minEvictableTimeMillis, timeBetweenEvictionRunsMillis).setDatabaseType(databaseType).setHostname(hostname).setPort(port).setInstance(instance));
    }

    public JdbcDatasource(JdbcDatasourceInfo jdbc) {
        this(JdbcDatasource.builder().setJdbcUrl(jdbc.getUri()).setDriverClassName(jdbc.getDriverClassName()).setUsername(jdbc.getUsername()).setPassword(jdbc.getPassword()).setConnectionProperties(jdbc.getConnectionProperties()).setConnectionPoolInfo(jdbc.getConnectionPoolInfo()));
    }

    private JdbcDatasource(Builder builder) {
        DatabaseType databaseType = builder.getDatabaseType();
        if (builder.getJdbcUrl() == null) {
            if (databaseType == null) {
                throw new IllegalArgumentException(NO_DBTYPE_OR_URL_EXCEPTION_MESSAGE);
            }
            try {
                this.jdbcUrl = databaseType.getJdbcUrlParser().getUrl(builder.getHostname(), builder.getPort(), builder.getInstance());
                this.driverClassName = databaseType.getJdbcDriverClassName();
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex);
            }
        } else {
            this.jdbcUrl = builder.getJdbcUrl();
            this.driverClassName = builder.getDriverClassName();
        }
        Assertions.notBlank((String)"JDBC URL", (String)this.jdbcUrl);
        Assertions.notBlank((String)"JDBC Driver Class Name", (String)this.driverClassName);
        this.username = Assertions.notBlank((String)USERNAME, (String)builder.getUsername());
        this.password = (String)Assertions.notNull((String)PASSWORD, (Object)builder.getPassword());
        this.cipherProviderClassName = builder.getCipherProviderClassName();
        Properties properties = builder.getConnectionProperties();
        this.connectionProperties = properties != null ? (Properties)properties.clone() : null;
        this.poolInfo = (ConnectionPoolInfo)Assertions.notNull((String)"connectionPoolInfo", (Object)builder.getConnectionPoolInfo());
        Assertions.not((String)"poolInfo.getMaxSize() <= 0", (this.poolInfo.getMaxSize() <= 0 ? 1 : 0) != 0);
        if (registerDriverOnConstruct) {
            this.registerDriver();
        }
    }

    private static Builder builder(String username, String password, Integer poolMaxSize, String validationQuery, Long minEvictableTimeMillis, Long timeBetweenEvictionRunsMillis) {
        ConnectionPoolInfo connectionPoolInfo = ConnectionPoolInfo.builder().setPoolMaxSize(poolMaxSize).setValidationQuery(validationQuery).setMinEvictableTimeMillis(minEvictableTimeMillis).setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis).build();
        return new Builder().setUsername(username).setPassword(password).setConnectionPoolInfo(connectionPoolInfo);
    }

    public Builder toBuilder() {
        return new Builder().setJdbcUrl(this.jdbcUrl).setDriverClassName(this.driverClassName).setUsername(this.username).setPassword(this.password).setConnectionPoolInfo(this.poolInfo);
    }

    private void registerDriver() {
        JdbcDatasource.registerDriver(this.driverClassName);
    }

    @Override
    public Connection getConnection(AtlassianBootstrapManager bootstrapManager) throws BootstrapException {
        return bootstrapManager.getTestDatabaseConnection(this.createDbDetails());
    }

    @Override
    public DatasourceInfo getDatasource(String datasourceName, String fieldType, String schemaName) {
        JdbcDatasourceInfo jdbcInfo = new JdbcDatasourceInfo(this.jdbcUrl, this.driverClassName, this.username, this.password, null, this.connectionProperties, this.poolInfo);
        return new DatasourceInfo(datasourceName, fieldType, schemaName, jdbcInfo);
    }

    @Override
    public String getDescriptorValue(String databaseType) {
        return databaseType + " " + this.jdbcUrl;
    }

    @Override
    public String getDescriptorLabel() {
        return "Database JDBC config";
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties != null ? (Properties)this.connectionProperties.clone() : null;
    }

    public ConnectionPoolInfo getConnectionPoolInfo() {
        return this.poolInfo;
    }

    public String getCipherProviderClassName() {
        return this.cipherProviderClassName;
    }

    @Deprecated
    public int getPoolSize() {
        return this.poolInfo.getMaxSize();
    }

    @Deprecated
    public String getValidationQuery() {
        return this.poolInfo.getValidationQuery();
    }

    @Deprecated
    public Long getMinEvictableTimeMillis() {
        return this.poolInfo.getMinEvictableTimeMillis();
    }

    @Deprecated
    public Long getTimeBetweenEvictionRunsMillis() {
        return this.poolInfo.getTimeBetweenEvictionRunsMillis();
    }

    public String toString() {
        return ToStringBuilderExcludingPassword.toString(this);
    }

    public boolean equals(Object o) {
        return o instanceof JdbcDatasource && this.toBuilder().equals(((JdbcDatasource)o).toBuilder());
    }

    public int hashCode() {
        return this.toBuilder().hashCode();
    }

    DatabaseDetails createDbDetails() {
        DatabaseDetails dbDetails = new DatabaseDetails();
        dbDetails.setDatabaseUrl(this.jdbcUrl);
        dbDetails.setDriverClassName(this.driverClassName);
        dbDetails.setUserName(this.username);
        dbDetails.setPassword(this.password);
        dbDetails.setPoolSize(this.poolInfo.getMaxSize());
        return dbDetails;
    }

    static JdbcDatasource parse(Element datasourceElement, @Nonnull CipherProvider cipherProvider) {
        if (datasourceElement == null || !datasourceElement.getName().equals(JDBC_DATASOURCE)) {
            throw new IllegalArgumentException("Expected jdbc-datasource element");
        }
        Properties connectionProperties = JdbcDatasource.parseConnectionProperties(datasourceElement.elementText(CONNECTION_PROPERTIES));
        Integer poolMaxSize = JdbcDatasource.parseInteger(datasourceElement, POOL_MAX_SIZE);
        if (poolMaxSize == null) {
            poolMaxSize = JdbcDatasource.parseInteger(datasourceElement, POOL_SIZE);
        }
        ConnectionPoolInfo poolInfo = ConnectionPoolInfo.builder().setPoolMaxSize(poolMaxSize).setPoolMinSize(JdbcDatasource.parseInteger(datasourceElement, POOL_MIN_SIZE)).setPoolMaxWait(JdbcDatasource.parseLong(datasourceElement, POOL_MAX_WAIT)).setPoolSleepTime(JdbcDatasource.parseLong(datasourceElement, POOL_SLEEP_TIME)).setPoolLifeTime(JdbcDatasource.parseLong(datasourceElement, POOL_LIFE_TIME)).setDeadLockMaxWait(JdbcDatasource.parseLong(datasourceElement, DEADLOCK_MAX_WAIT)).setDeadLockRetryWait(JdbcDatasource.parseLong(datasourceElement, DEADLOCK_RETRY_WAIT)).setValidationQuery(datasourceElement.elementText(VALIDATION_QUERY)).setMinEvictableTimeMillis(JdbcDatasource.parseLong(datasourceElement, MIN_EVICTABLE_IDLE_TIME_MILLIS)).setTimeBetweenEvictionRunsMillis(JdbcDatasource.parseLong(datasourceElement, TIME_BETWEEN_EVICTION_RUNS_MILLIS)).setDefaultCatalog(datasourceElement.elementText(DEFAULT_CATALOG)).setMaxOpenPreparedStatements(JdbcDatasource.parseInteger(datasourceElement, MAX_OPEN_PREPARED_STATEMENTS)).setNumTestsPerEvictionRun(JdbcDatasource.parseInteger(datasourceElement, POOL_NUM_TESTS_PER_EVICTION_RUN)).setPoolInitialSize(JdbcDatasource.parseInteger(datasourceElement, POOL_INITIAL_SIZE)).setPoolMaxIdle(JdbcDatasource.parseInteger(datasourceElement, POOL_MAX_IDLE)).setPoolPreparedStatements(JdbcDatasource.parseBoolean(datasourceElement, POOL_PREPARED_STATEMENTS)).setRemoveAbandonedOnBorrow(JdbcDatasource.parseBoolean(datasourceElement, POOL_REMOVE_ABANDONED_ON_BORROW)).setRemoveAbandonedOnMaintenance(JdbcDatasource.parseBoolean(datasourceElement, POOL_REMOVE_ABANDONED_ON_MAINTENANCE)).setRemoveAbandonedTimeout(JdbcDatasource.parseInteger(datasourceElement, POOL_REMOVE_ABANDONED_TIMEOUT)).setTestOnBorrow(JdbcDatasource.parseBoolean(datasourceElement, POOL_TEST_ON_BORROW)).setTestOnReturn(JdbcDatasource.parseBoolean(datasourceElement, POOL_TEST_ON_RETURN)).setTestWhileIdle(JdbcDatasource.parseBoolean(datasourceElement, POOL_TEST_WHILE_IDLE)).setValidationQueryTimeout(JdbcDatasource.parseInteger(datasourceElement, VALIDATION_QUERY_TIMEOUT)).build();
        String passwordFromConfig = datasourceElement.elementText(PASSWORD);
        log.info("Trying to get encrypted password from xml and decrypt it");
        String cipherProviderClassName = datasourceElement.elementText("atlassian-password-cipher-provider");
        Optional<String> decryptedPassword = cipherProvider.getInstance(cipherProviderClassName).map(c -> c.decrypt(passwordFromConfig));
        log.info(decryptedPassword.map(notUsed -> "Database password decryption success!").orElse("Database password decryption not performed."));
        return new Builder().setJdbcUrl(datasourceElement.elementText(URL)).setDriverClassName(datasourceElement.elementText(DRIVER_CLASS)).setUsername(datasourceElement.elementText(USERNAME)).setPassword(decryptedPassword.orElse(passwordFromConfig)).setCipherProviderClassName(cipherProviderClassName).setConnectionProperties(connectionProperties).setConnectionPoolInfo(poolInfo).build();
    }

    private static Boolean parseBoolean(Element element, String key) {
        String value = element.elementText(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if ("true".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        log.warn("Invalid value for '" + key + "': '" + value + '\'');
        return null;
    }

    private static Boolean parseBooleanNotNull(Element element, String key) {
        Boolean parsedValue = JdbcDatasource.parseBoolean(element, key);
        return parsedValue != null ? parsedValue : false;
    }

    private static Integer parseInteger(Element element, String key) {
        String value = element.elementText(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nfe) {
            log.warn("Invalid value for '" + key + "': '" + value + '\'');
            return null;
        }
    }

    private static Long parseLong(Element element, String key) {
        String value = element.elementText(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException nfe) {
            log.warn("Invalid value for '" + key + "': '" + value + '\'');
            return null;
        }
    }

    private String serializeConnectionProperties(Properties properties) {
        String serialized = Optional.ofNullable(properties).orElse(new Properties()).entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(";"));
        return StringUtils.stripToNull((String)serialized);
    }

    private static Properties parseConnectionProperties(String value) {
        String[] keyValues;
        if (value == null || value.length() == 0) {
            return null;
        }
        Properties properties = new Properties();
        for (String keyValueText : keyValues = value.split(";")) {
            KeyValuePair<String, String> keyValuePair = KeyValueParser.parse(keyValueText);
            properties.setProperty(keyValuePair.getKey(), keyValuePair.getValue());
        }
        return properties;
    }

    private void writeValue(Element element, String key, String value) {
        element.addElement(key).setText(value);
    }

    private void writeValue(Element element, String key, int value) {
        element.addElement(key).setText(String.valueOf(value));
    }

    private void writeValue(Element element, String key, long value) {
        element.addElement(key).setText(Long.toString(value));
    }

    private void writeOptionalValue(Element element, String key, long value, long defaultValue) {
        if (value != defaultValue) {
            this.writeValue(element, key, value);
        }
    }

    private void writeOptionalValue(Element element, String key, Object value) {
        if (value != null) {
            element.addElement(key).setText(value.toString());
        }
    }

    public void writeTo(Element element, @Nonnull CipherProvider cipherProvider) {
        Element jdbc = element.addElement(JDBC_DATASOURCE);
        this.writeValue(jdbc, URL, this.getJdbcUrl());
        this.writeValue(jdbc, DRIVER_CLASS, this.getDriverClassName());
        this.writeValue(jdbc, USERNAME, this.getUsername());
        String passwordFromConfig = this.getPassword();
        String cipherProviderClassName = Strings.emptyToNull((String)this.getCipherProviderClassName());
        Optional<String> encryptedPassword = cipherProvider.getInstance(cipherProviderClassName).map(c -> c.encrypt(passwordFromConfig));
        this.writeOptionalValue(jdbc, "atlassian-password-cipher-provider", cipherProviderClassName);
        this.writeValue(jdbc, PASSWORD, encryptedPassword.orElse(passwordFromConfig));
        ConnectionPoolInfo poolInfo = this.getConnectionPoolInfo();
        this.writeValue(jdbc, POOL_MIN_SIZE, poolInfo.getMinSize());
        this.writeValue(jdbc, POOL_MAX_SIZE, poolInfo.getMaxSize());
        this.writeOptionalValue(jdbc, POOL_MAX_WAIT, poolInfo.getMaxWait(), 60000L);
        this.writeOptionalValue(jdbc, POOL_SLEEP_TIME, poolInfo.getSleepTime(), 300000L);
        this.writeOptionalValue(jdbc, POOL_LIFE_TIME, poolInfo.getLifeTime(), 600000L);
        this.writeOptionalValue(jdbc, DEADLOCK_MAX_WAIT, poolInfo.getDeadLockMaxWait(), 600000L);
        this.writeOptionalValue(jdbc, DEADLOCK_RETRY_WAIT, poolInfo.getDeadLockRetryWait(), 10000L);
        this.writeOptionalValue(jdbc, VALIDATION_QUERY, poolInfo.getValidationQuery());
        this.writeOptionalValue(jdbc, MIN_EVICTABLE_IDLE_TIME_MILLIS, poolInfo.getMinEvictableTimeMillis());
        this.writeOptionalValue(jdbc, TIME_BETWEEN_EVICTION_RUNS_MILLIS, poolInfo.getTimeBetweenEvictionRunsMillis());
        this.writeOptionalValue(jdbc, DEFAULT_CATALOG, poolInfo.getDefaultCatalog());
        this.writeOptionalValue(jdbc, MAX_OPEN_PREPARED_STATEMENTS, poolInfo.getMaxOpenPreparedStatements());
        this.writeOptionalValue(jdbc, POOL_NUM_TESTS_PER_EVICTION_RUN, poolInfo.getNumTestsPerEvictionRun());
        this.writeOptionalValue(jdbc, POOL_INITIAL_SIZE, poolInfo.getInitialSize());
        this.writeOptionalValue(jdbc, POOL_MAX_IDLE, poolInfo.getMaxIdle());
        this.writeOptionalValue(jdbc, POOL_PREPARED_STATEMENTS, poolInfo.getPoolPreparedStatements());
        this.writeOptionalValue(jdbc, POOL_REMOVE_ABANDONED_ON_BORROW, poolInfo.getRemoveAbandonedOnBorrow());
        this.writeOptionalValue(jdbc, POOL_REMOVE_ABANDONED_ON_MAINTENANCE, poolInfo.getRemoveAbandonedOnMaintanance());
        this.writeOptionalValue(jdbc, POOL_REMOVE_ABANDONED_TIMEOUT, poolInfo.getRemoveAbandonedTimeout());
        this.writeOptionalValue(jdbc, POOL_TEST_ON_BORROW, poolInfo.getTestOnBorrow());
        this.writeOptionalValue(jdbc, POOL_TEST_ON_RETURN, poolInfo.getTestOnReturn());
        this.writeOptionalValue(jdbc, POOL_TEST_WHILE_IDLE, poolInfo.getTestWhileIdle());
        this.writeOptionalValue(jdbc, VALIDATION_QUERY_TIMEOUT, poolInfo.getValidationQueryTimeout());
        this.writeOptionalValue(jdbc, CONNECTION_PROPERTIES, this.serializeConnectionProperties(this.connectionProperties));
    }

    public static class Builder {
        private DatabaseType databaseType;
        private String hostname;
        private String port;
        private String instance;
        private String jdbcUrl;
        private String driverClassName;
        private String username;
        private String password;
        private Properties connectionProperties;
        private ConnectionPoolInfo connectionPoolInfo;
        private String cipherProviderClassName;

        public JdbcDatasource build() {
            this.applyDefaultSettings();
            return new JdbcDatasource(this);
        }

        public DatabaseType getDatabaseType() {
            return this.databaseType;
        }

        public Builder setDatabaseType(DatabaseType databaseType) {
            this.databaseType = databaseType;
            return this;
        }

        public String getHostname() {
            return this.hostname;
        }

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public String getPort() {
            return this.port;
        }

        public Builder setPort(String port) {
            this.port = port;
            return this;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }

        public Builder setJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public Builder setDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
            return this;
        }

        public String getUsername() {
            return this.username;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Properties getConnectionProperties() {
            return this.connectionProperties;
        }

        public Builder setConnectionProperties(Properties connectionProperties) {
            this.connectionProperties = connectionProperties;
            return this;
        }

        public ConnectionPoolInfo getConnectionPoolInfo() {
            return this.connectionPoolInfo;
        }

        public Builder setConnectionPoolInfo(ConnectionPoolInfo connectionPoolInfo) {
            this.connectionPoolInfo = connectionPoolInfo;
            return this;
        }

        public String getCipherProviderClassName() {
            return this.cipherProviderClassName;
        }

        public Builder setCipherProviderClassName(String cipherProviderClassName) {
            this.cipherProviderClassName = cipherProviderClassName;
            return this;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            return Objects.equals((Object)this.databaseType, (Object)other.databaseType) && Objects.equals(this.hostname, other.hostname) && Objects.equals(this.port, other.port) && Objects.equals(this.instance, other.instance) && Objects.equals(this.jdbcUrl, other.jdbcUrl) && Objects.equals(this.driverClassName, other.driverClassName) && Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals(this.connectionProperties, other.connectionProperties) && Objects.equals(this.connectionPoolInfo, other.connectionPoolInfo) && Objects.equals(this.cipherProviderClassName, other.cipherProviderClassName);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.databaseType, this.hostname, this.port, this.instance, this.jdbcUrl, this.driverClassName, this.username, this.password, this.connectionProperties, this.connectionPoolInfo, this.cipherProviderClassName});
        }

        public String toString() {
            return ToStringBuilderExcludingPassword.reflectionToString((Object)this);
        }

        public void applyDefaultSettings() {
            Properties properties;
            if (this.isPostgreSQlCompatible()) {
                properties = Optional.ofNullable(this.getConnectionProperties()).orElse(new Properties());
                if (!properties.containsKey(JdbcDatasource.TCP_KEEP_ALIVE_PROPERTY)) {
                    properties.setProperty(JdbcDatasource.TCP_KEEP_ALIVE_PROPERTY, "true");
                    log.warn("Recommended connection property \"{}\" is not present in config file. Setting to \"true\".", (Object)JdbcDatasource.TCP_KEEP_ALIVE_PROPERTY);
                }
                if (Builder.shouldIgnoreSocketTimeoutProperty() && properties.containsKey(JdbcDatasource.SOCKET_TIMEOUT_PROPERTY)) {
                    properties.remove(JdbcDatasource.SOCKET_TIMEOUT_PROPERTY);
                    log.warn("Connection property \"{}\" is ignored by Jira.", (Object)JdbcDatasource.SOCKET_TIMEOUT_PROPERTY);
                }
                this.setConnectionProperties(properties);
            }
            if (this.databaseType != null && this.databaseType.isMySQLCompatible().booleanValue()) {
                properties = Optional.ofNullable(this.getConnectionProperties()).orElse(new Properties());
                properties.setProperty(JdbcDatasource.NULL_DATABASE_MEANS_CURRENT, "true");
                this.setConnectionProperties(properties);
            }
        }

        private static boolean shouldIgnoreSocketTimeoutProperty() {
            return Boolean.parseBoolean(JiraSystemProperties.getInstance().getProperty(SHOULD_IGNORE_SOCKET_TIMEOUT_PROPERTY, DEFAULT_SHOULD_IGNORE_SOCKET_TIMEOUT_PROPERTY_VALUE));
        }

        private boolean isPostgreSQlCompatible() {
            Preconditions.checkArgument((this.databaseType != null || this.jdbcUrl != null ? 1 : 0) != 0, (Object)JdbcDatasource.NO_DBTYPE_OR_URL_EXCEPTION_MESSAGE);
            if (this.databaseType != null) {
                return this.databaseType.isPostgreSQlCompatible();
            }
            String expectedName = DatabaseType.POSTGRES.getDisplayName().toLowerCase(Locale.ROOT);
            return this.getJdbcUrl().trim().toLowerCase(Locale.ROOT).contains(expectedName);
        }
    }
}

