/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import java.util.Optional;
import java.util.Properties;

public class OptionalProperties {
    private final Properties properties;

    public OptionalProperties(Properties properties) {
        this.properties = properties;
    }

    public Optional<Boolean> getBoolean(String propertyKey) {
        String value = this.properties.getProperty(propertyKey);
        if (value != null) {
            if (value.equals("true")) {
                return Optional.of(true);
            }
            if (value.equals("false")) {
                return Optional.of(false);
            }
        }
        return Optional.empty();
    }

    public Optional<Integer> getInteger(String propertyKey) {
        try {
            return Optional.of(Integer.decode(this.properties.getProperty(propertyKey)));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Optional.empty();
        }
    }
}

