/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.IndexPathService;
import com.atlassian.jira.security.PermissionManager;

public class DefaultIndexPathService
implements IndexPathService {
    private final IndexPathManager indexPathManager;
    private final PermissionManager permissionManager;

    public DefaultIndexPathService(IndexPathManager indexPathManager, PermissionManager permissionManager) {
        this.indexPathManager = indexPathManager;
        this.permissionManager = permissionManager;
    }

    public String getIndexRootPath(JiraServiceContext serviceContext) {
        if (this.permissionManager.hasPermission(44, serviceContext.getLoggedInApplicationUser())) {
            return this.indexPathManager.getIndexRootPath();
        }
        serviceContext.getErrorCollection().addErrorMessage(serviceContext.getI18nBean().getText("admin.errors.indexpath.no.permission"));
        return null;
    }

    public String getIssueIndexPath(JiraServiceContext serviceContext) {
        if (this.permissionManager.hasPermission(44, serviceContext.getLoggedInApplicationUser())) {
            return this.indexPathManager.getIssueIndexPath();
        }
        serviceContext.getErrorCollection().addErrorMessage(serviceContext.getI18nBean().getText("admin.errors.indexpath.no.permission"));
        return null;
    }

    public String getCommentIndexPath(JiraServiceContext serviceContext) {
        if (this.permissionManager.hasPermission(44, serviceContext.getLoggedInApplicationUser())) {
            return this.indexPathManager.getCommentIndexPath();
        }
        serviceContext.getErrorCollection().addErrorMessage(serviceContext.getI18nBean().getText("admin.errors.indexpath.no.permission"));
        return null;
    }

    public String getPluginIndexRootPath(JiraServiceContext serviceContext) {
        if (this.permissionManager.hasPermission(44, serviceContext.getLoggedInApplicationUser())) {
            return this.indexPathManager.getPluginIndexRootPath();
        }
        serviceContext.getErrorCollection().addErrorMessage(serviceContext.getI18nBean().getText("admin.errors.indexpath.no.permission"));
        return null;
    }

    public String getSharedEntityIndexPath(JiraServiceContext serviceContext) {
        if (this.permissionManager.hasPermission(44, serviceContext.getLoggedInApplicationUser())) {
            return this.indexPathManager.getSharedEntityIndexPath();
        }
        serviceContext.getErrorCollection().addErrorMessage(serviceContext.getI18nBean().getText("admin.errors.indexpath.no.permission"));
        return null;
    }
}

