/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded;

import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.FileStores;
import java.util.Locale;
import java.util.Optional;

public class JiraEncryptionSettings
implements EncryptionSettings {
    public static final String CROWD_ENCRYPTION_ENCRYPTOR_DEFAULT = "crowd.encryption.encryptor.default";
    public static final String CROWD_ENCRYPTION_ENCRYPTOR_KEY_PATH = "crowd.encryption.encryptor.%s.keyPath";
    public static final String CROWD_ENCRYPTION_DISABLED_KEY = "DISABLED";
    private final FileStores fileStores;
    private final ApplicationProperties applicationProperties;

    public JiraEncryptionSettings(FileStores fileStores, ApplicationProperties applicationProperties) {
        this.fileStores = fileStores;
        this.applicationProperties = applicationProperties;
    }

    private Optional<String> optional(String nullOrEmpty) {
        if (nullOrEmpty != null && !nullOrEmpty.trim().isEmpty()) {
            return Optional.of(nullOrEmpty);
        }
        return Optional.empty();
    }

    public Optional<String> getDefaultEncryptor() {
        String value = this.applicationProperties.getString(CROWD_ENCRYPTION_ENCRYPTOR_DEFAULT);
        if (value != null && value.toUpperCase(Locale.ENGLISH).equals(CROWD_ENCRYPTION_DISABLED_KEY)) {
            value = null;
        }
        return this.optional(value);
    }

    public void setDefaultEncryptor(String name) {
        if (name == null) {
            name = CROWD_ENCRYPTION_DISABLED_KEY;
        }
        this.applicationProperties.setString(CROWD_ENCRYPTION_ENCRYPTOR_DEFAULT, name);
    }

    private String keyPathPropertyNameFor(String encryptor) {
        return String.format(CROWD_ENCRYPTION_ENCRYPTOR_KEY_PATH, encryptor);
    }

    public void setEncryptionKeyPath(String encryptor, String keyPath) {
        this.applicationProperties.setString(this.keyPathPropertyNameFor(encryptor), keyPath);
    }

    public Optional<String> getEncryptionKeyPath(String encryptor) {
        return this.optional(this.applicationProperties.getString(this.keyPathPropertyNameFor(encryptor)));
    }

    public String getKeyFilesDirectoryPath() {
        return this.fileStores.getHomeFilesystemPath().path(new String[]{"keys"}).asJavaPath().toString();
    }
}

