/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.jira.bc.user.search.UserSearchUtilities;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.crowd.embedded.JiraCrowdDAO;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.database.QueryDslAccessorHandlingCollationProblems;
import com.atlassian.jira.model.querydsl.QDirectory;
import com.atlassian.jira.model.querydsl.QGroup;
import com.atlassian.jira.model.querydsl.QMembership;
import com.atlassian.jira.model.querydsl.QUser;
import com.atlassian.jira.model.querydsl.UserDTO;
import com.atlassian.jira.permission.UserSearchConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDslJiraCrowdDAO
implements JiraCrowdDAO {
    private static final Logger log = LoggerFactory.getLogger(QueryDslJiraCrowdDAO.class);
    public static final int MAX_TOP = UserSearchConfiguration.getMaxTopReturnedUsersValue();
    public static final int GROUP_BATCH_SIZE = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.crowd.embedded.JiraCrowdDAO.groups.batchSize", Integer.valueOf(1000));
    public static final int NUMBER_OF_GROUP_BATCHES = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.crowd.embedded.JiraCrowdDAO.groups.numberOfBatches", Integer.valueOf(1));
    public static final int MAX_GROUP_NESTED_LEVEL = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.crowd.embedded.JiraCrowdDAO.maxGroupNestedLevel", Integer.valueOf(20));
    public static final int BIG_NUMBER_OF_GROUPS = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.crowd.embedded.JiraCrowdDAO.bigNumberOfGroups", Integer.valueOf(20));
    public static final int TOP_USERS_CACHE_MAX_SIZE = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.crowd.embedded.JiraCrowdDAO.topUsersCache.max.size", Integer.valueOf(100));
    public static final int TOP_USERS_CACHE_EXPIRATION_SECONDS = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.crowd.embedded.JiraCrowdDAO.topUsersCache.expiration.seconds", Integer.valueOf(60));
    private static final String LEARN_MORE_ABOUT_LIMITS_KB = "https://confluence.atlassian.com/x/QBrSQ";
    private final QueryDslAccessor queryDslAccessor;
    private final LoadingCache<UserQueryCacheKey, List<UserDTO>> findTopUsersMatchingNameInGroupsInternalCache = CacheBuilder.newBuilder().maximumSize((long)TOP_USERS_CACHE_MAX_SIZE).expireAfterWrite((long)TOP_USERS_CACHE_EXPIRATION_SECONDS, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<UserQueryCacheKey, List<UserDTO>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<UserDTO> load(UserQueryCacheKey key) throws Exception {
            log.trace("Loading to findTopUsersMatchingNameInGroupsInternalCache key: {} ...", (Object)key);
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                List list = QueryDslJiraCrowdDAO.this.findTopUsersMatchingNameInGroupsInternal(key.search, key.groups, key.topN);
                return list;
            }
            finally {
                stopwatch.stop();
                log.trace("Done loading to findTopUsersMatchingNameInGroupsInternalCache key: {} in: {}millis", (Object)key, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            }
        }
    });

    public QueryDslJiraCrowdDAO(QueryDslAccessor queryDslAccessor, DatabaseAccessor databaseAccessor) {
        this.queryDslAccessor = new QueryDslAccessorHandlingCollationProblems(queryDslAccessor, databaseAccessor.getDatabaseVendor(), "https://confluence.atlassian.com/jirakb/mentionable-assignable-users-database-collation-issues-1085194493.html");
    }

    @Override
    public List<UserDTO> findTopUsersWithNameInGroups(String searchName, Set<Group> groups, int topN) {
        List groupsBatches = Lists.partition(new ArrayList<Group>(groups), (int)GROUP_BATCH_SIZE);
        if (groupsBatches.size() > NUMBER_OF_GROUP_BATCHES) {
            log.warn("JiraCrowdDAO#findTopUsersWithNameInGroups: the results of the search might be incomplete due to too many groups. Number of groups: {}, batch size: {}, number of batches: {}. Allowed number of batches: {}.Learn more: {}", new Object[]{groups.size(), GROUP_BATCH_SIZE, groupsBatches.size(), NUMBER_OF_GROUP_BATCHES, LEARN_MORE_ABOUT_LIMITS_KB});
            groupsBatches = groupsBatches.stream().limit(NUMBER_OF_GROUP_BATCHES).collect(Collectors.toList());
        }
        topN = QueryDslJiraCrowdDAO.reasonableMax(topN);
        TreeSet<UserDTO> orderedSetOfUsers = new TreeSet<UserDTO>(UserSearchUtilities.USER_DTO_COMPARATOR);
        Stopwatch stopwatch = Stopwatch.createStarted();
        int dbResultSize = 0;
        for (List groupBatch : groupsBatches) {
            List dbResult = (List)this.findTopUsersMatchingNameInGroupsInternalCache.getUnchecked((Object)UserQueryCacheKey.create(searchName, groupBatch, topN));
            dbResultSize += dbResult.size();
            orderedSetOfUsers.addAll(dbResult);
        }
        log.trace("JiraCrowdDAO#findTopUsersWithNameInGroups: input.searchName:{}, input.groups.size:{}, input.topN:{}, dbResult.size {}, result.size:{}, timeInMillis:{}", new Object[]{searchName, groups.size(), topN, dbResultSize, orderedSetOfUsers.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return orderedSetOfUsers.stream().limit(topN).collect(Collectors.toList());
    }

    @Override
    public List<UserDTO> findTopUsers(String searchName, int topN) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        List result = (List)this.findTopUsersMatchingNameInGroupsInternalCache.getUnchecked((Object)UserQueryCacheKey.create(searchName, Collections.emptyList(), topN));
        log.trace("JiraCrowdDAO#findTopUsers: input.searchName:{}, input.topN:{}, result.size:{}, timeInMillis:{}", new Object[]{searchName, topN, result.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return result;
    }

    @Override
    public Set<Group> findNestedGroupsOf(Set<Group> groups) {
        if (groups.isEmpty()) {
            return ImmutableSet.of();
        }
        Set newParents = groups.stream().map(Group::getName).collect(Collectors.toSet());
        HashSet allNestedGroup = new HashSet(newParents);
        Stopwatch stopwatch = Stopwatch.createStarted();
        int numberOfSQLQueries = 0;
        int nestedLevel = 0;
        block0: do {
            ++nestedLevel;
            List newParentsBatched = Lists.partition(new ArrayList(newParents), (int)GROUP_BATCH_SIZE);
            int currentParentsSize = newParents.size();
            newParents = new HashSet();
            for (int i = 0; i < newParentsBatched.size(); ++i) {
                if (i + 1 > NUMBER_OF_GROUP_BATCHES) {
                    log.warn("JiraCrowdDAO#findNestedGroupsOf: the results of the search might be incomplete due to too many groups at nested level: {}. Number of groups found at this level: {} and this is above the limit: {}. Will continue searching for children in the limited set of groups only. Learn more: {}", new Object[]{numberOfSQLQueries, currentParentsSize, NUMBER_OF_GROUP_BATCHES * GROUP_BATCH_SIZE, LEARN_MORE_ABOUT_LIMITS_KB});
                    continue block0;
                }
                ++numberOfSQLQueries;
                newParents.addAll(this.findDirectChildrenOf((List)newParentsBatched.get(i)));
            }
        } while (allNestedGroup.addAll(newParents) && nestedLevel < MAX_GROUP_NESTED_LEVEL && !Thread.currentThread().isInterrupted());
        if (nestedLevel >= MAX_GROUP_NESTED_LEVEL) {
            log.warn("JiraCrowdDAO#findNestedGroupsOf: giving up resolving nested groups for initial groups.size: {} at level: {}. Incomplete result contains: {} groups.Learn more: {}", new Object[]{groups.size(), nestedLevel, allNestedGroup.size(), LEARN_MORE_ABOUT_LIMITS_KB});
        }
        log.trace("JiraCrowdDAO#findNestedGroupsOf: input.groups.size:{}, result.groups.size:{}, timeInMillis:{}, numberOfSQLQueries:{}", new Object[]{groups.size(), allNestedGroup.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS), numberOfSQLQueries});
        return allNestedGroup.stream().map(ImmutableGroup::new).collect(Collectors.toSet());
    }

    private static int reasonableMax(int topN) {
        if (topN > MAX_TOP) {
            log.warn("Requested top N={}, which is greater than the max top allowed: {}. Enable trace logging to see the stack trace.", (Object)topN, (Object)MAX_TOP);
            if (log.isTraceEnabled()) {
                log.trace("Requested top N={} from:", (Object)topN, (Object)new Throwable());
            }
            return MAX_TOP;
        }
        return topN;
    }

    private List<UserDTO> findTopUsersMatchingNameInGroupsInternal(String searchName, Collection<Group> groups, int topN) {
        List dirIds = this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select(QDirectory.DIRECTORY.id).from((Expression)QDirectory.DIRECTORY)).where((Predicate)QDirectory.DIRECTORY.active.eq((Object)1))).fetch());
        log.trace("Number of active directories: {}", (Object)dirIds.size());
        if (groups.isEmpty()) {
            return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QUser.USER).from((Expression)QUser.USER)).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{UserSearchUtilities.userSearchQueryDSLPredicate(searchName), QUser.USER.active.eq((Object)1), QUser.USER.directoryId.in((Collection)dirIds)}))).orderBy(QUser.USER.lowerDisplayName.asc())).limit((long)topN)).fetch());
        }
        Set lowercaseGroups = groups.stream().map(Group::getName).map(IdentifierUtils::toLowerCase).collect(Collectors.toSet());
        SubQueryExpression membershipUserIdSubselect = groups.size() > BIG_NUMBER_OF_GROUPS ? (SubQueryExpression)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression)SQLExpressions.max((Expression)QMembership.MEMBERSHIP.lowerChildName)).from((Expression)QMembership.MEMBERSHIP)).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{QMembership.MEMBERSHIP.membershipType.eq((Object)MembershipType.GROUP_USER.name()), QMembership.MEMBERSHIP.lowerParentName.in(lowercaseGroups)}))).groupBy((Expression)QMembership.MEMBERSHIP.lowerChildName) : (SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression)QMembership.MEMBERSHIP.lowerChildName).from((Expression)QMembership.MEMBERSHIP)).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{QMembership.MEMBERSHIP.membershipType.eq((Object)MembershipType.GROUP_USER.name()), QMembership.MEMBERSHIP.lowerParentName.in(lowercaseGroups)}));
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QUser.USER).from((Expression)QUser.USER)).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{QUser.USER.lowerUserName.in(membershipUserIdSubselect), QUser.USER.directoryId.in((Collection)dirIds), UserSearchUtilities.userSearchQueryDSLPredicate(searchName), QUser.USER.active.eq((Object)1)}))).orderBy(QUser.USER.lowerDisplayName.asc())).limit((long)topN)).fetch());
    }

    List<String> findDirectChildrenOf(List<String> groupNames) {
        Preconditions.checkState((groupNames.size() <= GROUP_BATCH_SIZE ? 1 : 0) != 0);
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QMembership.MEMBERSHIP.childName).from((Expression)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QGroup.GROUP)).on(new Predicate[]{QMembership.MEMBERSHIP.childId.eq(QGroup.GROUP.id), QGroup.GROUP.active.eq((Object)1)})).innerJoin((EntityPath)QDirectory.DIRECTORY)).on(new Predicate[]{QMembership.MEMBERSHIP.directoryId.eq(QDirectory.DIRECTORY.id), QDirectory.DIRECTORY.active.eq((Object)1)})).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{QMembership.MEMBERSHIP.membershipType.eq((Object)MembershipType.GROUP_GROUP.name()), QMembership.MEMBERSHIP.parentName.in((Collection)groupNames)}))).fetch());
    }

    private static class UserQueryCacheKey {
        final Collection<Group> groups;
        final String search;
        final int topN;
        final int hashCode;

        private UserQueryCacheKey(String search, Collection<Group> groups, int topN) {
            this.groups = groups;
            this.search = Strings.nullToEmpty((String)search);
            this.topN = topN;
            this.hashCode = Objects.hash(groups, search, topN);
        }

        static UserQueryCacheKey create(String search, Collection<Group> groups, int topN) {
            return new UserQueryCacheKey(search, groups, topN);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserQueryCacheKey that = (UserQueryCacheKey)o;
            return this.topN == that.topN && this.groups.equals(that.groups) && this.search.equals(that.search);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "UserQueryCacheKey{groups=" + this.groups + ", search='" + this.search + '\'' + ", topN=" + this.topN + ", hashCode=" + this.hashCode + '}';
        }
    }
}

