/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.encryptors;

import com.atlassian.crowd.manager.crypto.EncryptionManager;
import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.admin.ApplicationPropertyMetadata;
import com.atlassian.jira.crowd.embedded.encryptors.ConcreteEncryptorsFactory;
import com.atlassian.jira.event.config.ApplicationPropertyChangeEvent;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public final class CrowdPasswordEncryptionAlgorithmChangeListener {
    private static final Logger log = LoggerFactory.getLogger(CrowdPasswordEncryptionAlgorithmChangeListener.class);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)CrowdPasswordEncryptionAlgorithmChangeListener.class.getName());
    private final EncryptionManager encryptionManager;
    private final SchedulerService schedulerService;
    private final EncryptionSettings encryptionSettings;
    private final ConcreteEncryptorsFactory encryptorsFactory;

    public CrowdPasswordEncryptionAlgorithmChangeListener(EncryptionManager encryptionManager, SchedulerService schedulerService, EncryptionSettings encryptionSettings, ConcreteEncryptorsFactory encryptorsFactory) {
        this.encryptionManager = encryptionManager;
        this.schedulerService = schedulerService;
        this.encryptionSettings = encryptionSettings;
        this.encryptorsFactory = encryptorsFactory;
    }

    @EventListener
    public void onApplicationPropertyChange(ApplicationPropertyChangeEvent event) {
        try {
            Map params = event.getParams();
            if (!(params.get("metadata") instanceof ApplicationPropertyMetadata)) {
                log.error("Unable to decide whether to re-encrypt passwords because the event doesn't seem to contain the correct metadata");
                return;
            }
            ApplicationPropertyMetadata metadata = (ApplicationPropertyMetadata)params.get("metadata");
            if ("crowd.encryption.encryptor.default".equals(metadata.getKey())) {
                String oldValue;
                String newValue = (String)params.get("newValue");
                if (StringUtils.compare((String)newValue, (String)(oldValue = (String)params.get("oldValue"))) == 0) {
                    log.info("Nothing really changed. Skipping re-encryption");
                } else if ("DISABLED".equals(newValue) || this.encryptorsFactory.getAvailableEncryptors().contains(newValue)) {
                    if ("DISABLED".equals(newValue)) {
                        newValue = null;
                    }
                    log.info("Scheduling re-encrypt");
                    this.schedulePasswordChange(newValue);
                } else {
                    log.error("Changed encryptor algorithm key to unsupported value. Rolling back change");
                    this.encryptionSettings.setDefaultEncryptor(oldValue);
                }
            }
        }
        catch (RuntimeException e) {
            log.error("Unable to re-encrypt passwords because of unexpected error", (Throwable)e);
        }
    }

    private void schedulePasswordChange(String newValue) {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, request -> {
            try {
                this.encryptionManager.changeEncryptor(newValue);
                return JobRunnerResponse.success();
            }
            catch (RuntimeException e) {
                return JobRunnerResponse.failed((Throwable)e);
            }
        });
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce(null));
        try {
            this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error("Failed to schedule re-encryption job", (Throwable)e);
        }
    }
}

